<?php

/*
 * @version		$Id: mod_yendifvideoshare_videos.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/
 
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
 
// Include the syndicate functions only once
if(!defined('DS')) { define('DS',DIRECTORY_SEPARATOR); }
require_once( dirname(__FILE__).DS.'helper.php' );
require_once( JPATH_ROOT.DS.'administrator'.DS.'components'.DS.'com_yendifvideoshare'.DS.'libraries'.DS.'utils.php' );
 
$config = YendifVideoShareUtils::getConfig();

$cols   = (int) $params->get('no_of_cols', $config->no_of_cols);
$rows   = (int) $params->get('no_of_rows', $config->no_of_rows);
$itemId = $params->get('itemid', JRequest::getInt('Itemid', 0));
$column = 0;

$show_views = $params->get('show_views', $config->show_views);
if( $show_views == 'global' ) {			
	$show_views = $config->show_views;			
}

$show_rating = $params->get('show_rating', $config->show_rating);
if( $show_rating == 'global' ) {			
	$show_rating = $config->show_rating;			
}

$enable_popup = $params->get('enable_popup', $config->enable_popup);
if( $enable_popup == 'global' ) {			
	$enable_popup = $config->enable_popup;			
}

$ratio = $params->get('ratio', $config->ratio);

$items = YendifVideoShareVideosHelper::getItems( $params, $config->schedule_video_publishing, $rows * $cols );
$limit  = count( $items );

$document = JFactory::getDocument();

if( $config->bootstrap_version == 3 ) $document->addStyleSheet( JURI::root()."media/yendifvideoshare/assets/site/css/bootstrap.css?v=1.2.5", 'text/css', "screen" );
$document->addStyleSheet( JURI::root()."media/yendifvideoshare/assets/site/css/yendifvideoshare.css?v=1.2.5", 'text/css', "screen" );
if( ! empty( $config->responsive_css ) ) $document->addStyleDeclaration( $config->responsive_css );

if( $enable_popup ) {
	JHtml::_('jquery.framework');

	$document->addStyleSheet( JURI::root().'media/yendifvideoshare/assets/site/css/magnific-popup.css?v=1.2.5', 'text/css', "screen" );
		
	$document->addScript( JURI::root().'media/yendifvideoshare/assets/site/js/jquery.magnific-popup.min.js?v=1.2.5' );
	$document->addScript( JURI::root().'media/yendifvideoshare/assets/site/js/yendifvideoshare.js?v=1.2.5' );
}

$moduleclass_sfx = htmlspecialchars( $params->get('moduleclass_sfx') );

require( JModuleHelper::getLayoutPath('mod_yendifvideoshare_videos') );