<?php

/*
 * @version		$Id: yendifvideoshare.php 1.2.5 10-10-2016 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies (P) Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// Get [or] Set the view
if( JRequest::getCmd('view') == 'category' && JRequest::getInt('id', 0) == 0 ) {
	JRequest::setVar('view', 'categories');
} else if( JRequest::getCmd('view') == 'video' && JRequest::getInt('id', 0) == 0 ) {
	JRequest::setVar('view', 'videos');
}
$view = JRequest::getCmd('view', 'categories');

$user = JFactory::getUser();
if( $view == 'user' ) {
	$userid = $user->get('id');
	if( ! $userid ) {		
		$app = JFactory::getApplication();
		$uri = JFactory::getURI();
		$loginURL = JRoute::_( 'index.php?option=com_users&view=login&return='.base64_encode( $uri->toString() ).'&Itemid='.JRequest::getInt('Itemid') );
		$app->redirect( $loginURL, JText::_('YENDIF_VIDEO_SHARE_PLEASE_LOGIN') );	
		return;
	}
}

// Define constants for all pages
if( ! defined('DS') ) define( 'DS',DIRECTORY_SEPARATOR );
define( 'YENDIF_VIDEO_SHARE_UPLOAD_DIR', 'media'.DS.'yendifvideoshare'.DS);
define( 'YENDIF_VIDEO_SHARE_UPLOAD_BASE', JPATH_ROOT.DS.YENDIF_VIDEO_SHARE_UPLOAD_DIR );
define( 'YENDIF_VIDEO_SHARE_UPLOAD_BASEURL', JURI::root().str_replace( DS, '/', YENDIF_VIDEO_SHARE_UPLOAD_DIR ));
define( 'YENDIF_VIDEO_SHARE_USERID', $user->get('id') );

// Register Libraries
JLoader::register('YendifVideoShareController', JPATH_COMPONENT_ADMINISTRATOR.'/controllers/controller.php');
JLoader::register('YendifVideoShareModel', JPATH_COMPONENT_ADMINISTRATOR.'/models/model.php');
JLoader::register('YendifVideoShareView', JPATH_COMPONENT_ADMINISTRATOR.'/views/view.php');
JLoader::register('YendifVideoShareFields', JPATH_COMPONENT_ADMINISTRATOR.'/libraries/fields.php');
JLoader::register('YendifVideoShareUpload', JPATH_COMPONENT_ADMINISTRATOR.'/libraries/upload.php');
JLoader::register('YendifVideoShareUtils', JPATH_COMPONENT_ADMINISTRATOR.'/libraries/utils.php');

// Require the base controller
$controller = JString::strtolower( $view );
require_once JPATH_COMPONENT.DS.'controllers'.DS.$controller.'.php';

// Initialize the controller
$classname  = 'YendifVideoShareController'.$controller;
$controller = new $classname();

// Perform the Request task
if( $layout = JRequest::getCmd('layout') ) {
	JRequest::setVar('task', $layout);
}

$controller->execute( JRequest::getCmd('task', $view) );
$controller->redirect();