<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version 2.0
 * @revision 726
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) 2013 by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

include_once "includes.php";

$extraWatch = new ExtraWatchMain();
require_once "lang" . DS . $extraWatch->config->getLanguage() . ".php";

$extraWatchHTML = new ExtraWatchHTML();
$extraWatchVisitHTML = new ExtraWatchVisitHTML($extraWatch);
$extraWatchBlockHTML = new ExtraWatchBlockHTML($extraWatch);


$extraWatch->block->checkPermissions();

echo("<h2>Timezone information</h2><table border='1'>");
echo "<tr><td>Server timezone: </td><td>" . "</td><td>User (Local) timezone: </td><td>" . $extraWatch->date->getUserTimezone() . "</td></tr>";
echo "<tr><td>Server timestamp:</td><td>" . $extraWatch->date->getUTCTimestamp() . "</td><td>Local timestamp:</td><td>" . $extraWatch->date->getUserTimestamp() . "</td></tr>";
echo "<tr><td>Actual Server Date Time: </td><td>" . $extraWatch->date->getActualDateTime() . "</td><td>Actual Local Date Time: </td><td>" . $extraWatch->date->getActualDateTime() . "</td></tr>";
//echo "<tr><td colspan='2'>Server-user timezone difference: ".     $extraWatch->date->getJoomlaTimezoneOffset()."</td></tr>";
echo("</table>");

echo "<h4>Local information:</h4>";
echo "Day of week: " . $extraWatch->date->dayOfWeek();
echo "<br/>Day of month: " . $extraWatch->date->dayOfMonth();
echo "<br/>Number of days since 1.1.1970: " . $extraWatch->date->jwDateToday();
echo "<br/>Current week: " . $extraWatch->date->getCurrentWeek();
echo "<br/>Week starting day:" . $extraWatch->date->getWeekStartingDay();

echo "<h4>Converters:</h4>";

$timestamp = $extraWatch->date->getUserTimestamp();
$output = "<table>";

//for ($timestamp = $extraWatch->date->getUserTimestamp() - 3600*7*24; $timestamp < $extraWatch->date->getUserTimestamp() + 3600*7*24; $timestamp+=3600) {
$output .= "<tr><td>Server time to local:</td><td>" . $extraWatch->date->UTCTimestampToUserTimestamp($extraWatch->date->getUTCTimestamp()) . "</td></tr>";
$output .= "<tr><td>Day of month: </td><td>jw date today:" . $extraWatch->date->jwDateToday() . " " . $extraWatch->date->getDateByDay($extraWatch->date->jwDateToday(), $format = "d.m.Y") . "</td></tr>";
$output .= "<tr><td>Week by timestamp $timestamp:</td><td>" . $extraWatch->date->getWeekFromTimestamp($timestamp) . "</td></tr>";
$output .= "<tr><td>Week since 1.1.1970 $timestamp:</td><td>" . $extraWatch->date->getWeekSince1970($timestamp) . "</td></tr>";
$output .= "<tr><td>Year by timestamp $timestamp:</td><td>" . $extraWatch->date->getYearFromTimestamp($timestamp) . "</td></tr>";
$output .= "<tr><td>Date by timestamp $timestamp:</td><td>" . $extraWatch->date->date($format, $timestamp) . "</td></tr>";
//}
$output .= "</table>";

echo($output);

$weekStartingDay = $extraWatch->date->getWeekStartingDay();
$weekStartingDayTimestamp = $weekStartingDay * 3600 * 24 - $extraWatch->date->getUserTimezone() * 3600;

echo("<h4>One previous week / one actual / and next week test</h4>");
$startTimestamp = $weekStartingDayTimestamp - 7 * 3600 * 24;
//this is ok, do not change !
echo("Starting from : $startTimestamp local: " . $extraWatch->date->date("D d.m.Y H:i:s", $startTimestamp));
$lastWeek = $extraWatch->date->getWeekSince1970($startTimestamp);
$lastDay = "";
$lastDateToday = "";
for ($i = $startTimestamp; $i < $weekStartingDayTimestamp + 14 * 3600 * 24; $i += 3600) {

  $day = $extraWatch->date->jwDateFromTimestamp($i);
  $week = $extraWatch->date->getWeekSince1970($i);
  $dow = $extraWatch->date->getDateByDay($day, "D");
  $dateToday = $extraWatch->date->getDateByDay($day);

  if ($week != $lastWeek) {
    $lastWeek = $week;
    echo("<br/><b>Week changes on: " . $i . " week: $week dow: $dow  what is locally: " . $extraWatch->date->date("d.m.Y H:i:s", $i) . "</b>");
    flush();
  }
  if ($day != $lastDay) {
    $lastDay = $day;
    echo("<br/>Day changes on: " . $i . " week: $week dow: $dow what is locally: " . $extraWatch->date->date("d.m.Y H:i:s", $i));
    flush();
  }
  if ($dateToday != $lastDateToday) {
    $lastDateToday = $dateToday;
    echo("<br/>Function getDateByDay changes on: " . $i . " week: $week dow: $dow what is locally: " . $extraWatch->date->date("d.m.Y H:i:s", $i));
  }


}


