<?php

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// CLASS: ip2country - Find country from netblocks
//
// Copyright (C) 1987-2004 Pascal Toussaint <pascal@pascalz.com>
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// This script uses the IP-to-Country Database
// provided by WebHosting.Info (http://www.webhosting.info),
// available from http://ip-to-country.webhosting.info.
//
// Download latest database at
// http://ip-to-country.directi.com/downloads/ip-to-country.csv.zip
//
// Look the latest file date (format YYYYMMDD)
// http://ip-to-country.directi.com/downloads/latest
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
// Id: class.ip2country.php,v 1.4 2004/02/01 07:24:54 pascalz Exp $
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

/** ensure this file is being included by a parent file */
if (!defined('_JEXEC') && !defined('_VALID_MOS')) {
  die('Restricted access');
}


/** Class renamed only to avoid name clashes (originally named ip2country) */
class ExtraWatchIP2Country {
  public $CVSFile; // the ip-to-country.csv file
  public $IP; // IP to looking for

  public $Prefix1; // Country prefix (2char) ex.: US
  public $Prefix2; // Country prefix (3char) ex.: USA
  public $Country; // Country name  ex.: UNITED STATE

  public $UseDB = TRUE; // Use database instead csv file (more fast)

  // db values
  public $db_host; // host information for database connection
  public $db_login; // login information for database connection
  public $db_password; // password information for database connection
  public $db_basename; // base information for database connection
  public $db_tablename; // Your own table name
  public $db_ip_from_colname; // Your own ip_from column name
  public $db_ip_to_colname; // Your own ip_to column name
  public $db_prefix1_colname; // Your own prefix1 column name
  public $db_prefix2_colname; // Your own prefix2 column name
  public $db_country_colname; // Your own country column name

  public $_IPn; // Private - network address

  public $env;
  public $database;

  // Constructor
  function __construct($ip, $usedb = FALSE)
  {
    $this->env = ExtraWatchEnvFactory::getEnvironment();
    $this->database = $this->env->getDatabase();
    // TODO: Add regex to verify ip is valid
    if ($ip) {
      $this->_IPn = $this->inet_aton($ip);
      $this->IP = $ip;
    }

    $this->CVSFile = dirname(__FILE__) . "\ip-to-country.csv";
    $this->UseDB = $usedb;

    // Default value
    $this->db_host = "localhost";
    $this->db_tablename = "ip2c";
    $this->db_ip_from_colname = "start";
    $this->db_ip_to_colname = "end";
    $this->db_prefix1_colname = "cc";
    $this->db_prefix2_colname = "a3";
    $this->db_country_colname = "country";
  }

  // Look in file or database
  function LookUp()
  {
    if (!@$this->database) {
      $this->env = ExtraWatchEnvFactory::getEnvironment();
      $this->database = & $this->env->getDatabase();
    }

    if ($this->UseDB) {
      /*
      * The Fastest Way is to import the CSV file in your database and to
      * set UseDB to TRUE !
      * I use MySQL but feel free to use your database functions ;)
      */

      $query = sprintf("SELECT %s FROM %s WHERE %s >= %s AND %s <= %s",
        $this->database->getEscaped($this->db_country_colname),
        $this->database->getEscaped($this->db_tablename),
        $this->database->getEscaped($this->_IPn),
        $this->database->getEscaped($this->db_ip_from_colname),
        $this->database->getEscaped($this->_IPn),
        $this->database->getEscaped($this->db_ip_to_colname));
      $rows = $this->database->objectListQuery($query);

      $row = @ $rows[0];
      if ($row) {
        $country_colname = $this->db_country_colname;
        $this->Country = $row->$country_colname;

        return TRUE;
      } else
        return FALSE;

      //			mysql_close($conn);

    }
  }

  // Unquote a string...if quoted
  function unquote(& $str)
  {
    $str = trim($str);

    if (($str[0] == '"') && ($str[strlen($str) - 1] == '"')) {
      $str = substr($str, 1, strlen($str) - 2);
    }
  }

// Recreate inet_aton function like in mySQL
// convert Internet dot address to network address
  function inet_aton($ip)
  {
    if (strstr($ip, '.')) { //is IPv4
      $ip_array = explode(".", $ip);
      /*
          if (!isset($ip_array)) {
              return;
          }
      */
      return ($ip_array[0] * pow(256, 3)) + ($ip_array[1] * pow(256, 2)) + ($ip_array[2] * 256) + $ip_array[3];
    } else {            //is IPv6 - we don't have IPv6 database now
      return 0;
    }
  }

}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

