<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version 2.0
 * @revision 726
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) 2013 by CodeGravity.com - All rights reserved!
 * @website http://www.extrawatch.com
 */

/** ensure this file is being included by a parent file */
if (!defined('_JEXEC') && !defined('_VALID_MOS'))
    die('Restricted access');

class ExtraWatchGoal
{

    public $database;
    public $helper;
    public $stat;
    public $block;

    function __construct($database)
    {
        $this->database = $database;
        $this->helper = new ExtraWatchHelper($this->database);
        $this->stat = new ExtraWatchStat($this->database);
        $this->block = new ExtraWatchBlock($this->database);
    }

    /**
     * goals
     */
    function getGoals()
    {
        $query = "select * from #__extrawatch_goals ";
        $rows = @ $this->database->objectListQuery($query);
        return @ $rows;
    }

    /**
     * goals
     */
    function getGoalNameById($id)
    {
        $query = sprintf("select name from #__extrawatch_goals where id = '%d'", (int) $id);
        $rows = @ $this->database->objectListQuery($query);
        $row = @ $rows[0];
        return @ $row->name;
    }


    /**
     * goals
     */
    function getGoalById($id)
    {

        //lower case id
        $id = strtolower($id);
        $query = sprintf("select * from #__extrawatch_goals where id = '%d' limit 1 ", (int) $id);
        $rows = $this->database->assocListQuery($query);
        $row = @ $rows[0];
        return $row;

    }

    /**
     * goals
     */
    function deleteGoal($id)
    {
        $query = sprintf("delete from #__extrawatch_goals where id = '%d' limit 1", (int) $id);
        //TODO delete everyting from logs as well!
        $result = $this->database->executeQuery($query);

        $query = sprintf("delete from #__extrawatch_info where (`group`='%d' and name='%d')", (int)EW_DB_KEY_GOALS, (int) $id);
        $this->database->executeQuery($query);
        return $result;
    }

    /**
     * goals
     */
    function enableGoal($id)
    {
        $query = sprintf("update #__extrawatch_goals set disabled = NULL where id = '%d'", (int) $id);
        return $this->database->executeQuery($query);
    }

    /**
     * goals
     */
    function disableGoal($id)
    {
        $query = sprintf("update #__extrawatch_goals set disabled = 1 where id = '%d'", (int) $id);
        return $this->database->executeQuery($query);
    }

    /**
     * goals
     */
    function getGoalCount($id)
    {
        $query = sprintf("select sum(value) as sum from #__extrawatch_info where `group` = '" . EW_DB_KEY_GOALS . "' and name = '%d'", (int) $id);
        $sum = $this->database->resultQuery($query);
        return $sum;
    }

    /**
     * goals
     */
    function saveGoal($post)
    {
        $allowedFields = unserialize(EXTRAWATCH_GOALS_ALLOWED_FIELDS);
        $keys = array();
        $values = array();
        foreach ($post as $key => $value) {
            if (array_search($key, $allowedFields)) {
                $keys[] = strtolower($key);
                $value = sprintf("%s", $this->database->getEscaped($value));
                $values[] = "'".strtolower($value)."'";
            }
        }
        $keysImploded = implode(",", $keys);
        $valuesImploded = implode(",", $values);

        $id = @ $post['id'];
        if (@ $id) {    // update
            for($i=0;$i<sizeof($keys)-1;$i++) {
                $updateKeys[] = $keys[$i]." = ". $values[$i]."";
            }
            $updateQuery = implode(", ", $updateKeys);
            $query = sprintf("update #__extrawatch_goals set %s  where id = '%d'", $updateQuery, (int) $id);
            $result = $this->database->executeQuery($query);
        } else {
            // insert
            $query = "insert into #__extrawatch_goals (id, ".$keysImploded.") values ('',".$valuesImploded.")";
            $result = $this->database->executeQuery($query);
        }
        return $result;
    }

    /**
     * goals
     */
    function checkGoals($title, $username, $ip, $came_from, $liveSite = "")
    {
        global $mainframe;

        $country = $this->helper->countryByIp($ip);

        $query = sprintf("select * from #__extrawatch_goals");
        $rows = $this->database->objectListQuery($query);
        if (@$rows)
            foreach ($rows as $row) {

                $achieved = FALSE;
                if ($row->disabled)
                    continue;

                if (trim($row->uri_inversed) == "on") {
                    if (trim($row->uri_condition)) {
                        if (@ $this->helper->wildcardSearch($row->uri_condition, trim($this->helper->getURI()))) {
                            continue;
                        } else
                            $achieved = TRUE;
                    }
                } else {
                    if (trim($row->uri_condition)) {
                        if (@ $this->helper->wildcardSearch($row->uri_condition, trim($this->helper->getURI()))) {
                            $achieved = TRUE;
                        } else
                            continue;
                    }
                }

                if (trim($row->get_inversed) == "on") {
                    if (trim($row->get_condition)) {
                        if (@ $this->helper->wildcardSearch($row->get_condition, trim(ExtraWatchHelper::requestGet($row->get_var)))) {
                            continue;
                        } else
                            if ($row->get_var == "*") {
                                $found = FALSE;
                                foreach (ExtraWatchHelper::requestGet() as $get) {
                                    if ($this->helper->wildcardSearch($row->get_condition, trim($get))) {
                                        $found = TRUE;
                                    }
                                }
                                if ($found) continue;
                            } else
                                $achieved = TRUE;
                    }
                } else {
                    if (trim($row->get_condition)) {
                        if (@ $this->helper->wildcardSearch($row->get_condition, trim(ExtraWatchHelper::requestGet($row->get_var)))) {
                            $achieved = TRUE;
                        } else
                            if ($row->get_var == "*") {
                                foreach (ExtraWatchHelper::requestGet() as $get) {
                                    if ($this->helper->wildcardSearch($row->get_condition, trim($get))) {
                                        $achieved = TRUE;
                                    }
                                }
                            } else
                                continue;
                    }
                }

                if (trim($row->post_inversed) == "on") {
                    if (trim($row->post_condition)) {
                        if (@ $this->helper->wildcardSearch($row->post_condition, trim(ExtraWatchHelper::requestPost($row->post_var)))) {
                            continue;
                        } else
                            if ($row->post_var == "*") {
                                $found = FALSE;
                                foreach (ExtraWatchHelper::requestPost() as $post) {
                                    if ($this->helper->wildcardSearch($row->post_condition, trim($post))) {
                                        $found = TRUE;
                                    }
                                }
                                if ($found) continue;
                            } else
                                $achieved = TRUE;
                    }
                } else {
                    if (trim($row->post_condition)) {
                        if (@ $this->helper->wildcardSearch($row->post_condition, trim(ExtraWatchHelper::requestPost($row->post_var)))) {
                            $achieved = TRUE;
                        } else
                            if ($row->post_var == "*") {
                                foreach (ExtraWatchHelper::requestPost() as $post) {
                                    if ($this->helper->wildcardSearch($row->post_condition, trim($post))) {
                                        $achieved = TRUE;
                                    }
                                }
                            } else
                                continue;
                    }
                }

                if (trim($row->title_inversed) == "on") {
                    if (trim($row->title_condition)) {
                        if (@ $this->helper->wildcardSearch($row->title_condition, trim($title))) {
                            continue;
                        } else
                            $achieved = TRUE;
                    }
                } else {
                    if (trim($row->title_condition)) {
                        if (@ $this->helper->wildcardSearch($row->title_condition, trim($title))) {
                            $achieved = TRUE;
                        } else
                            continue;
                    }
                }

                if (trim($row->username_inversed) == "on") {
                    if (trim($row->username_condition)) {
                        if (@ $this->helper->wildcardSearch($row->username_condition, trim($username))) {
                            continue;
                        } else
                            $achieved = TRUE;
                    }
                } else {
                    if (trim($row->username_condition)) {
                        if (@ $this->helper->wildcardSearch($row->username_condition, trim($username))) {
                            $achieved = TRUE;
                        } else
                            continue;
                    }
                }

                if (trim($row->ip_inversed) == "on") {
                    if (trim($row->ip_condition)) {
                        if (@ $this->helper->wildcardSearch($row->ip_condition, trim($ip))) {
                            continue;
                        } else
                            $achieved = TRUE;
                    }
                } else {
                    if (trim($row->ip_condition)) {
                        if (@ $this->helper->wildcardSearch($row->ip_condition, trim($ip))) {
                            $achieved = TRUE;
                        } else
                            continue;
                    }
                }

                if (trim($row->came_from_inversed) == "on") {
                    if (trim($row->came_from_condition)) {
                        if (@ $this->helper->wildcardSearch($row->came_from_condition, trim($came_from)) || $this->helper->wildcardSearch($liveSite . $row->came_from_condition, trim($came_from))) {
                            continue;
                        } else
                            $achieved = TRUE;
                    }
                } else {
                    if (trim($row->came_from_condition)) {
                        if (@ $this->helper->wildcardSearch($row->came_from_condition, trim($came_from)) || $this->helper->wildcardSearch($liveSite . $row->came_from_condition, trim($came_from))) {
                            $achieved = TRUE;
                        } else
                            continue;
                    }
                }

                if (trim($row->country_inversed) == "on") {
                    if (trim($row->country_condition)) {
                        if (@ $this->helper->wildcardSearch($row->country_condition, trim($country))) {
                            continue;
                        } else
                            $achieved = TRUE;
                    }
                } else {
                    if (trim($row->country_condition)) {
                        if (@ $this->helper->wildcardSearch($row->country_condition, trim($country))) {
                            $achieved = TRUE;
                        } else
                            continue;
                    }
                }

                if ($achieved) {
                    $this->stat->increaseKeyValueInGroup(EW_DB_KEY_GOALS, $row->id);

                    if (@ $row->redirect) {
                        if ($mainframe) {
                            $mainframe->redirect(@ $row->redirect);
                        } else {
                            $mainframe =& JFactory::getApplication('site');
                            $mainframe->redirect(@ $row->redirect);
                        }

                    }
                    if (@ $row->block) {
                        $this->block->dieWithBlockingMessage($ip);
                    }
                }

            }
    }

    /**
     *  Export Goals
     */
    function exportGoals()
    {
        $query = "select * from #__extrawatch_goals ";
        $rows = @ $this->database->assocListQuery($query);

        $output = "<?xml version=\"1.0\" ?>\n";
        $output .= "<goals>"; // iterate over each table and return the fields for each table
        foreach ($rows as $key => $row) {
            $output .= "<goal>";
            foreach ($row as $resultKey => $resultRow) {
                if ($resultKey != 'id') {
                    $output .= "<" . $resultKey . ">" . $resultRow . "</" . $resultKey . ">";
                }
            }
            $output .= "</goal>";
        }

        $output .= "</goals>";
        $xmlFile = "extrawatch-goals-" . date('Ymd') . ".xml";
        $xmlHandle = fopen($xmlFile, "w"); //--- write xml to file ---
        fwrite($xmlHandle, $output);
        fclose($xmlHandle); // tell the browser what kind of file is come in
        return @ $output;
    }

    function saveImportGoal($post)
    {
        if ((($_FILES["file"]["type"] == "text/xml"))) {
            if ($_FILES["file"]["error"] > 0) {
                echo "Return Code: " . $_FILES["file"]["error"] . "<br />";
            } else {
                if (file_exists(JPATH_BASE . "/" . $_FILES["file"]["name"])) {
                    echo $_FILES["file"]["name"] . " already exists. ";
                } else {
                    move_uploaded_file($_FILES["file"]["tmp_name"], JPATH_BASE . "/" . $_FILES["file"]["name"]);
                    //XML Read
                    $doc = new DOMDocument();
                    $doc->load($_FILES['file']['name']);

                    $goals = $doc->getElementsByTagName("goal");
                    foreach ($goals as $goal) {
                        $names = $goal->getElementsByTagName("name");
                        $name = $names->item(0)->nodeValue;

                        $username_inverseds = $goal->getElementsByTagName("username_inversed");
                        $username_inversed = $username_inverseds->item(0)->nodeValue;

                        $parentIds = $goal->getElementsByTagName("parentId");
                        $parentId = $parentIds->item(0)->nodeValue;

                        $uri_conditions = $goal->getElementsByTagName("uri_condition");
                        $uri_condition = $uri_conditions->item(0)->nodeValue;

                        $uri_inverseds = $goal->getElementsByTagName("uri_inversed");
                        $uri_inversed = $uri_inverseds->item(0)->nodeValue;

                        $get_vars = $goal->getElementsByTagName("get_var");
                        $get_var = $get_vars->item(0)->nodeValue;

                        $get_conditions = $goal->getElementsByTagName("get_condition");
                        $get_condition = $get_conditions->item(0)->nodeValue;

                        $get_inverseds = $goal->getElementsByTagName("get_inversed");
                        $get_inversed = $get_inverseds->item(0)->nodeValue;

                        $post_vars = $goal->getElementsByTagName("post_var");
                        $post_var = $post_vars->item(0)->nodeValue;

                        $post_conditions = $goal->getElementsByTagName("post_condition");
                        $post_condition = $post_conditions->item(0)->nodeValue;

                        $post_inverseds = $goal->getElementsByTagName("post_inversed");
                        $post_inversed = $post_inverseds->item(0)->nodeValue;

                        $title_conditions = $goal->getElementsByTagName("title_condition");
                        $title_condition = $title_conditions->item(0)->nodeValue;

                        $title_inverseds = $goal->getElementsByTagName("title_inversed");
                        $title_inversed = $title_inverseds->item(0)->nodeValue;

                        $username_conditions = $goal->getElementsByTagName("username_condition");
                        $username_condition = $username_conditions->item(0)->nodeValue;

                        $ip_conditions = $goal->getElementsByTagName("ip_condition");
                        $ip_condition = $ip_conditions->item(0)->nodeValue;

                        $ip_inverseds = $goal->getElementsByTagName("ip_inversed");
                        $ip_inversed = $ip_inverseds->item(0)->nodeValue;

                        $came_from_conditions = $goal->getElementsByTagName("came_from_condition");
                        $came_from_condition = $came_from_conditions->item(0)->nodeValue;

                        $came_from_inverseds = $goal->getElementsByTagName("came_from_inversed");
                        $came_from_inversed = $came_from_inverseds->item(0)->nodeValue;

                        $country_conditions = $goal->getElementsByTagName("country_condition");
                        $country_condition = $country_conditions->item(0)->nodeValue;

                        $country_inverseds = $goal->getElementsByTagName("country_inversed");
                        $country_inversed = $country_inverseds->item(0)->nodeValue;

                        $blocks = $goal->getElementsByTagName("block");
                        $block = $blocks->item(0)->nodeValue;

                        $redirects = $goal->getElementsByTagName("redirect");
                        $redirect = $redirects->item(0)->nodeValue;

                        $disableds = $goal->getElementsByTagName("disabled");
                        $disabled = $disableds->item(0)->nodeValue;

                        //Check the Goal is exist or not
                        $query = sprintf("select name from #__extrawatch_goals where name = '$name'");
                        $rows = @ $this->database->assocListQuery($query);
                        if (empty($rows)) {
                            $value = "'$name','$username_inversed','$parentId','$uri_condition','$uri_inversed','$get_var','$get_condition','$get_inversed',                                     '$post_var','$post_condition','$post_inversed','$title_condition','$title_inversed','$username_condition','$ip_condition','$ip_inversed',                                     '$came_from_condition','$came_from_inversed','$country_condition','$country_inversed','$block','$redirect','$disabled'";
                            //$query = sprintf("insert into #__extrawatch_goals values('NULL','$name','$username_inversed','$parentId','$uri_condition','$uri_inversed','$get_var','$get_condition','$get_inversed','$post_var','$post_condition','$post_inversed','$title_condition','$title_inversed','$username_condition','$ip_condition','$ip_inversed','$came_from_condition','$came_from_inversed','$country_condition','$country_inversed','$block','$redirect','$disabled')");

                            $query = sprintf("insert into #__extrawatch_goals values('NULL',$value)");
                            $result = $this->database->executeQuery($query);
                        }
                    } //Delete uploaded file
                    unlink($_FILES["file"]["name"]);
                }
            }
        } else {
            echo "Invalid file";
        }
        return $result;
    }

}


