<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "Statistika uživo");
DEFINE('_EW_MENU_GOALS', "Ciljevi");
DEFINE('_EW_MENU_SETTINGS', "Podešavanja");
DEFINE('_EW_MENU_CREDITS', "Zasluge");
DEFINE('_EW_MENU_FAQ', "FAQ");
DEFINE('_EW_MENU_DOCUMENTATION', "Dokumentacija");
DEFINE('_EW_MENU_LICENSE', "Dozvole");
DEFINE('_EW_MENU_DONATORS', "Donacije");
DEFINE('_EW_MENU_SUPPORT', "Podržite ExtraWatch i uklonite reklame sa vaše komponente.");


// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Poslednji posetioci");
DEFINE('_EW_VISITS_BOTS', "Botovi");
DEFINE('_EW_VISITS_CAME_FROM', "Dolaze iz");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Vaš ExtraWatch modul nije objavljen. Nova statistika nije zabeležena. Kako bi ste modul objavili iditi u sekciju Moduli i objavite na svim stranama");
DEFINE('_EW_VISITS_PANE_LOADING', "Učitavanje poseta...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Nedeljna statistika poseta");
DEFINE('_EW_STATS_WEEK', "Nedelja");
DEFINE('_EW_STATS_THIS_WEEK', "ove nedelje");
DEFINE('_EW_STATS_UNIQUE', "jedinstven");
DEFINE('_EW_STATS_LOADS', "učitavanja");
DEFINE('_EW_STATS_HITS', "poseta");
DEFINE('_EW_STATS_TODAY', "danas");
DEFINE('_EW_STATS_FOR', "za");
DEFINE('_EW_STATS_ALL_TIME', "Ukupno");
DEFINE('_EW_STATS_EXPAND', "proširi");
DEFINE('_EW_STATS_COLLAPSE', "smanji");
DEFINE('_EW_STATS_URI', "Strana");
DEFINE('_EW_STATS_COUNTRY', "Države");
DEFINE('_EW_STATS_USERS', "Korisnici");
DEFINE('_EW_STATS_REFERERS', "Referali");
DEFINE('_EW_STATS_IP', "IP adrese");
DEFINE('_EW_STATS_BROWSER', "Pretraživači");
DEFINE('_EW_STATS_OS', "OS");
DEFINE('_EW_STATS_KEYWORDS', "Ključne reči");
DEFINE('_EW_STATS_GOALS', "Ciljevi");
DEFINE('_EW_STATS_TOTAL', "Ukupno");
DEFINE('_EW_STATS_DAILY', "Dnevno");
DEFINE('_EW_STATS_DAILY_TITLE', "Dnevna statistika");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Ukupna statistika");
DEFINE('_EW_STATS_LOADING', "učitavanje...");
DEFINE('_EW_STATS_LOADING_WAIT', "učitavanje... molimo vas, sačekajte");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "IP blokiranje");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Unesite IP ručno");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Unesite IP adresu koju želite da blokirate. (npr. 217.242.11.54 or 217.* ili 217.242.* kako bi ste blokirali sve IP adrese iz opsega)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Preklapanje IP adresa ");
DEFINE('_EW_STATS_PANE_LOADING', "Učitavanje statistike...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Podešavanja");
DEFINE('_EW_SETTINGS_DEFAULT', "Podrazumevano");
DEFINE('_EW_SETTINGS_SAVE', "Sačuvaj");
DEFINE('_EW_SETTINGS_APPEARANCE', "Izgled");
DEFINE('_EW_SETTINGS_FRONTEND', "Čeona aplikacija");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Evidencija &amp; Performanse");
DEFINE('_EW_SETTINGS_ADVANCED', "Napredno");
DEFINE('_EW_SETTINGS_IGNORE', "Ignoriši");
DEFINE('_EW_SETTINGS_BLOCKING', "Blokiranje");
DEFINE('_EW_SETTINGS_EXPERT', "Ekspert");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Da li zaista želite da resetujete svu statistiku i podatke o posetiocima?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Resetujte sve");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Resetujte &amp; podatke posetioca");
DEFINE('_EW_SETTINGS_LANGUAGE', "Jezik");
DEFINE('_EW_SETTINGS_SAVED', "Podešavanje sačuvano");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Dodajte vaš IP");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "na listu.");

// Other / mostly general.
DEFINE('_EW_TITLE', "AJAX joomla nadgledanje u realnom vremenu");
DEFINE('_EW_BACK', "Nazad");
DEFINE('_EW_ACCESS_DENIED', "Nemate dozvolu da vidite ovo!");
DEFINE('_EW_LICENSE_AGREE', "Slažem se sa uslovima korišćenja iznad");
DEFINE('_EW_LICENSE_CONTINUE', "Nastavi");
DEFINE('_EW_SUCCESS', "Operacija uspešna");
DEFINE('_EW_RESET_SUCCESS', "Sva statistika i podaci o posetiocima uspešno obrisani");
DEFINE('_EW_RESET_ERROR', "Podaci NISU uspešno obrisani, došlo je do greške");
DEFINE('_EW_CREDITS_TITLE', "Zasluge");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Dnevna i nedeljna statistika za ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "AJAX dozvola odbijena: Molimo vas pogledajte statistiku sa vašeg domena koju ste specifirali u fajlu configuration.php Joomla-e - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Moguće da ste zaboravili www. na početku naziva vašeg domena. Vaš javascript pokušava da pristupi ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "sa");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "zbog čega misli da pristupa drugom domenu.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Nabavite poslednji kod ekstenzije sa ");
DEFINE('_EW_HEADER_CAST_YOUR', "Molimo glasajte");
DEFINE('_EW_HEADER_VOTE', "Glasajte");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "Kliknite za opis alata");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Pređite mišem iznad kako bi ste videli opis alatke");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "jučerašnje povećanje");
DEFINE('_EW_TOOLTIP_HELP', "Otvara spoljašnju online pomoć ");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Zatvori ovaj prozor");
DEFINE('_EW_TOOLTIP_PRINT', "Štampaj");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Unesite novi cilj");
DEFINE('_EW_GOALS_UPDATE', "Ažurirajte cilj no.");
DEFINE('_EW_GOALS_ACTION', "Akcija");
DEFINE('_EW_GOALS_TITLE', "Novi cilj");
DEFINE('_EW_GOALS_NEW', "Novi cilj");
DEFINE('_EW_GOALS_RELOAD', "Ponovno učitavanje");
DEFINE('_EW_GOALS_ADVANCED', "Napredno");
DEFINE('_EW_GOALS_NAME', "Ime");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "URI uslov");
DEFINE('_EW_GOALS_URI_INVERSED', "URI inverzni uslog");
DEFINE('_EW_GOALS_GET_VAR', "GET var");
DEFINE('_EW_GOALS_GET_CONDITION', "GET uslov");
DEFINE('_EW_GOALS_POST_VAR', "POST Var");
DEFINE('_EW_GOALS_POST_CONDITION', "POST uslov");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Title uslov");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Username uslov");
DEFINE('_EW_GOALS_IP_CONDITION', "IP uslov");
DEFINE('_EW_GOALS_IP_INVERSED', "IP inverzni uslov");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Came from uslov");
DEFINE('_EW_GOALS_BLOCK', "Blokiraj");
DEFINE('_EW_GOALS_REDIRECT', "Preusmeri ka URL");
DEFINE('_EW_GOALS_HITS', "Poseta");
DEFINE('_EW_GOALS_ENABLED', "Omogućeno");
DEFINE('_EW_GOALS_EDIT', "Izmeni");
DEFINE('_EW_GOALS_DELETE', "Obriši");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "Izgubićete sve statističke podakte za ovaj cilj. Da li zaista želite da obrišete cilj br. ");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Države");
DEFINE('_EW_FRONTEND_VISITORS', "Posetioci");
DEFINE('_EW_FRONTEND_TODAY', "Danas");
DEFINE('_EW_FRONTEND_YESTERDAY', "Juče");
DEFINE('_EW_FRONTEND_THIS_WEEK', "Ove nedelje");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Prošle nedelje");
DEFINE('_EW_FRONTEND_THIS_MONTH', "Ovog meseca");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Prošlog meseca");
DEFINE('_EW_FRONTEND_TOTAL', "Ukupno");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch je u režimu otklanjanja grešaka. Na ovaj način moćićete da otkrijete uzroke grešaka. Da isključite ovaj režim promenite vrednosti iz EXTRAWATCH_DEBUG in /components/com_extrawatch/config.php iz 1 u 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Maksimalan broj redova za prikaz kada je statistika u proširenom režimu.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Sve IP adrese koje imaju manje poseta u odnosu na današnji dan biće obrisane iz IP evidencije.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Svi URL-ovi koji imaju manje poseta u odnosu na današnji dan biće obrisani iz IP evidencije.");
DEFINE('_EW_DESC_IGNORE_IP', "Izostavi određene IP adrese iz statistike. Odvoji novom linijom. Možete koristiti džokera ovde. <br/>Npr. 192.* će ignorisati 192.168.51.31, 192.168.16.2, itd..");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Osvežavanje statistike posetioca u milisekundama. Podrazumevano je 2000, budite oprezni sa ovim. Nakon toga ponovo učitajte pozadinsku aplikaciju ExtraWatch.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Vreme osvežavanja statistike u milisekundama je podrazumevano 4000, budite oprezni sa ovim. Nakon toga ponovo učitajte pozadinsku aplikaciju ExtraWatch.");
DEFINE('_EW_DESC_MAXID_BOTS', "Koliko poseta botova čuvati u bazi.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Koliko stvarnih poseta čuvati u bazi.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Koliko botova ćete videti u pozadinskoj aplikaciji.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Koliko stvarnih posetioca ćete videti u pozadinskoj aplikaciji.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Maksimalan broj znakova za prikaz u dugim naslovima i URI-ovima.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Maksimalan broj za prikaz u panelu na desnoj strani.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Koliko dana čuvati statistiku u bazi, 0 = beskonačno.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "Kada ste u drugoj vremenskoj zoni od vašeg servera za hosting. (pozitivne ili negativne vrednosti u satima)");
DEFINE('_EW_DESC_WEEK_OFFSET', "Pomak nedelje, vremenska oznaka/(3600*24*7) daje broj nedelja od 1.1.1970, ovaj pomak je korekcija kako bi nedelja počela ponedeljkom.");
DEFINE('_EW_DESC_DAY_OFFSET', "Pomak dana, vremenska oznaka/(3600*24) daje broj dana od 1.1.1970, ovaj pomak je korekcija kako bi dan počeo u 00:00.");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(funkcioniše u PRO verziji)</b> Za korišćenje prazne 1x1px ikone u čeonoj aplikaciji");
DEFINE('_EW_DESC_IP_STATS', "Omogućava statistiku IP adresa. U nekim zemljama držanje IP adresa u bazi duže vreme je zabranjeno zakonom. Koristite na sopstveni rizik.");
DEFINE('_EW_DESC_HIDE_ADS', "Ovo podešavanje sakriva reklame iz pozadinske aplikacije u slučaju da vas zaista iritiraju. Držeći ih podržavate dalji razvoj ove alatke. Hvala.");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Otčekirajte ako želite da vam se opis alatke prikazuje na klik mišem a ne prelaskom preko.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "Podrazumevan je 'REDIRECT_URL', koji je standard ukoliko koristite url rewriting, može se podesiti na 'SCRIPT_URL' ako evidentira samo index.php");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Poruka koja se prikazuje blokiranim korisnicima ili opširnija informacija zašto ih blokirate.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Dužina opisa alatke");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Visina opisa alatke");
DEFINE('_EW_DESC_TOOLTIP_URL', "Možete staviti bilo koji URL ovde kako bi ste videli IP posetitelja. {ip} će biti zamenjem posetiteljevim ip-em. Npr. http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "Možete uneti bilo koji URI koji želite da bude ignorisan u statistici. Možete koristiti džokere (* i ?) ovde. Npr.: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Dajte naziv cilju. Taj naziv videćete u statistici.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Sve što je iza naziva domena. Za http://www.codegravity.com/projects/ URI je: /projects/ (Primer za korišćenje: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "GET varijabla je varijabla koju možete videti u URL-u obično posle ? ili &amp; znaka. Npr. http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. Možete koristiti <u>*</u> u ovom polju kako bi ste skenirali sve get vrednosti. (Primer za korišćenje: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Ovde treba da odredite podudaranje za vrednost iz prethodnog polja. (Primer za korišćenje: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Ovde proveravamo vrednosti prosleđene iz obrazaca. Recimo kada imate obrazac na vašem sajtu koje ima polje&lt;input type='text' name='<u>experiences</u>' /&gt;. (Primer korišćenja: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "Podudaranje za vrednosti ovog POST polja. Npr. želimo da proverimo da li korisnik ima podršku za java. (Primer korišćenja: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "Naziv stranice koji mora da se podudara. (Primer korišćenja: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "Ime logovanog korisnika. (Primer korišćenja: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "IP odakle dolazi korisnik: (Primer korišćenja: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "URL sa koga je korisnik došao. (Primer korišćenja: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "Korisnik je preusmeren na URL koji ste vi odredili. Ima veći prioritet od 'blokiranja': (Primer korišćenja: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Koliko karaktera skratiti u tabeli ciljeva.");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(funkcioniše u PRO verziji)</b> Link ka codegravity.com možete isključiti, mada bi smo vam bili zahvalni ako bi ste ga ostavili. Hvala vam");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Prikaži ukupnu statistiku država u čeonom modulu. Ako se promeni, nove vrednosti važiće u čeonom delu nakon vremena određenog u CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Ako želite da zamenite red Posetioci/Države u čeonoj aplikaciji, odštiklirajte ovo i Posetioci će se prikazivati prvi.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Broj država koji se prikazuje u čeonoj aplikaciji");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Prikaži posetioce iz država u čeonom modulu. Ako se promeni, podešavanja će biti važeća u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Vreme u sekundama za keširanje vremena prenosa podataka za zemlje u čeonoj aplikaciji.");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Vreme u sekundama za keširanje prenosa podataka posetioca u čeonoj aplikaciji.");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "Za prikaz posetioca u čeonoj aplikaciji za: danas. Ako se promeni, nova podešavanja važiće u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "Za prikaz posetioca u čeonoj aplikaciji za: juče. Ako se promeni, nova podešavanja važiće u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "Za prikaz posetioca u čeonoj aplikaciji za: ova nedelja. Ako se promeni, nova podešavanja važiće u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "Za prikaz posetioca u čeonoj aplikaciji za: prošla nedelja. Ako se promeni, nova podešavanja važiće u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "Za prikaz posetioca u čeonoj aplikaciji za: ovaj mesec. Ako se promeni, nova podešavanja važiće u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "Za prikaz posetioca u čeonoj aplikaciji za: prošli mesec. Ako se promeni, nova podešavanja važiće u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "Za prikaz ukupnog broja posetioca od dana instalacije ExtraWatch. Ako se promeni, nova podešavanja važiće u čeonoj aplikaciji nakon vremena određenog u CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "Korišćenje jezičkih fajlova. Oni se nalaze u direktorijumu /components/com_extrawatch/lang/. Ako želite da kreirate novi jezički fajl prvo proverite početnu stranu projekta i ako jezički fajl još uvek ne postoji samo kopirajte podrazumevani english.php u npr. german.php i stavite u direktorijum. Zatim prevedite sve ključne vrednosti sa desne strane.");
DEFINE('_EW_DESC_GOALS', "Ciljevi omogućuju određivanje specifičnih parametara. Kada se parametri poklapaju broj ciljeva se povećava. Na taj način možete posmatrati da li je korisnik posetio specifični URL, ostavio određenu vrednost, ima određeno korisničko ime ili dolazi sa određene adrese. Možete blokirati ili preusmeriti takve korisnike ka nekom drugom URL-u.");
DEFINE('_EW_DESC_GOALS_INSERT', "U svim poljima osim imena možete koristiti * i ? džokere. Npr.: ?ear (podudaraće se sa: near, tear, ..),  p*r (podudaraće se sa: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "Postavite na 1, ako želite da posetitelj bude blokiran. Posetitelj neće videti ostatak sadržaja, samo poruku da je blokiran-bez redirekcije i njegov IP biće dodat u statistiku blokiranih. (Primer korišćenja: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Uslov za državu");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "Obrnuti uslov za državu");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "2 velika slova kao kod zemlje (Pr.: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "Unutrašnje");
DEFINE('_EW_STATS_FROM', "Od");
DEFINE('_EW_STATS_TO', "Do");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Dodaj u ciljeve");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Dodaj cilj za ovu državu");
DEFINE('_EW_MENU_REPORT_BUG', "Prijavi grešku ili opciju");
DEFINE('_EW_GOALS_COUNTRY', "Država");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Ako želite da nazivi zemalja u čeonoj aplikaciji budu ispisani velikim slovima. (Pr: NEMAČKA, VELIKA BRITANIJA umesto Nemačka, Velika Britanija)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Vreme u sekundama potrebno da se keširaju podaci korisnika u čeonoj aplikaciji.");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Početne vrednosti prikazane u Ukupno: u čeonoj aplikaciji. Korisno u slučajevima kada se prešlo sa druge statističke alatke. (Npr.: 20000). Podesite na 0 ako ne želite da koristite ovu opciju.");
DEFINE('_EW_DESC_IGNORE_USER', "Ignorišite korisnike izlistane u okviru za tekst. Jednog po jednog. (Npr.: myself {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Najaktivniji korisnici danas u odnosu na ukupan broj");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "Omogućite banovanja zasnovana na rečima sa liste spam reči ispod?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Najčešće korišćenje spam reči od strane spam botova. Možete koristiti džokere ovde, (Npr.: ph?rmac*). Ako je opcija iznad omogućena ExtraWatch će proveriti da li je napadač poslao obrazac (HTTP POST request) na vaš sajt sa nekom od ovih spam reči. (Može se primeniti samo ako se obrazac učitava na Joomli baziranom websajtu-forum, komentari, ali je i efikasan prilikom blokiranja spam botova koji pokušavaju da pošalju bilo koji obrazac.");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "Link u korisničkom modulu čeone aplikacije omogućava vam da specifirate jedan URL koji se otvara kada korisnik klikne korisničko ime. Mora da sadrži string {user} koji će biti zamenjen pravim korisničkim imenom. (Npr. index.php?option=com_comprofiler&task=userProfile&user={user}) ");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Ključne fraze");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Maksimalna vrednost u evidencionoj kartici (Primer: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "U posetama prikazati samo poslednje posećene strane, ne sve");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "U posetama sakriti nazive sajtova koji se ponavljaju u nazivu posećenih strana.");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Maksimalan broj posetioca koje se čuvaju u bazi za Evidenciju poseta. Budite pažljivi sa ovim stringom. Ukoliko imate veliku posetu broj podataka može porasti vrlo brzo. Uvek proverite u Statusu koliko podataka sadrži tabela izveštaja.");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Držite tabele baza na uninstall. Označite ovu opciju pre deinstalacije ako vršite nadogradnju i želite da sačuvate podatke.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "Primićete u toku noćo email sa izveštajem za prethodni dan koji ćete moći da pročitate ujutru.");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "Imejl adresa na koju će vam stići izveštaj");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "Uključiti samo redove u email izveštaju gde je procenat veći od {value}. Postavite na 0 ako ne želite da koristite ovu opciju <i>(primer: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "Uključiti samo <b>pozitivne jednodnevne</b> promene vrednosti u email izveštaju veće od {value} procenata. Postavite na 0 ako ne želite da koristite ovu opciju <i>(primer: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "Uključiti samo <b>negativne jednodnevne</b> promene vrednosti u email izveštaju manje od {value} procenata.Postavite na 0 ako ne želite da koristite ovu opciju <i>(primer: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "Uključiti samo <b>pozitivne sedmodnevne</b> promene vrednosti u email izveštaju veće od {value} procenata. Postavite na 0 ako ne želite da koristite ovu opciju <i>(primer: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "Uključiti samo <b>negativne sedmodnevne</b> promene vrednosti u email izveštaju manje od {value} procenata. Postavite na 0 ako ne želite da koristite ovu opciju <i>(primer: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "Uključiti samo <b>pozitivne 28-dnevne</b> promene vrednosti u email izveštaju veće od {value} procenata. Postavite na 0 ako ne želite da koristite ovu opciju <i>(primer: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "Uključiti samo <b>negativne 28-dnevne</b> promene vredosti u email izveštaju manje od {value} procenata. Postavite na 0 ako ne želite da koristite ovu opciju <i>(primer: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(funkcioniše u PRO verziji)</b> Uključite ovu opciju ako želite da link logo-a bude renderovan atributom rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Maksimalno znakova u redu email naziva. Promenite ovo ako je prozor vašeg email klienta previše mali.");

DEFINE('_EW_MENU_HISTORY', "Evidencija");
DEFINE('_EW_MENU_EMAILS', "Email");
DEFINE('_EW_MENU_STATUS', "DB Status");
DEFINE('_EW_DESC_BLOCKED', "Ove IP-i adrese su blokirane od strane anti-spama");


DEFINE('_EW_HISTORY_VISITORS', "Evidencija posetioca");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Prikazuje samo %d poslednjih podataka.
                Kako bi ste promenili ovu vrednost idite na Podešavanja -&gt; Evidencija &amp; Performanse -&gt; HISTORY_MAX_DB_RECORDS . Pažljivo, ovo podešavanje utiče na vreme učitavanja podataka ispod.  ");
DEFINE('_EW_MENU_BUG', "Prijavi grešku");
DEFINE('_EW_MENU_FEATURE', "Prijavi opciju");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Ključne reči");

DEFINE('_EW_BLOCKING_UNBLOCK', "odblokiraj");
DEFINE('_EW_STATS_KEYPHRASE ', "Ključne fraze");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "kolone");
DEFINE('_EW_STATUS_DATABASE_ROWS', "redovi");
DEFINE('_EW_STATUS_DATABASE_DATA', "podaci");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "ukupno");

DEFINE('_EW_EMAIL_REPORTS', "Email Izveštaji");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Generisani filtrirani email izveštaj od juče.");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Vrednost Email filtera");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "vrednost");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "procenti");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "1-dnevna promena");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "7-dnevna promena");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "28-dnevna promena");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch je blokirala %d poseta spemera danas, ukupno: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Blokirane IP adrese");
DEFINE('_EW_ANTISPAM_SETTINGS', "Anti-Spam podešavanja");
DEFINE('_EW_TRAFFIC_AJAX', "AJAX ažuriranje posećenosti (osim mapa)");


DEFINE('_EW_HISTORY_PREVIOUS', "prethodno");
DEFINE('_EW_HISTORY_NEXT', "sledeće");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Broj kolona država");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Broj redova država");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Prikaži naziv države ili ne");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Prikaži prvo zastave a onda procente");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "GET inverzni uslov");
DEFINE('_EW_GOALS_POST_INVERSED', "POST inverzni uslov");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Title inverzni uslov");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Username inverzni uslov");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Came from inverzni uslov");

DEFINE('_EW_STATS_MAP', "Mapa poslednjih poseta");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Unesite <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> ključ za prikaz mape poslednjih poseta.:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "ključ za čuvanje");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Molimo vas unesite validan ipinfodb ključ koji ste dobili sa: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "NEISPRAVAN ZAHTEV: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Poslata polja obrasca:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "URL parametri:");
DEFINE('_EW_VISIT_ADD_PAGE', "Dodaj stranu u ciljeve");
DEFINE('_EW_VISIT_BLOCK_IP', "Blokiraj ovu IP Adresu");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', "Dodaj ovu varijablu poslatog obrasca kao cilj");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', "Dodaj ovaj URL parametar kao cilj");

DEFINE('_EW_TREND_EMPTY', "Prazno");

DEFINE('_EW_NOT_NUMBER', " UPOZORENJE: Vrednost koju ste uneli nije broj. ExtraWatch neće raditi ispravno!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; Ovo je 15-to dnevna probna verzija. Preostalo dana: <b>%d</b>. Molimo vas kupite doživotnu verziju <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>ExtraWatch dozvole za vaš domen</a> za ovu i dolazeće verzije.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " Vaša probna verzija je istekla. Molimo vas kupite ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "Aktivacija licence uspešna. Zahvaljujemo vam.");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Greška: licencni ključ i vaš domen se ne podudaraju.</b><br/>Da li ste uneli isti naziv domena u formularu za donacije kao što je ovaj koji vidite ispod? <br/> Kliknite ispod'<b>da zatražite ispravan aktivacioni ključ</b>' ili kontaktirajte: info@codegravity.com<br/>");
DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "Ako poruku iznad vidite duže vreme vaša aktivna lokacija može biti pogrešna.
                    Otvorite components/com_extrawatch/config.php
                    otkomentirajte i postavite vašu pravu aktivnu lokaciju. Npr.:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Upozorenje: sajt u vašem pretraživaču i aktivna lokacija u konfiguraciji: %s i %s se ne podudaraju.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Postavite aktivnu lokaciju: %s i nastavite...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Ukloni link");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Baza znanja");
DEFINE('_EW_ADMINHEADER_FLOW', "Tok");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Grafici");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Komponente");
DEFINE('_EW_ADMINHEADER_REVIEW', "Pregled");
DEFINE('_EW_ADMINHEADER_WRITE', "Pišite ");

DEFINE('_EW_FLOW_TRAFFIC', "Tok posete");
DEFINE('_EW_FLOW_SELECT_PAGE', "Označi stranu:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Broj odlazećih linkova iz rut-a:");
DEFINE('_EW_FLOW_NESTING', "Nivo ugnežđavanja:");
DEFINE('_EW_FLOW_SCALE', "Razmera:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Verzija bez reklama");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Zahvaljujemo vam se puno na donaciji!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "Registracioni kod za vaš domen %s je: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Sada možete da uklonite pozadinske linkove ili sakrijete ExtraWatch logo u čeonoj aplikaciji iz Podešavanja");


DEFINE('_EW_SIZES_LAST_CHECK', "Poslednja provera izvršena je:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "PLAVO = Veličina komponente/modula u /administrativnom direktorijumu");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Komponenta");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Ukupno:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Veličina");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Osveži sve");

DEFINE('_EW_SIZEDATABASE_TABLE', "Tabela");
DEFINE('_EW_SIZEDATABASE_SIZE', "Veličina");
DEFINE('_EW_SIZEDATABASE_1DAY', "1-dnevna promena");
DEFINE('_EW_SIZEDATABASE_7DAY', "7-dnevna promena");
DEFINE('_EW_SIZEDATABASE_28DAY', "28-dnevna promena");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "nema podataka");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Ukupno:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Osveži sve");
DEFINE('_EW_SIZEMODULES_TOTAL', "Ukupno:");
DEFINE('_EW_SIZEMODULES_MODULE', "Modul");
DEFINE('_EW_SIZEMODULES_SIZE', "Veličina");

DEFINE('_EW_SIZES_FILES', "Fajlovi &amp; direktorijumi");
DEFINE('_EW_SIZES_BYTES', "bajtova");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Osveži");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@Godina@ autor CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "Veličina tabela u bazi");


DEFINE('_EW_DESC_IPINFODB_KEY', "Ključ mape poslednjih poseta sa ipinfodb.com: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Zahtevaj promenu vremenskih zona");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Ažuriranje");
DEFINE('_EW_MENU_UPDATE_TITLE', "Rezervna kopija i nadogradnja");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Nije dostupno u besplatnoj verziji, proverite karticu sa dozvolama");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Uključeno je banovanje spam reči");
DEFINE('_EW_SPAMWORD_LIST', "Lista spam reči");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Sakrijte nazive koji se ponavaljaju");
DEFINE('_EW_TRUNCATE_VISITS', "Odsecite posetu");
DEFINE('_EW_TRUNCATE_STATS', "Odsecite statistiku");
DEFINE('_EW_TRUNCATE_GOALS', "Odsecite cilj");
DEFINE('_EW_LIMIT_BOTS', "Ograniči botove");
DEFINE('_EW_LIMIT_VISITORS', "Ograniči broj poseta");
DEFINE('_EW_TOOLTIP_WIDTH', "Dužina opisa alatke");
DEFINE('_EW_TOOLTIP_HEIGHT', "Visina opisa alatke");
DEFINE('_EW_TOOLTIP_URL', "URL opisa alatke");
DEFINE('_EW_TOOLTIP_ONCLICK', "Opis alata na klik");
DEFINE('_EW_IP_STATS', "Statistika IP-a");
DEFINE('_EW_IPINFODB_KEY', "IP Info DB ključ ");
DEFINE('_EW_ONLY_LAST_URI', "Samo poslednji URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Sakrijte logo iz čeone aplikacije");
DEFINE('_EW_FRONTEND_NOFOLLOW', "No follow čeone aplikacije");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Bez veza u pozadini u čeonoj aplikaciji");
DEFINE('_EW_FRONTEND_USER_LINK', "Lista korisnika čeone aplikacije");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Prvo nazivi država u čeonoj aplikaciji");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Nazivi država čeone aplikaije");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Nazivi država velikim slovima");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Zastave država u čeonoj aplikaciji prvo");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Broj zemalja");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Maksimalno kolona zemalja");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Maksimalno redova zemalja");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Broj posetioca danas ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Broj posetioca juče ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Broj posetioca ove nedelje ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Broj posetioca prošle nedelje ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Broj posetioca čeone aplikacije ovog meseca ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Broj posetioca čeone aplikacije prošlog meseca ");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Sakrij ukupan broj posetioca");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Početna ukupna vrednost");
DEFINE('_EW_HISTORY_MAX_VALUES', "Maksimalne vrednosti evidencije");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "Maksimalno podatka u evidenciji");
DEFINE('_EW_UPDATE_TIME_VISITS', "Ažuriranje vremena posete");
DEFINE('_EW_UPDATE_TIME_STATS', "Statistika vremena ažuriranja");
DEFINE('_EW_STATS_MAX_ROWS', "Statistika maksimalnih redova");
DEFINE('_EW_STATS_IP_HITS', "Statistika IP poseta");
DEFINE('_EW_MAXID_BOTS', "Maksimalno ID botova");
DEFINE('_EW_MAXID_VISITORS', "Maxid posetioca");
DEFINE('_EW_STATS_KEEP_DAYS', "Statistiku čuvati dana ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Keširaj države ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Keširaj posetioce ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Deinstaliraj sačuvaj podatke");
DEFINE('_EW_IGNORE_IP', "Ignoriši IP");
DEFINE('_EW_IGNORE_URI', "Ignoriši URI");
DEFINE('_EW_IGNORE_USER', "Ignoriši korisnika");
DEFINE('_EW_BLOCKING_MESSAGE', "Blokiraj poruku");
DEFINE('_EW_SERVER_URI_KEY', "Server URI ključ");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Ukupna početna vrednost posetioca");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Podaci");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " Da bi blokiranje bilo efektno morate da publikujete ExtraWatch agenta PRE bilo kakvog sadržaja ili obrasca. Npr. na levoj strani vašeg templejta.
                    <br/>
                    Idite u Modul menadžer -> ExtraWatch agent -> označite poziciju levo");

DEFINE('_EW_EMAIL_SEO_REPORTS', "SEO izveštaji");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "SEO noćni email izveštaji su omogućeni");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Pogledaj instalacioni demo");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
