<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "ライブ開始");
DEFINE('_EW_MENU_GOALS', "目標");
DEFINE('_EW_MENU_SETTINGS', "設定");
DEFINE('_EW_MENU_CREDITS', "クレジット");
DEFINE('_EW_MENU_FAQ', "良くある質問");
DEFINE('_EW_MENU_DOCUMENTATION', "情報管理");
DEFINE('_EW_MENU_LICENSE', "ライセンス");
DEFINE('_EW_MENU_DONATORS', "サポーター");
DEFINE('_EW_MENU_SUPPORT', "ジュームラ・ウォッチをサポートしてください。そうすると広告表示なしでご利用いただけます。");


// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "最近の訪問者");
DEFINE('_EW_VISITS_BOTS', "ボット");
DEFINE('_EW_VISITS_CAME_FROM', "出身");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "ジュームラ・ウォッチモジュールが発行されていません！新規状態が記録されていません。 発行するには、モジュールセクションへアクセスし、そして全ページ上に発行してください。");
DEFINE('_EW_VISITS_PANE_LOADING', "訪問者読込み...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "週別訪問者状況");
DEFINE('_EW_STATS_WEEK', "週");
DEFINE('_EW_STATS_THIS_WEEK', "今週");
DEFINE('_EW_STATS_UNIQUE', "固有");
DEFINE('_EW_STATS_LOADS', "読込み");
DEFINE('_EW_STATS_HITS', "ヒット");
DEFINE('_EW_STATS_TODAY', "今日");
DEFINE('_EW_STATS_FOR', "目的");
DEFINE('_EW_STATS_ALL_TIME', "最高");
DEFINE('_EW_STATS_EXPAND', "拡大");
DEFINE('_EW_STATS_COLLAPSE', "崩壊");
DEFINE('_EW_STATS_URI', "ページ");
DEFINE('_EW_STATS_COUNTRY', "国");
DEFINE('_EW_STATS_USERS', "ユーザー");
DEFINE('_EW_STATS_REFERERS', "参照");
DEFINE('_EW_STATS_IP', "IP");
DEFINE('_EW_STATS_BROWSER', "ブラウザ");
DEFINE('_EW_STATS_OS', "OS");
DEFINE('_EW_STATS_KEYWORDS', "キーワード");
DEFINE('_EW_STATS_GOALS', "目標");
DEFINE('_EW_STATS_TOTAL', "合計");
DEFINE('_EW_STATS_DAILY', "毎日");
DEFINE('_EW_STATS_DAILY_TITLE', "毎日の状況");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "最高の状況");
DEFINE('_EW_STATS_LOADING', "読込み中...");
DEFINE('_EW_STATS_LOADING_WAIT', "読込み中...しばらくお待ちください");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "IPブロッキング");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "IPを手動入力");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "ブロックしたいIPアドレスを入力してください。(例 217.242.11.54 或いは 217.* 或いは 217.242.* ワイルドカードに一致するこれら全てのIPをブロックする)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "実際にトグルブロッキング先 ");
DEFINE('_EW_STATS_PANE_LOADING', "読込み状況...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "設定");
DEFINE('_EW_SETTINGS_DEFAULT', "初期設定");
DEFINE('_EW_SETTINGS_SAVE', "保存");
DEFINE('_EW_SETTINGS_APPEARANCE', "外見");
DEFINE('_EW_SETTINGS_FRONTEND', "先頭");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "履歴及びパフォーマンス");
DEFINE('_EW_SETTINGS_ADVANCED', "詳細");
DEFINE('_EW_SETTINGS_IGNORE', "無視");
DEFINE('_EW_SETTINGS_BLOCKING', "ブロッキング");
DEFINE('_EW_SETTINGS_EXPERT', "エクスパート");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "全統計と訪問者データを本当にリセットしますか？");
DEFINE('_EW_SETTINGS_RESET_ALL', "全てをリセット");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "全統計及び訪問者データをリセット");
DEFINE('_EW_SETTINGS_LANGUAGE', "言語");
DEFINE('_EW_SETTINGS_SAVED', "設定が保存されました。");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "IP追加");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "リストへ");

// Other / mostly general.
DEFINE('_EW_TITLE', "リアルタイムAJAXジュームラ・モニター");
DEFINE('_EW_BACK', "戻る");
DEFINE('_EW_ACCESS_DENIED', "これを閲覧承認を得ていません！");
DEFINE('_EW_LICENSE_AGREE', "上記の諸条件に同意します。");
DEFINE('_EW_LICENSE_CONTINUE', "続ける");
DEFINE('_EW_SUCCESS', "オペレーション成功");
DEFINE('_EW_RESET_SUCCESS', "全統計及び訪問者データが無事に削除されました。");
DEFINE('_EW_RESET_ERROR', "データが無事に削除されませんでした。問題が発生しました。");
DEFINE('_EW_CREDITS_TITLE', "クレジット");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "毎日及び毎週の状況");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "AJAX承認拒否：ジュームラ - 構成.phpに記載したドメインからこの統計を閲覧してください");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "www.のドメイン名をお忘れですか。お持ちのジャバスクリプトがアクセスを試みています");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "アクセス元");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "異なるドメインであるとお考えになったのはなぜですか");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "最新の拡張コード取得先");
DEFINE('_EW_HEADER_CAST_YOUR', "以下を変換してください");
DEFINE('_EW_HEADER_VOTE', "投票");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "ツールチップを表示するためにクリック");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "ツールチップを表示するためにマウスを重ねる");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "昨日の増加量");
DEFINE('_EW_TOOLTIP_HELP', "次のオンライン外部ヘルプを開く");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "このウィンドウを閉じる");
DEFINE('_EW_TOOLTIP_PRINT', "印刷");

// Goals.
DEFINE('_EW_GOALS_INSERT', "目標挿入");
DEFINE('_EW_GOALS_UPDATE', "目標番号更新");
DEFINE('_EW_GOALS_ACTION', "アクション");
DEFINE('_EW_GOALS_TITLE', "新規目標");
DEFINE('_EW_GOALS_NEW', "新規目標");
DEFINE('_EW_GOALS_RELOAD', "再読込み");
DEFINE('_EW_GOALS_ADVANCED', "詳細");
DEFINE('_EW_GOALS_NAME', "氏名");
DEFINE('_EW_GOALS_ID', "ID");
DEFINE('_EW_GOALS_URI_CONDITION', "URI状態");
DEFINE('_EW_GOALS_URI_INVERSED', "URI反転状態");
DEFINE('_EW_GOALS_GET_VAR', "取得バージョン");
DEFINE('_EW_GOALS_GET_CONDITION', "取得状態");
DEFINE('_EW_GOALS_POST_VAR', "ポストバージョン");
DEFINE('_EW_GOALS_POST_CONDITION', "POST状態");
DEFINE('_EW_GOALS_TITLE_CONDITION', "タイトル状態");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "ユーザー名状態");
DEFINE('_EW_GOALS_IP_CONDITION', "IP状態");
DEFINE('_EW_GOALS_IP_INVERSED', "IP反転状態");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "状態に起因");
DEFINE('_EW_GOALS_BLOCK', "ブロック");
DEFINE('_EW_GOALS_REDIRECT', "URLへリダイアル");
DEFINE('_EW_GOALS_HITS', "ヒット");
DEFINE('_EW_GOALS_ENABLED', "有効");
DEFINE('_EW_GOALS_EDIT', "編集");
DEFINE('_EW_GOALS_DELETE', "削除");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "この目標のために全ての最近の統計データを失います。目標番号を本当に削除しますか？");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "国");
DEFINE('_EW_FRONTEND_VISITORS', "訪問者");
DEFINE('_EW_FRONTEND_TODAY', "今日");
DEFINE('_EW_FRONTEND_YESTERDAY', "昨日");
DEFINE('_EW_FRONTEND_THIS_WEEK', "今週");
DEFINE('_EW_FRONTEND_LAST_WEEK', "先週");
DEFINE('_EW_FRONTEND_THIS_MONTH', "今月");
DEFINE('_EW_FRONTEND_LAST_MONTH', "先月");
DEFINE('_EW_FRONTEND_TOTAL', "合計");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ジュームラ・ウォッチが修正モードです。これによりエラー原因を修復できます。オフにするには、/components/com_extrawatch/config.phpのEXTRAWATCH_DEBUG値の1から0を変更してください");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "状態が拡張モードの際、最大行数が表示されます");
DEFINE('_EW_DESC_STATS_IP_HITS', "数日間ヒットしなかった全IPアドレスです。この値がIP履歴から削除されます");
DEFINE('_EW_DESC_STATS_URL_HITS', "数日間ヒットしなかった全URLです。この値がIP履歴から削除されます");
DEFINE('_EW_DESC_IGNORE_IP', "統計から特定のIPを排除する。新規ラインと離す。ここでワイルドカードを使用できます。 <br/>例 192.* が192.168.51.31、192.168.16.2、などを無視します");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "訪問者が秒単位で時間をリフレッシュし、初期設定が2000の際はご注意ください。ジュームラ・ウォッチバックエンドを再び読み込んでください。");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "統計が秒単位で時間をリフレッシュし、初期設定が4000の際はご注意ください。ジュームラ・ウォッチバックエンドを再び読み込んでください。");
DEFINE('_EW_DESC_MAXID_BOTS', "データベースに保存するボット訪問者数");
DEFINE('_EW_DESC_MAXID_VISITORS', " データベースに保存する実際の訪問者数");
DEFINE('_EW_DESC_LIMIT_BOTS', "バックエンドに見られるボット数");
DEFINE('_EW_DESC_LIMIT_VISITORS', "バックエンドに見られる実際の訪問者数");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "長いタイトルとURIに表示される最大文字数");
DEFINE('_EW_DESC_TRUNCATE_STATS', "正しい統計パネルに表示される最大文字数");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "統計をデータベース内に保存する日数 0 = 無限");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "ホストサーバーと別のタイムゾーンにいる場合 (プラス或はマイナス時数)");
DEFINE('_EW_DESC_WEEK_OFFSET', "ウィーク・オフセット、タイムスタンプ/(3600*24*7)で1.1.1970年1月1日からの週数を設定します。このオフセットにより、月曜日から開始する様に修正されます");
DEFINE('_EW_DESC_DAY_OFFSET', "日付オフセット、タイムスタンプ/(3600*24)で1.1.1970年1月1日からの日数を設定します。このオフセットにより、00：00から開始する様に修正されます");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(プロバージョン内機能)</b>フロントエンドにブランクの1x1pxアイコンを使用します ");
DEFINE('_EW_DESC_IP_STATS', "アドレス統計を有効にします。複数の国では長時間データベース内にIPを保存することは法律で禁じられています。リスクをご承知ください。");
DEFINE('_EW_DESC_HIDE_ADS', "この設定では、本当に広告を見たくない場合、バックエンドに広告を隠します。広告を保存することで、本ツールの更なる開発をサポートすることになります。ありがとうございます。");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "マウスクリックの代わりにマウスオーバーでツールチップを表示するには、アンチェックにしてください。");
DEFINE('_EW_DESC_SERVER_URI_KEY', "初期設定は'REDIRECT_URL'です。リライトするURLを使用する場合、これが基準です。またindex.phpのみ記録する場合、'SCRIPT_URL'に設定されます。");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "ブロックされたユーザーに表示されるメッセージ或はこれらのユーザーにブロックされる理由についての詳細");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "ツールチップ幅");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "ツールチップ高さ");
DEFINE('_EW_DESC_TOOLTIP_URL', "訪問者のIPを視覚化するために、ここにURLを入力できます。訪問者のIPでその{ip}が置き換えられます。例 http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "統計から無視されたいURIを入力できます。ワイルドカード(* and ?)をここで使用できます。例: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "目標名をここに記入してください。この名前は統計内に表示されます。");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "ドメイン名の後ろ全て。http://www.codegravity.com/projects/に関するURI: /projects/ (Example to use: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "GET変数は、通常a ?や &amp;マークの後に、URL内で見られる変数です。 例 http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith。このフィールド内で全てのGET値をスキャンするために <u>*</u>を使用することもできます。 (使用例: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "ここで前回のフィールドから数値の一致を指定する必要があります (使用例: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "ほぼ似ていますが、フォームから送信された値を確認しています。お持ちのウェブサイト上にフォームをお持ちであれば、フィールド&lt;input type='text' name='<u>experiences</u>' /&gt;があります。 (使用例: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "このポストフィールドから一致した値。 例 ユーザーにジャバの使用経験があるかどうか確認したい。 (使用例: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "一致すべきページタイトル。 (使用例: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "ログインユーザー名 (使用例: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "ユーザーのアクセス元IP (使用例: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "ユーザーのアクセス元URL (使用例: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "あなたが特定したURLへユーザーがリダイレクトされました。'ブロッキング'より、高い優先度: (使用例: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "目標表の切り詰めチャート数");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(プロバージョンの機能)</b> codegravity.comへのバックリンクを無効にできますが、そのままご利用いただけると助かります。ご理解いただきありがとうございます。");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "フロントエンドモジュールでの国の総統計表示。変更した場合、CACHE_FRONTEND_ に時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "フロントエンドの訪問者/国の順番を入れ替えたい場合、 未確認にしてください。そうすると、先ず訪問者が現れます。");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "フロントエンドに国の数が表示されます");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "フロントエンドモジュールに国の訪問者が表示されます。変更した場合、CACHE_FRONTEND_で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "フロントエンドで国の総数を保存するのに数秒かかります。");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "フロントエンドで訪問者を保存するのに数秒かかります。");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "本日の訪問者をフロントエンドに表示します。変更した場合、CACHE_FRONTEND_...で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "昨日の訪問者をフロントエンドに表示します。変更した場合、CACHE_FRONTEND_...で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "今週の訪問者をフロントエンドに表示します。変更した場合、CACHE_FRONTEND_...で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "先週の訪問者をフロントエンドに表示します。変更した場合、CACHE_FRONTEND_...で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "今月の訪問者をフロントエンドに表示します。変更した場合、CACHE_FRONTEND_...で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "先月の訪問者をフロントエンドに表示します。変更した場合、CACHE_FRONTEND_...で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "ジュームラ・ウォッチをインストール以降の訪問者数を表示します。変更した場合、CACHE_FRONTEND_..で時間設定後、フロントエンド内でこの設定が効果的です。");
DEFINE('_EW_DESC_LANGUAGE', "使用する言語ファイル。 /components/com_extrawatch/lang/に保存されています。新規の言語ファイルを作成したい場合、先ず、プロジェクトのホームページを確認し、言語ファイルがない場合、初期設定english.phpを例えばgerman.phpにコピーしてください。そしてこのディレクトリに保存してください。そして正確に全ての主要な値を翻訳してください。");
DEFINE('_EW_DESC_GOALS', "目標で特別のパラメータを指定できます。これらのパラメータが一致する際、目標カウンターが増加します。この方法で、ユーザーが特定のURLへアクセスしたか、特定の値を投函したか、特定のユーザー名を保有しているか或は特定のアドレスからアクセスしてきているかをモニタリングできます。このようなユーザーをブロック或は他のURLへリダイアルできます。");
DEFINE('_EW_DESC_GOALS_INSERT', "名前を除く全てのフィールドで、ワイルドカードとして*や?を使用できます。例えば: ?ear (一致単語: near, tear, ..)、p*r (一致単語: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "訪問者にブロックされたい場合、1を設定してください。コンテンツのリセット内容を見ません。リダイレクトやIPが'ブロックされた'統計へ追加されることなく、ブロックされたというメッセージが表示されます。 (使用例: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "国条件");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "国反転条件");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "大文字での2文字表記の国コード(例: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "国内");
DEFINE('_EW_STATS_FROM', "から");
DEFINE('_EW_STATS_TO', "宛");
DEFINE('_EW_STATS_ADD_TO_GOALS', "目標へ追加");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "この国に目標追加");
DEFINE('_EW_MENU_REPORT_BUG', "バグや機能を報告");
DEFINE('_EW_GOALS_COUNTRY', "国");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "フロントエンドに大文字で国名を表記したい場合 (例: 小文字でドイツ、イギリスと表記する代わりに大文字でドイツ、イギリスと表記)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "フロントエンドユーザーを引きつけて保存するのに数秒かかります");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "フロントエンド合計内に表示された主要値。他のスタートツールから移動する際有用です。(例: 20000)この機能を使用したくない場合、0へ設定してください。");
DEFINE('_EW_DESC_IGNORE_USER', "このテキストボックス内にリストされたユーザーを無視。ライン毎。 (例: myself {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "本日最もアクティブなフロントエンドユーザーの合計");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "以下のスパムワードリストからの言葉に基づき禁止事項を有効にしますか？");
DEFINE('_EW_DESC_SPAMWORD_LIST', "スパムボットが使用した最も共通のスパム言語。ここでワイルドカードを使用できます (例: ph?rmac*)。上記設定が有効である場合、ジュームラ・ウォッチが、これらのスパム言語でお持ちのウェブサイト上にフォーム( HTTP POST要求)をアタッカーが送信したか確認します。(フォームがジュームラベースのウェブサイトのフォーラム、コメントのみ読み込む場合に適用されますが、可能なフォームを送信しようとするスパムボットをブロックするのにとても効果的です。)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "アンチスパム");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "フロントエンドのユーザーモジュール内リンクでURLを特定でき、ユーザー名をユーザーがクリックした際開きます。ストリング{user}を含む必要があります。実際のユーザー名と置き換えられます。 (例 index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "キーフレーズ");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "履歴タブ内の最大値 (例: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "訪問画面では全てではなく、最終訪問ページのみ表示されます");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "訪問画面では、訪問ページタイトル内の代表サイト名を隠します");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "訪問履歴のデータベース内に保存するための訪問者最大数値。アクセス数が多い場合、直ぐに一杯になるためご注意ください。統計内の履歴表のデータ含み量を常にご確認ください");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "データベース表をアンインストールにする。更新中であるまたデータを保存したい場合、このオプションをアンインストールする前にご確認ください。データベース表をアンインストールにしてください。");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "毎晩、前日に関する報告書をメールで受け取ります。朝読むことができます。");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "これらの報告書を受け取りたいメールアドレス");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "確率が{value}より高いメール報告書に行のみ含めてください。この機能を使用されたくない場合、0に設定してください<i>(例: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "確率が{value}より高いメール報告書に行のみ<b>1日以降</b>変更値のみ含めてください。この機能を使用されたくない場合、0に設定してください<i>(例: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "確率が{value}より高いメール報告書に行のみ<b>1日以前</b>変更値のみ含めてください。この機能を使用されたくない場合、0に設定してください<i>(例: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "確率が{value}より高いメール報告書に行のみ<b>7日以降</b>変更値のみ含めてください。この機能を使用されたくない場合、0に設定してください<i>(例: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "確率が{value}より高いメール報告書に行のみ<b>7日以前</b>変更値のみ含めてください。この機能を使用されたくない場合、0に設定してください<i>(例: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "確率が{value}より高いメール報告書に行のみ<b>28日以降</b>変更値のみ含めてください。この機能を使用されたくない場合、0に設定してください<i>(例: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "確率が{value}より高いメール報告書に行のみ<b>28日以前</b>変更値のみ含めてください。この機能を使用されたくない場合、0に設定してください<i>(例: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(プロバージョンの機能)</b>  rel='nofollow'属性で変更されたロゴリンクを作成されたい場合、この設定を有効にしてください ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "メール行名最大文字数。メールクライアントメッセージ画面が小さすぎる場合、これを変更してください。");

DEFINE('_EW_MENU_HISTORY', "履歴");
DEFINE('_EW_MENU_EMAILS', "Eメール");
DEFINE('_EW_MENU_STATUS', "DB状況");
DEFINE('_EW_DESC_BLOCKED', "アンチスパムによりこれらのIPはブロックされています。");


DEFINE('_EW_HISTORY_VISITORS', "訪問者履歴");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "%d最終記録のみ表示
                この値を変更するには、設定 -&gt; 履歴 &amp; パフォーマンス -&gt; HISTORY_MAX_DB_RECORDSへ進んでください。この設定は、以下のデータ読込み時間に影響を与えるためご注意ください。");
DEFINE('_EW_MENU_BUG', "バグを報告");
DEFINE('_EW_MENU_FEATURE', "機能要望");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "キーフワード");

DEFINE('_EW_BLOCKING_UNBLOCK', "ブロックしない");
DEFINE('_EW_STATS_KEYPHRASE ', "キーフレーズ");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "テーブル名");
DEFINE('_EW_STATUS_DATABASE_ROWS', "行数");
DEFINE('_EW_STATUS_DATABASE_DATA', "データ");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "合計");

DEFINE('_EW_EMAIL_REPORTS', "Eメール報告書");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "昨日から発生したフィルターされたEメール報告書");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Eメール値フィルター");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "値");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "確率");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "1日間変更");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "7日間変更");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "28日間変更");
DEFINE('_EW_ANTISPAM_BLOCKED', "本日ジュームラ・ウォッチが%dスパマーヒットをブロックしました。合計: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "ブロックされたIPアドレス");
DEFINE('_EW_ANTISPAM_SETTINGS', "アンチスパム設定");
DEFINE('_EW_TRAFFIC_AJAX', "AJAXがトラフィックを更新します(マップを除く)");


DEFINE('_EW_HISTORY_PREVIOUS', "前");
DEFINE('_EW_HISTORY_NEXT', "次");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "国のコラム数");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "国の行数");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "国名を表示しますか");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "先ず国旗を表示、そして確率");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "反転条件を取得");
DEFINE('_EW_GOALS_POST_INVERSED', "反転条件をポスト");
DEFINE('_EW_GOALS_TITLE_INVERSED', "反転条件のタイトル");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "反転条件のユーザー名");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "反転条件に起因");

DEFINE('_EW_STATS_MAP', "最終訪問マップ");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "最終訪問マップに表示させるために</a><a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.comキーを入力してください：");
DEFINE('_EW_STATS_MAP_STORE_KEY', "ストアキー");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "<a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.comで取得した</a>有効なipinfodbキーを入力してくださいを入力してください");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "良くない要求: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "送信フォームフィールド:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "URLパラメーター");
DEFINE('_EW_VISIT_ADD_PAGE', " 目標としてページを追加");
DEFINE('_EW_VISIT_BLOCK_IP', " このIPアドレスをブロック");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " 目標としてこの送信フォーム変値を追加");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " 目標としてこのURLパラメータを追加");

DEFINE('_EW_TREND_EMPTY', "Empty");

DEFINE('_EW_NOT_NUMBER', " 警告:入力値が数値ではありません。ジュームラ・ウォッチが適切に起動しません！");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; これは15日間評価版です。残り日数: <b>%d</b> 永久版をご購入ください <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>本ソフト及び今後のソフトにおけるあなたの</a>ジュームラ・ウォッチライセンスのドメイン");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " トライアル版の期限がきれました。ジュームラ・ウォッチをご購入ください。");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "ライセンスが無事に起動しました。ありがとうございます");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>エラー: ライセンスキーとドメインが一致しません</b><br/>以下に表示した寄付フォームと同じドメイン名をご入力されましたか？ <br/>クリック '<b>以下に正しい起動キーを要求してください</b>或はお問い合わせください: info@codegravity.com<br/>");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "長時間上記メッセージを見られているのであれば、ライブサイトが間違っている可能性があります。
                    コンポーネント/com_extrawatch/config.php
                    アンコメントを開いてください、そして実際のライブサイトを設定してください。例:
                    いづれかを決定してください('EXTRAWATCH_LIVE_SITE'、'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "警告: ブラウザ内のサイトと構成内のライブサイト: %s and %sが一致しません。");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "%sへのライブサイトを設定して続ける...");

DEFINE('_EW_ADMINHEADER_JW', "ジュームラ・ウォッチ ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "バックリンクを削除");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "知識ベース");
DEFINE('_EW_ADMINHEADER_FLOW', "フロー");
DEFINE('_EW_ADMINHEADER_GRAPHS', "グラフ");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "コンポーネント");
DEFINE('_EW_ADMINHEADER_REVIEW', "レビュー");
DEFINE('_EW_ADMINHEADER_WRITE', "次を書く");

DEFINE('_EW_FLOW_TRAFFIC', "トラフィックフロー");
DEFINE('_EW_FLOW_SELECT_PAGE', "ページ選択:");
DEFINE('_EW_FLOW_OUTG_LINKS', "ルート発信リンク数:");
DEFINE('_EW_FLOW_NESTING', "ネスティングレベル:");
DEFINE('_EW_FLOW_SCALE', "スケール:");

DEFINE('_EW_COMERCIAL_AD_FREE', "広告なし版");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "寄付をありがとうございます！");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "ドメイン用登録キー: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "バックリンクを削除或いは設定からフロントエンドのジュームラ・ウォッチのロゴを隠せます。");


DEFINE('_EW_SIZES_LAST_CHECK', "最終確認実行日：");
DEFINE('_EW_SIZES_ADMINISTRATOR', "ブルー = コンポーネント/モジュール/管理者ディレクトリのサイズ");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "コンポーネント");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "合計:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "サイズ");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "全てをリフレッシュ");

DEFINE('_EW_SIZEDATABASE_TABLE', "テーブル");
DEFINE('_EW_SIZEDATABASE_SIZE', "サイズ");
DEFINE('_EW_SIZEDATABASE_1DAY', "1日間変更");
DEFINE('_EW_SIZEDATABASE_7DAY', "7日間変更");
DEFINE('_EW_SIZEDATABASE_28DAY', "28日間変更");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "データなし");
DEFINE('_EW_SIZEDATABASE_TOTAL', "合計:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "全てをリフレッシュ");
DEFINE('_EW_SIZEMODULES_TOTAL', "合計:");
DEFINE('_EW_SIZEMODULES_MODULE', "モジュール");
DEFINE('_EW_SIZEMODULES_SIZE', "サイズ");

DEFINE('_EW_SIZES_FILES', "&ampファイル;ディレクトリ");
DEFINE('_EW_SIZES_BYTES', "バイト");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "リフレッシュ");

DEFINE('_EW_STATS_FOOTER', "ジューマル・ウォッチ &コピー;2006-@年@ マテイ・コバル社提供");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "データベース表サイズ");


DEFINE('_EW_DESC_IPINFODB_KEY', "最終訪問マップ ipinfodb.comキー取得先: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "強制的にタイムゾーンをオフセット");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "更新");
DEFINE('_EW_MENU_UPDATE_TITLE', "バックアップ&アップグレード");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "無料版ではご利用いただけません。ライセンスタブを確認してください。");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "スパム言語禁止有効");
DEFINE('_EW_SPAMWORD_LIST', "スパム言語リスト");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "何度も表示されるタイトルを隠す");
DEFINE('_EW_TRUNCATE_VISITS', "訪問者数を切り捨てる");
DEFINE('_EW_TRUNCATE_STATS', "統計を切り捨てる");
DEFINE('_EW_TRUNCATE_GOALS', "目標を切り捨てる");
DEFINE('_EW_LIMIT_BOTS', "ボットを制限");
DEFINE('_EW_LIMIT_VISITORS', "訪問者数を制限");
DEFINE('_EW_TOOLTIP_WIDTH', "ツールチップ幅");
DEFINE('_EW_TOOLTIP_HEIGHT', "ツールチップ高さ");
DEFINE('_EW_TOOLTIP_URL', "ツールチップURL");
DEFINE('_EW_TOOLTIP_ONCLICK', "ツールチップ・オンクリック");
DEFINE('_EW_IP_STATS', "IP状況");
DEFINE('_EW_IPINFODB_KEY', "IP情報DBキー");
DEFINE('_EW_ONLY_LAST_URI', "唯一の最終URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "フロントエンドのロゴを隠す ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "フロントエンドにフォローなし");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "フロントエンドに戻るリンクなし");
DEFINE('_EW_FRONTEND_USER_LINK', "フロントエンドユーザーリンク");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "フロントエンドの初めの国");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "フロントエンド国名");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "フロントエンドの国大文字");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "フロントエンドの初めの国旗 ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "フロントエンドの国数");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "フロントエンドの国最大コラム数");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "フロントエンドの国最大行数");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "本日のフロントエンド訪問者");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "昨日のフロントエンド訪問者");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "今週のフロントエンド訪問者");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "先週のフロントエンド訪問者");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "今月のフロントエンド訪問者");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "先月のフロントエンド訪問者");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "フロントエンドの訪問者数を隠す");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "フロントエンドの初期合計");
DEFINE('_EW_HISTORY_MAX_VALUES', "履歴最大値");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "履歴最大記録");
DEFINE('_EW_UPDATE_TIME_VISITS', "時間別訪問者更新");
DEFINE('_EW_UPDATE_TIME_STATS', "時間別統計更新");
DEFINE('_EW_STATS_MAX_ROWS', "最大統計行数");
DEFINE('_EW_STATS_IP_HITS', "IPヒット統計");
DEFINE('_EW_MAXID_BOTS', "最大IDボット");
DEFINE('_EW_MAXID_VISITORS', "Maxid Visitors最大ID訪問者数");
DEFINE('_EW_STATS_KEEP_DAYS', "統計を数日間保存 ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "フロントエンド国を隠す ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "フロントエンド訪問者を隠す ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "保管データアンインストール ");
DEFINE('_EW_IGNORE_IP', "IP無視");
DEFINE('_EW_IGNORE_URI', "URI無視");
DEFINE('_EW_IGNORE_USER', "ユーザー無視");
DEFINE('_EW_BLOCKING_MESSAGE', "メッセージブロック");
DEFINE('_EW_SERVER_URI_KEY', "サーバーURIキー");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "フロントエンド訪問者合計初期化");
DEFINE('_EW_SIZEDATABASE_RECORDS', "記録");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " To make the blocking effective, you need to publish ExtraWatch agent BEFORE any content or forms. Eg. on left side in your template.
                    <br/>
                    Go to Module Manager -> ExtraWatch agent -> select position as left");

DEFINE('_EW_EMAIL_SEO_REPORTS', "SEO Reports");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "SEO Nightly email reports enabled");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Watch installation demo");


/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
