<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt     GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "Statistiche");
DEFINE('_EW_MENU_GOALS', "Obiettivi");
DEFINE('_EW_MENU_SETTINGS', "Opzioni");
DEFINE('_EW_MENU_CREDITS', "Riconoscimenti");
DEFINE('_EW_MENU_FAQ', "FAQ");
DEFINE('_EW_MENU_DOCUMENTATION', "Documentazione");
DEFINE('_EW_MENU_LICENSE', "Licenza PRO");
DEFINE('_EW_MENU_DONATORS', "Donazioni");
DEFINE('_EW_MENU_SUPPORT', "Supporta ExtraWatch per eliminare le pubblicit&agrave;  nel Backend.");

// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "Ultimi visitatori");
DEFINE('_EW_VISITS_BOTS', "Bot");
DEFINE('_EW_VISITS_CAME_FROM', "Provenienza");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "Non hai pubblicato il modulo ExtraWatch, quindi non viene registrata alcuna statistica! Vai nella sezione Moduli e pubblicalo su tutte le pagine");
DEFINE('_EW_VISITS_PANE_LOADING', "Carico le visite...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "Statistiche della settimana");
DEFINE('_EW_STATS_WEEK', "Settimana");
DEFINE('_EW_STATS_THIS_WEEK', "questa settimana");
DEFINE('_EW_STATS_UNIQUE', "visitatori");
DEFINE('_EW_STATS_LOADS', "accessi");
DEFINE('_EW_STATS_HITS', "clic");
DEFINE('_EW_STATS_TODAY', "oggi");
DEFINE('_EW_STATS_FOR', "del");
DEFINE('_EW_STATS_ALL_TIME', "Statistiche globali");
DEFINE('_EW_STATS_EXPAND', "espandi");
DEFINE('_EW_STATS_COLLAPSE', "restringi");
DEFINE('_EW_STATS_URI', "Pagine");
DEFINE('_EW_STATS_COUNTRY', "Nazioni");
DEFINE('_EW_STATS_USERS', "Visitatori");
DEFINE('_EW_STATS_REFERERS', "Provenienza");
DEFINE('_EW_STATS_IP', "IP");
DEFINE('_EW_STATS_BROWSER', "Browser");
DEFINE('_EW_STATS_OS', "S.O.");
DEFINE('_EW_STATS_KEYWORDS', "Parole chiave");
DEFINE('_EW_STATS_GOALS', "Obiettivi");
DEFINE('_EW_STATS_TOTAL', "Totali");
DEFINE('_EW_STATS_DAILY', "Statistiche di oggi");
DEFINE('_EW_STATS_DAILY_TITLE', "Statistiche del");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "Statistiche globali");
DEFINE('_EW_STATS_LOADING', "Carico...");
DEFINE('_EW_STATS_LOADING_WAIT', "carico... attendi");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', "Blocco IP");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "Inserisci IP manualmente");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "Inserisci l'IP che vuoi bloccare. (es. 217.242.11.54 o 217.* o 217.242.* per bloccare tutti gli IP con il carattere jolly)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "Vuoi davvero bloccare/sbloccare ");
DEFINE('_EW_STATS_PANE_LOADING', "Carico le statistiche...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "Opzioni");
DEFINE('_EW_SETTINGS_DEFAULT', "Impostazione predefinita");
DEFINE('_EW_SETTINGS_SAVE', "Salva");
DEFINE('_EW_SETTINGS_APPEARANCE', "Aspetto");
DEFINE('_EW_SETTINGS_FRONTEND', "Frontend");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "Storia &amp; prestazioni");
DEFINE('_EW_SETTINGS_ADVANCED', "Avanzate");
DEFINE('_EW_SETTINGS_IGNORE', "Ignora");
DEFINE('_EW_SETTINGS_BLOCKING', "Blocca");
DEFINE('_EW_SETTINGS_EXPERT', "Modalit&agrave;  Esperto");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "Vuoi davvero azzerare tutte le statistiche e i dati dei visitatori?");
DEFINE('_EW_SETTINGS_RESET_ALL', "Azzera tutto");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "Azzera tutte le statistiche e i dati dei visitatori");
DEFINE('_EW_SETTINGS_LANGUAGE', "Lingua");
DEFINE('_EW_SETTINGS_SAVED', "Impostazioni salvate");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "Aggiungi il tuo IP");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "all'elenco.");

// Other / mostly general.
DEFINE('_EW_TITLE', "Monitor AJAX in tempo reale per Joomla");
DEFINE('_EW_BACK', "Indietro");
DEFINE('_EW_ACCESS_DENIED', "Non hai i permessi per visualizzare!");
DEFINE('_EW_LICENSE_AGREE', "Accetto i termini e le &amp; condizioni");
DEFINE('_EW_LICENSE_CONTINUE', "Continua");
DEFINE('_EW_SUCCESS', "Operazione compiuta");
DEFINE('_EW_RESET_SUCCESS', "Tutte le statistiche e i dati sui visitatori sono state cancellate");
DEFINE('_EW_RESET_ERROR', "Si &egrave; verificato un problema e i dati NON sono stati cancellati.");
DEFINE('_EW_CREDITS_TITLE', "Riconoscimenti");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "Statistiche giornaliere e settimanali di");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', "Permesso AJAX negato: visualizza le statistiche nel dominio specificato nel file configuration.php di Joomla - ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "Forse hai dimenticato di digitare www. prima del nome di dominio. Javascript sta tentando di accedere ");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "da");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "ci&ograve; che gli fa pensare che si tratti di un dominio differente.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "Scarica l'ultima versione da");
DEFINE('_EW_HEADER_CAST_YOUR', "Invia il tuo");
DEFINE('_EW_HEADER_VOTE', "Voto");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "Clicca per visualizzare il messaggio");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "Passa sopra con il mouse per visualizzare il messaggio");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "rispetto a ieri");
DEFINE('_EW_TOOLTIP_HELP', "Accede alla guida online per");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "Chiudi");
DEFINE('_EW_TOOLTIP_PRINT', "Stampa");

// Goals.
DEFINE('_EW_GOALS_INSERT', "Nuovo obiettivo");
DEFINE('_EW_GOALS_UPDATE', "Aggiorna l'obiettivo ");
DEFINE('_EW_GOALS_ACTION', "Azione");
DEFINE('_EW_GOALS_TITLE', "Nuovo obiettivo");
DEFINE('_EW_GOALS_NEW', "Nuovo obiettivo");
DEFINE('_EW_GOALS_RELOAD', "Ricarica");
DEFINE('_EW_GOALS_ADVANCED', "Avanzato");
DEFINE('_EW_GOALS_NAME', "Nome");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', "Condizione URI");
DEFINE('_EW_GOALS_GET_VAR', "Variabile GET");
DEFINE('_EW_GOALS_GET_CONDITION', "Condizione GET");
DEFINE('_EW_GOALS_POST_VAR', "Variabile POST");
DEFINE('_EW_GOALS_POST_CONDITION', "Condizione POST");
DEFINE('_EW_GOALS_TITLE_CONDITION', "Condizione TITLE");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "Condizione USERNAME");
DEFINE('_EW_GOALS_IP_CONDITION', "Condizione IP");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "Condizione FROM");
DEFINE('_EW_GOALS_BLOCK', "Blocca");
DEFINE('_EW_GOALS_REDIRECT', "Reindirizza all'URL");
DEFINE('_EW_GOALS_HITS', "Clic");
DEFINE('_EW_GOALS_ENABLED', "Attivo");
DEFINE('_EW_GOALS_EDIT', "Modifica");
DEFINE('_EW_GOALS_DELETE', "Cancella");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "Perderai tutte le statistiche recenti per questo obiettivo. Vuoi eliminarlo davvero?");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "Nazione di provenienza");
DEFINE('_EW_FRONTEND_VISITORS', "Numero di visitatori");
DEFINE('_EW_FRONTEND_TODAY', "Oggi");
DEFINE('_EW_FRONTEND_YESTERDAY', "Ieri");
DEFINE('_EW_FRONTEND_THIS_WEEK', "Questa settimana");
DEFINE('_EW_FRONTEND_LAST_WEEK', "Scorsa settimana");
DEFINE('_EW_FRONTEND_THIS_MONTH', "Questo mese");
DEFINE('_EW_FRONTEND_LAST_MONTH', "Scorso mese");
DEFINE('_EW_FRONTEND_TOTAL', "Totale");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch &egrave; in modalit&agrave;  debug. In questo modo puoi scoprire le cause degli errori. Per disattivarla, modifica la voce EXTRAWATCH_DEBUG in /components/com_extrawatch/config.php da 1 a 0");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "Numero massimo di righe da mostrare quando espandi le statistiche.");
DEFINE('_EW_DESC_STATS_IP_HITS', "Tutti gli indirizzi IP che nei giorni passati hanno effettuato un numero di clic minore di questo numero saranno cancellati dalla cronologia degli IP.");
DEFINE('_EW_DESC_STATS_URL_HITS', "Tutti gli URL che nei giorni passati hanno effettuato un numero di clic minore di questo numero saranno cancellati dalla cronologia degli IP.");
DEFINE('_EW_DESC_IGNORE_IP', "Escludi alcuni indirizzi IP dalle statistiche, separandoli andando a capo. Puoi usare i caratteri jolly. <br/>Es. 192.* ignorer&agrave;  192.168.51.31, 192.168.16.2, ecc..");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "Tempo di aggiornamento dei visitatori (in millisecondi). L'impostazione predefinita &egrave; 2000. Si raccomanda particolare cautela nel modificare questo valore. Al termine, ricarica il Backend di ExtraWatch.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "Tempo di aggiornamento delle statistiche (in millisecondi). L'impostazione predefinita &egrave; 4000. Si raccomanda particolare cautela nel modificare questo valore. Al termine, ricarica il Backend di ExtraWatch.");
DEFINE('_EW_DESC_MAXID_BOTS', "Quante visite dei bot vuoi mantenere nel database.");
DEFINE('_EW_DESC_MAXID_VISITORS', "Quante visite reali vuoi mantenere nel database.");
DEFINE('_EW_DESC_LIMIT_BOTS', "Quanti bot vuoi visualizzare nel Backend.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "Quanti visitatori reali vuoi visualizzare nel Backend.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "Numero massimo di caratteri da visualizzare nei titoli e negli URI lunghi.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "Numero massimo di caratteri da visualizzare nel pannello delle statistiche a destra.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "Per quanti giorni vuoi mantenere le statistiche nel database. 0 = per sempre.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "Se il tuo fuso orario &egrave; diverso da quello del server che ospita il sito (imposta un valore positivo o negativo in ore).");
DEFINE('_EW_DESC_WEEK_OFFSET', "Compensazione della settimana. Il calendario/(3600*24*7) parte dal 1.1.1970. Con questa compensazione, puoi far partire la settimana dal lunedÃ¬.");
DEFINE('_EW_DESC_DAY_OFFSET', "Compensazione del giorno. Il calendario/(3600*24) parte dal 1.1.1970. Con questa compensazione, puoi far partire la giornata alle 00:00.");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "Usa un'icona vuota (1x1 px) nel Frontend");
DEFINE('_EW_DESC_IP_STATS', "Abilita le statistiche sugli indirizzi IP. In alcune nazioni, la legge proibisce di mantenere gli IP in un database per un tempo maggiore di quello consentito. Utilizza questa opzione a tuo rischio e pericolo.");
DEFINE('_EW_DESC_HIDE_ADS', "Questa opzione nasconde le pubblicit&agrave;  nel Backend, nel caso ti infastidiscano. Mantenendole, supporti il futuro sviluppo di questo componente. Grazie.");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "Togli il segno di spunta se vuoi visualizzare i messaggi quando passi il mouse sopra un'opzione, invece di cliccarci.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "L'impostazione predefinita &egrave; 'REDIRECT_URL', che &egrave; consigliabile se utilizzi la riscrittura delle URL. Se &egrave; collegata esclusivamente alla pagina index.php, puoi usare 'SCRIPT_URL'.");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "Messaggio visualizzato per bloccare un utente o per fornire ulteriori informazioni sul blocco.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "Larghezza messaggi");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "Altezza messaggi");
DEFINE('_EW_DESC_TOOLTIP_URL', "Qui puoi inserire una URL qualsiasi per visualizzare l'indirizzo IP del visitatore. {ip} sar&agrave; sostituito dall'indirizzo IP del visitatore. Es. http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "Qui puoi inserire una URL qualsiasi da ignorare nelle statistiche. Puoi usare i caratteri jolly * e ?. Es.: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "Specifica un nome per visualizzare l'obiettivo nelle statistiche.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "Tutto ci&ograve; che viene dopo il tuo nome di dominio. Per http://www.codegravity.com/projects/ l'URI &egrave;: /projects/ (Esempio: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', "Puoi trovare la variabile GET nell'indirizzo URL, solitamente dopo un ? o &amp;. Es. http://www.codegravity.com/index.php?<u>name</u>=peter&amp;<u>surname</u>=smith. Puoi usare <u>*</u> in questo capo per esaminare tutti i valori della variabile GET. (Esempio: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "Il valore per il campo precedente. (Esempio: <b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "Molto simile al precedente, ma qui cerchiamo i valori inseriti nei form. Quindi, se hai un form sul tuo sito, ha un campo &lt;input type='text' name='<u>experiences</u>' /&gt;. (Esempio: <b>exper*ces</b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "Il valore per il campo POST. Per esempio se vuoi controllare se l'utente ha usato java. (Esempio: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "Il titolo di una pagina. (Esempio: <b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "Il nome di un utente che ha effettuato l'accesso. (Esempio: <b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', "L'indirizzo IP di un utente. (Esempio: <b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "L'URL da cui proviene l'utente. (Esempio: <b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "L'utente viene reindirizzato su un URL specificata da te. Questa funzione ha una priorit&agrave; maggiore rispetto al blocco. (Esempio: <b>http://www.codegravity.com/goaway.html</b>)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "Quanti caratteri visualizzare nella tabella degli obiettivi.");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "Collegamento a codegravity.com. Puoi disattivarlo, ma ti saremmo grati se lo lasciassi attivo. Grazie.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "Mostra le statistiche globali per le nazioni nel modulo del Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "Inverti l'ordine di visualizzazione Visitatori/Nazioni nel Frontend. Se togli il segno di spunta, i Visitatori appariranno per primi.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "Numero di nazioni da visualizzare nel Frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "Mostra il numero di visitatori per ogni nazione nel modulo del Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "Tempo in secondi per il fetching della cache del numero di visitatori per nazione nel modulo del Frontend");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "Tempo in secondi per il fetching della cache del numero di visitatori nel modulo del Frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "Mostra i visitatori di oggi nel Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "Mostra i visitatori di ieri nel Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "Mostra i visitatori della settimana in corso nel Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "Mostra i visitatori della settimana scorsa nel Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "Mostra i visitatori del mese in corso nel Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "Mostra i visitatori del mese scorso nel Frontend. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "Visualizza il numero totale di visitatori da quando hai installato ExtraWatch. Se cambi questa impostazione, sar&agrave; visibile nel Frontend dopo aver impostato il tempo in CACHE_FRONTEND_...");
DEFINE('_EW_DESC_LANGUAGE', "File della lingua da utilizzare. I file della lingua si trovano in /components/com_extrawatch/lang/. Se vuoi crearne uno nuovo, copia quello predefinito (english.php), rinominalo (per es. italian.php) e posizionalo in questa directory. Quindi, traduci tutti i valori chiave sulla destra.");
DEFINE('_EW_DESC_GOALS', "Gli obiettivi ti permettono di impostare dei parametri specifici. Quando questi parametri si verificano, il contatore degli obiettivi aumenta. In questo modo, puoi verificare se un utente ha visitato un'URL specifica, se ha inviato un determinato valore, se &egrave; associato a un nome utente particolare o proviene da un certo indirizzo. Puoi anche bloccare alcuni utenti o reindirizzarli verso altre URL.");
DEFINE('_EW_DESC_GOALS_INSERT', "Puoi usare i caratteri jolly * e ? in tutti i campi, tranne quello del nome. Per esempio: ?ear per near, tear, ecc. oppure p*r per pr, peer, pear, ecc.");
DEFINE('_EW_DESC_GOALS_BLOCK', "Impostalo su 1 se vuoi bloccare il visitatore e impedirgli di visualizzare il resto del sito a parte un avviso del blocco (senza reindirizzamento). Il suo IP verr&agrave; aggiunto alle statistiche degli IP bloccati. (Esempio: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "Condizione COUNTRY");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', "Codice maiuscolo di 2 lettere per la nazione (Es: <b>IT</b>)");
DEFINE('_EW_STATS_INTERNAL', "Collegamenti interni");
DEFINE('_EW_STATS_FROM', "Da");
DEFINE('_EW_STATS_TO', "A");
DEFINE('_EW_STATS_ADD_TO_GOALS', "Aggiungi agli obiettivi");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "Aggiungi un obiettivo per questa nazione");
DEFINE('_EW_MENU_REPORT_BUG', "Segnala bug");
DEFINE('_EW_GOALS_COUNTRY', "Nazione");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "Se vuoi i nomi delle nazioni in maiuscolo nel Frontend (Es: GERMANY, UNITED KINGDOM invece di Germany, United Kingdom)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "Tempo in secondi per il fetching della cache degli utenti nel Frontend");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "Valore iniziale del contatore Totale del Frontend. Utile se stai effettuando una migrazione da un altro strumento per le statistiche. (Es.: 20000). Se non vuoi sfruttare questa funzione, reimposta il valore a 0.");
DEFINE('_EW_DESC_IGNORE_USER', "Ignora gli utenti elencati in questa casella di testo. Inseriscili uno per linea. (Es.: io {line break} mark_*) ");
DEFINE('_EW_FRONTEND_USERS_MOST', "Gli utenti pi&ugrave; attivi di oggi su un totale di");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "Abilitare il ban in base alle parole elencate qui sotto?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "Le parole chiave pi&ugrave; comuni utilizzate dagli spambot. Puoi usare i caratteri jolly (Es.: ph?rmac*). Se l'opzione qui sopra &egrave; attivata, ExtraWatch monitorer&agrave; ogni inserimento di queste parole in un form sul tuo sito (la richiesta HTTP POST). Progettato per i form creati con Joomla: forum, commenti, ecc. In ogni caso, &egrave; molto efficace contro gli spambot che tentino di inviare messaggi in qualsiasi tipo di form)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "Anti-Spam");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "Un collegamento nel modulo Utenti del Frontend. Ti permette di specificare un'URL, che si apre quando l'utente clicca sul suo nome. Deve contenere il valore {user}, che sar&agrave; sostituito dal vero nome utente. (Es. index.php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_STATS_KEYPHRASE', "Frasi chiave");
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "Valore massimo nella cronologia (Esempio: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "In Visite mostra solo l'ultima pagina visitata, non tutte");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "In Visite nascondi il nome del sito, se ripetuto nel titolo delle pagine visitate");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "Numero massimo di visitatori da mantenere nel database per la Cronologia Visite. Prestare attenzione con questa impostazione, se hai un sito con molto traffico il database pu&ograve; ingrandirsi molto in fretta. Verificare sempre la dimensione dei dati contenuti nelle tabelle della cronologia (history) nello Status");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "Mantenere le tabelle del database in caso di disinstallazione. Selezionare questa opzione prima della disinstallazione se si sta effettuando un aggiornamento e si desidera mantenere i dati.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "Riceverai una mail nella notte contenente i report del giorno precedente. Potrai leggerla la mattina");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "Indirizzo E-Mail al quale si desidera ricevere questi reports");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "Inserire nel report via mail solo righe dove la percentuale &egrave; maggiore di {value}. Impostare a 0 se non si desidera utilizzare questa funzione <i>(esempio: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "Inserire nel report via mail solo valori cambiati <b>positivamente in 1 giorno</b> maggiori di {value}%. Impostare a 0 se non si desidera utilizzare questa funzione <i>(esempio: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "Inserire nel report via mail solo valori cambiati <b>negativamente in 1 giorno</b> minori di {value}%. Impostare a 0 se non si desidera utilizzare questa funzione <i>(esempio: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "Inserire nel report via mail solo valori cambiati <b>positivamente in 7 giorni</b> maggiori di {value}%. Impostare a 0 se non si desidera utilizzare questa funzione <i>(esempio: 2)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "Inserire nel report via mail solo valori cambiati <b>negativamente in 7 giorni</b> minori di {value}%. Impostare a 0 se non si desidera utilizzare questa funzione <i>(esempio: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "Inserire nel report via mail solo valori cambiati <b>positivamente in 30 giorni</b> maggiori di {value}%. Impostare a 0 se non si desidera utilizzare questa funzione <i>(esempio: 2)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "Inserire nel report via mail solo valori cambiati <b>negativamente in 30 giorni</b> minori di {value}%. Impostare a 0 se non si desidera utilizzare questa funzione <i>(esempio: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(attivo nella versione PRO)</b> Attivare questa impostazione se si desidera impostare l'attributo rel='nofollow' al collegamento del logo ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "Max. caratteri della riga del nome mail. Modificarlo se la finestra del mesagio email &egrave; troppo piccola");

DEFINE('_EW_MENU_HISTORY', "Cronologia");
DEFINE('_EW_MENU_EMAILS', "Emails");
DEFINE('_EW_MENU_STATUS', "Status");
DEFINE('_EW_DESC_BLOCKED', "Questi IP sono stati bloccati dall'anti-spam");


DEFINE('_EW_HISTORY_VISITORS', "Cronologia visitatori");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "Mostra solo i %d ultimi dati.
                Per modificare questa impostazione vai a Impostazioni -&gt; Cronologia &amp; Prestazioni -&gt; HISTORY_MAX_DB_RECORDS . Attenzione, questa impostazione pu&ograve; influenzare i tempi di caricamento dei dati sottostanti.  ");
DEFINE('_EW_MENU_BUG', "Segnala un malfunzionamento");
DEFINE('_EW_MENU_FEATURE', "Richiedi altre funzioni");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "Parole chiave");

DEFINE('_EW_BLOCKING_UNBLOCK', "sblocca");
DEFINE('_EW_STATS_KEYPHRASE ', "Frasi chiave");
DEFINE('_EW_STATUS_DATABASE', "Status del database");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "nome tabella");
DEFINE('_EW_STATUS_DATABASE_ROWS', "righe");
DEFINE('_EW_STATUS_DATABASE_DATA', "dati");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "totale");

DEFINE('_EW_EMAIL_REPORTS', "Report via mail");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "Generato un report via mail da ieri, filtrato");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "Valori dei filtri mail");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "valore");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "percentuale");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', "modifica a 1 giorno");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', "modifica a 7 giorni");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', "modifica a 28 giorni");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch ha bloccato %d contatti da spammer oggi, totale: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "Indirizzi IP bloccati");
DEFINE('_EW_ANTISPAM_SETTINGS', "Impostazioni Anti-Spam");
DEFINE('_EW_TRAFFIC_AJAX', "Aggiornamenti traffico AJAX");


DEFINE('_EW_HISTORY_PREVIOUS', "precedente");
DEFINE('_EW_HISTORY_NEXT', "successivo");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "Numero di colonne di paesi");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "Numero di righe di paesi");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "Mostra/Non Mostrare il nome del paese");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "Mostra prima le bandiere, poi le percentuali");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "Condizione GET inversa");
DEFINE('_EW_GOALS_POST_INVERSED', "Condizione POST inversa");
DEFINE('_EW_GOALS_TITLE_INVERSED', "Condizione del Titolo inversa");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "Condizione Nome Utente inversa");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "Condizone Proviene da inversa");

DEFINE('_EW_STATS_MAP', "Mappa delle ultime visite");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "Inserire la chiave d'accesso di <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a> per visualizzare la mappa delle ultime visite:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "salva la chiave d'accesso");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "Inserire una chiave d'accesso valida per favore. &Egrave; possibile ottenerle a: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "BAD REQUEST: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "Dati del modulo spediti:");
DEFINE('_EW_VISIT_URL_PARAMETERS', "Parametri URL:");
DEFINE('_EW_VISIT_ADD_PAGE', " Aggiungere pagina come obiettivo");
DEFINE('_EW_VISIT_BLOCK_IP', " Bloccare questo indirizzo IP");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', " Aggiungere questa variabile del form come condizione da raggiungere");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', " Aggiungere questo parametro URL come condizione da raggiungere");

DEFINE('_EW_TREND_EMPTY', "Vuoto");

DEFINE('_EW_NOT_NUMBER', " ATTENZIONE: Il valore inserito non &egrave; un numero. ExtraWatch potrebbe non funzionare correttamente!");
DEFINE('_EW_EVALUATION_LEFT', "&nbsp; Questa &egrave; una versione di prova della durata di 15 giorni. Giorni restanti: <b>%d</b>. &Egrave; possibile acquistare la licenza <a href='http://www.codegravity.com/donate/extrawatch/' target='_blank'>licenza di ExtraWatch per il vostro domminio</a> che ha durata illimitata per questa versione e per i tutti gli aggiornamenti successivi.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', " La vostra versione di prova &egrave; scaduta. Per favore acquistate ExtraWatch");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "La licenza &egrave; stata attivata. Grazie");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>Errore: la chiave per la licenza e il vostro dominio non combaciano.</b><br/>Nel form di attivazione avete inserito lo stesso dominio indicato in basso? In caso affermativo contattare: info@codegravity.com");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "Se visualizzate il messaggio riportato pi&ugrave; sopra per tanto tempo potrebbe essersi verifcato un errore nel vostro sito.
                    Aprire components/com_extrawatch/config.php
                    decommentare ed impostare il vostro sito. Per es..:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "Attenzione: il sito del vostro browser e il sito nella configurazione: %s e %s non combaciano.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "Impostare il sito a: %s e continuare...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "Rimuovere il Backlink");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "Knowledge Base");
DEFINE('_EW_ADMINHEADER_FLOW', "Flusso");
DEFINE('_EW_ADMINHEADER_GRAPHS', "Grafici");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "Componenti");
DEFINE('_EW_ADMINHEADER_REVIEW', "Review");
DEFINE('_EW_ADMINHEADER_WRITE', "Scrivi ");

DEFINE('_EW_FLOW_TRAFFIC', "Flusso di traffico");
DEFINE('_EW_FLOW_SELECT_PAGE', "Pagina selezionata:");
DEFINE('_EW_FLOW_OUTG_LINKS', "Links in uscita dalla root:");
DEFINE('_EW_FLOW_NESTING', "Livello di nidificazione:");
DEFINE('_EW_FLOW_SCALE', "Scala:");

DEFINE('_EW_COMERCIAL_AD_FREE', "Versione Ad-free");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "Grazie mille per la vostra donazione!");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "La chiave di registrazione per il vostro dominio %s &egrave;: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "Ora &egrave; possibile rimuovere il backlink o nascondere il logo ExtraWatch nel frontend dalle Impostazioni ");


DEFINE('_EW_SIZES_LAST_CHECK', "Ultimo controllo effettuato:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "BLUE = Dimensione di componente/modulo nella directory /administrator");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "Componente");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "Totale:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "Dimensione");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "Aggiorna tutto");

DEFINE('_EW_SIZEDATABASE_TABLE', "Tabella");
DEFINE('_EW_SIZEDATABASE_SIZE', "Dimensione");
DEFINE('_EW_SIZEDATABASE_1DAY', "Modifica a 1 giorno");
DEFINE('_EW_SIZEDATABASE_7DAY', "Modifica a 7 giorni");
DEFINE('_EW_SIZEDATABASE_28DAY', "Modifica a 28 giorni");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "nessun dato");
DEFINE('_EW_SIZEDATABASE_TOTAL', "Totale:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "Aggiorna tutto");
DEFINE('_EW_SIZEMODULES_TOTAL', "Totale:");
DEFINE('_EW_SIZEMODULES_MODULE', "Modulo");
DEFINE('_EW_SIZEMODULES_SIZE', "Dimensione");

DEFINE('_EW_SIZES_FILES', "Files &amp; Directories");
DEFINE('_EW_SIZES_BYTES', "bytes");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "Aggiorna");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");

DEFINE('_EW_DESC_IPINFODB_KEY', "Chiave per la mappa degli ultimi visitatori ipinfodb.com fornita da: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "Forza la differenza di orario");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "Aggiornamento");
DEFINE('_EW_MENU_UPDATE_TITLE', "Backup & Aggiornamento");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "Non disponibile nella versione free, verificare la licenza");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "Attiva il blocco di parole indesiderate");
DEFINE('_EW_SPAMWORD_LIST', "Lista parole indesiderate");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "Nascondi titolo se ripetuto");
DEFINE('_EW_TRUNCATE_VISITS', "Limita Visite");
DEFINE('_EW_TRUNCATE_STATS', "Limita Statistiche");
DEFINE('_EW_TRUNCATE_GOALS', "Limita Obiettivi");
DEFINE('_EW_LIMIT_BOTS', "Limita Bots");
DEFINE('_EW_LIMIT_VISITORS', "Limita Visitatori");
DEFINE('_EW_TOOLTIP_WIDTH', "Larghezza Popup suggerimenti");
DEFINE('_EW_TOOLTIP_HEIGHT', "Altezza Popup suggerimenti");
DEFINE('_EW_TOOLTIP_URL', "URL Popup suggerimenti");
DEFINE('_EW_TOOLTIP_ONCLICK', "Popup suggerimenti OnClick");
DEFINE('_EW_IP_STATS', "Statistiche IP");
DEFINE('_EW_IPINFODB_KEY', "Informazioni IP Chiave DB ");
DEFINE('_EW_ONLY_LAST_URI', "Solo ultime URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "Nascondi logo nel Front End ");
DEFINE('_EW_FRONTEND_NOFOLLOW', "Imposta No Follow nel Front End");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "Nessun backlink nel Front End");
DEFINE('_EW_FRONTEND_USER_LINK', "Links Front User");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "Imposta prima i paesi nel Front End");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "Imposta i nomi dei paesi nel Front End");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "Imposta i nomi dei paesi nel Front End in miauscolo");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "Imposta prima le bandiere dei paesi nel Front End ");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "Numero peasi nel Front End");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "Numero max. colonne paesi nel Front End");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "Numero max. righe paesi nel Front End");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "Visitatori di oggi nel Front End ");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "Visitatori di ieri nel Front End ");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "Visitatori questa settimana nel Front End ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "Visitatori la scorsa settimana nel Front End ");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "Visitatori questo mese nel Front End ");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "Visitatori il mese scorso nel Front End");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "Nascondere totale visitatori nel Front End");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL	', "Totale iniziale nel Front End");
DEFINE('_EW_HISTORY_MAX_VALUES', "Valore massimo cronologia");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "Numero massimo dati nella cronologia");
DEFINE('_EW_UPDATE_TIME_VISITS', "Aggiorna orario visite");
DEFINE('_EW_UPDATE_TIME_STATS', "Aggiorna orario statistiche");
DEFINE('_EW_STATS_MAX_ROWS', "Numero max. righe statistiche");
DEFINE('_EW_STATS_IP_HITS', "Statistiche contatti per indirizzi IP");
DEFINE('_EW_MAXID_BOTS', "Max ID bots");
DEFINE('_EW_MAXID_VISITORS', "Maxid visitatori");
DEFINE('_EW_STATS_KEEP_DAYS', "Mantenere giorni statistiche ");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "Cache paesi nel Front End ");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "Cache visitatori nel Front End ");

DEFINE('_EW_UNINSTALL_KEEP_DATA	', "Disinstalla mantenedo i dati ");
DEFINE('_EW_IGNORE_IP', "Ignora IP");
DEFINE('_EW_IGNORE_URI', "Ignora URI");
DEFINE('_EW_IGNORE_USER', "Ignora Utente");
DEFINE('_EW_BLOCKING_MESSAGE', "Blocco Messaggi");
DEFINE('_EW_SERVER_URI_KEY', "Chiave del Server URI");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "Visitatori totali iniziali nel Front End");
DEFINE('_EW_SIZEDATABASE_RECORDS', "Dati");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', " Per rendere il blocco effettivo &egrave; necessario pubblicare l'agente ExtraWatch prima di qualsiasi contenuto o form. Per es. sul lato sinistro del template.
                    <br/>
                    Vai a Gestione Moduli -> ExtraWatch agent -> selezionare posizione a sinistra");
DEFINE('_EW_EMAIL_SEO_REPORTS', "SEO Reports");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', "Email notturna per SEO Reports attivata");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "Guarda la demo d'installazione");


/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");
/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
