<?php

/**
 * @file
 * ExtraWatch - A real-time ajax monitor and live stats
 * @package ExtraWatch
 * @version @VERSION@
 * @revision @REVISION@
 * @license http://www.gnu.org/licenses/gpl-3.0.txt GNU General Public License v3
 * @copyright (C) @YEAR@ by CodeGravity.com - All rights reserved!
 * @website http://www.codegravity.com
 */

defined('_JEXEC') or die('Restricted access');

//ExtraWatch language file - to create a new language file, just copy the english.php to eg. german.php and place into./components/com_extrawatch/lang/

// Main Menu.
DEFINE('_EW_MENU_STATS', "實時統計");
DEFINE('_EW_MENU_GOALS', "目標");
DEFINE('_EW_MENU_SETTINGS', "設置");
DEFINE('_EW_MENU_CREDITS', "積分");
DEFINE('_EW_MENU_FAQ', "常見問題");
DEFINE('_EW_MENU_DOCUMENTATION', "文件");
DEFINE('_EW_MENU_LICENSE', "許可證");
DEFINE('_EW_MENU_DONATORS', "支持者");
DEFINE('_EW_MENU_SUPPORT', "支持ExtraWatch以便從後台刪除ExtraWatch 的廣告.");


// Left visitors real-time window.
DEFINE('_EW_VISITS_VISITORS', "最新訪客");
DEFINE('_EW_VISITS_BOTS', "機器人");
DEFINE('_EW_VISITS_CAME_FROM', "來自");
DEFINE('_EW_VISITS_MODULE_NOT_PUBLISHED', "你的ExtraWatch模塊沒有發布！沒有新的統計信息被記錄下來.發布它,去模塊部分並把其在所有網頁上發布");
DEFINE('_EW_VISITS_PANE_LOADING', "載入訪問...");

// Right stats window.
DEFINE('_EW_STATS_TITLE', "一周訪問統計");
DEFINE('_EW_STATS_WEEK', "週");
DEFINE('_EW_STATS_THIS_WEEK', "本週");
DEFINE('_EW_STATS_UNIQUE', "獨特");
DEFINE('_EW_STATS_LOADS', "負載");
DEFINE('_EW_STATS_HITS', "點擊");
DEFINE('_EW_STATS_TODAY', "今天");
DEFINE('_EW_STATS_FOR', "為");
DEFINE('_EW_STATS_ALL_TIME', "所有時間");
DEFINE('_EW_STATS_EXPAND', "擴大");
DEFINE('_EW_STATS_COLLAPSE', "崩潰");
DEFINE('_EW_STATS_URI', "頁");
DEFINE('_EW_STATS_COUNTRY', "國家");
DEFINE('_EW_STATS_USERS', "用戶");
DEFINE('_EW_STATS_REFERERS', "查閱情況");
DEFINE('_EW_STATS_IP', "IPs");
DEFINE('_EW_STATS_BROWSER', "瀏覽器");
DEFINE('_EW_STATS_OS', "操作系統");
DEFINE('_EW_STATS_KEYWORDS', "關鍵詞");
DEFINE('_EW_STATS_GOALS', "目標");
DEFINE('_EW_STATS_TOTAL', "共有");
DEFINE('_EW_STATS_DAILY', "日報");
DEFINE('_EW_STATS_DAILY_TITLE', "每日統計");
DEFINE('_EW_STATS_ALL_TIME_TITLE', "所有時間統計");
DEFINE('_EW_STATS_LOADING', "加載...");
DEFINE('_EW_STATS_LOADING_WAIT', "載入中...請等待");
DEFINE('_EW_STATS_IP_BLOCKING_TITLE', " IP阻塞");
DEFINE('_EW_STATS_IP_BLOCKING_ENTER', "手動輸入IP");
DEFINE('_EW_STATS_IP_BLOCKING_MANUALLY', "輸入你要阻止IP地址. (如217.242.11.54或217 * 217.242 *阻止所有IP地址匹配的通配符)");
DEFINE('_EW_STATS_IP_BLOCKING_TOGGLE', "實時阻塞切換");
DEFINE('_EW_STATS_PANE_LOADING', "載入統計...");

// Settings.
DEFINE('_EW_SETTINGS_TITLE', "設置");
DEFINE('_EW_SETTINGS_DEFAULT', "默認");
DEFINE('_EW_SETTINGS_SAVE', "保存");
DEFINE('_EW_SETTINGS_APPEARANCE', "外觀");
DEFINE('_EW_SETTINGS_FRONTEND', "前台");
DEFINE('_EW_SETTINGS_HISTORY_PERFORMANCE', "歷史與性能");
DEFINE('_EW_SETTINGS_ADVANCED', "高級");
DEFINE('_EW_SETTINGS_IGNORE', "忽略");
DEFINE('_EW_SETTINGS_BLOCKING', "阻止");
DEFINE('_EW_SETTINGS_EXPERT', "專家");
DEFINE('_EW_SETTINGS_RESET_CONFIRM', "你真的要重置所有統計和訪問者數據?");
DEFINE('_EW_SETTINGS_RESET_ALL', "重置所有");
DEFINE('_EW_SETTINGS_RESET_ALL_LINK', "重置所有統計訪問者數據");
DEFINE('_EW_SETTINGS_LANGUAGE', "語言");
DEFINE('_EW_SETTINGS_SAVED', "設置被保存");
DEFINE('_EW_SETTINGS_ADD_YOUR_IP', "添加您的IP ");
DEFINE('_EW_SETTINGS_TO_THE_LIST', "到列表.");

// Other / mostly general.
DEFINE('_EW_TITLE', "一個實時的AJAX joomla監控");
DEFINE('_EW_BACK', "返回");
DEFINE('_EW_ACCESS_DENIED', "您沒有權限查看此!");
DEFINE('_EW_LICENSE_AGREE', "我同意以上的條款與條件");
DEFINE('_EW_LICENSE_CONTINUE', "繼續");
DEFINE('_EW_SUCCESS', "操作成功");
DEFINE('_EW_RESET_SUCCESS', "所有統計和訪客數據擦除成功");
DEFINE('_EW_RESET_ERROR', "數據沒有被成功擦除,出現異常");
DEFINE('_EW_CREDITS_TITLE', "積分");
DEFINE('_EW_TRENDS_DAILY_WEEKLY', "每日和每週的統計");
DEFINE('_EW_AJAX_PERMISSION_DENIED_1', " AJAX權限被拒絕: 請從你在Joomla的configuration.php中指定的域訪問這些統計數據");
DEFINE('_EW_AJAX_PERMISSION_DENIED_2', "也許你只是忘記了在您的域名前面添加www.您的JavaScript試圖訪問");
DEFINE('_EW_AJAX_PERMISSION_DENIED_3', "從");
DEFINE('_EW_AJAX_PERMISSION_DENIED_4', "什麼使得它認為這是一個不同的域.");

// Header.
DEFINE('_EW_HEADER_DOWNLOAD', "從獲取最新的擴展的代碼");
DEFINE('_EW_HEADER_CAST_YOUR', "請投下您的");
DEFINE('_EW_HEADER_VOTE', "投票");

// Tooltips.
DEFINE('_EW_TOOLTIP_CLICK', "單擊顯示幫助提示");
DEFINE('_EW_TOOLTIP_MOUSE_OVER', "懸停鼠標顯示幫助提示");
DEFINE('_EW_TOOLTIP_YESTERDAY_INCREASE', "昨日增加");
DEFINE('_EW_TOOLTIP_HELP', "打開外部網上幫助");
DEFINE('_EW_TOOLTIP_WINDOW_CLOSE', "關閉此窗口");
DEFINE('_EW_TOOLTIP_PRINT', "打印");

// Goals.
DEFINE('_EW_GOALS_INSERT', "插入一個新的目標");
DEFINE('_EW_GOALS_UPDATE', "更新的目標編號.");
DEFINE('_EW_GOALS_ACTION', "行動");
DEFINE('_EW_GOALS_TITLE', "新目標");
DEFINE('_EW_GOALS_NEW', "新目標");
DEFINE('_EW_GOALS_RELOAD', "刷新");
DEFINE('_EW_GOALS_ADVANCED', "高級");
DEFINE('_EW_GOALS_NAME', "名");
DEFINE('_EW_GOALS_ID', "id");
DEFINE('_EW_GOALS_URI_CONDITION', " URI的條件");
DEFINE('_EW_GOALS_URI_INVERSED', " URI的反演條件");
DEFINE('_EW_GOALS_GET_VAR', "GET變量 ");
DEFINE('_EW_GOALS_GET_CONDITION', "GET條件");
DEFINE('_EW_GOALS_POST_VAR', "POST變量");
DEFINE('_EW_GOALS_POST_CONDITION', " POST條件");
DEFINE('_EW_GOALS_TITLE_CONDITION', "標題條件");
DEFINE('_EW_GOALS_USERNAME_CONDITION', "用戶名條件");
DEFINE('_EW_GOALS_IP_CONDITION', " IP條件");
DEFINE('_EW_GOALS_IP_INVERSED', "IP反演條件");
DEFINE('_EW_GOALS_CAME_FROM_CONDITION', "來自條件");
DEFINE('_EW_GOALS_BLOCK', "阻止");
DEFINE('_EW_GOALS_REDIRECT', "重定向到URL ");
DEFINE('_EW_GOALS_HITS', "點擊");
DEFINE('_EW_GOALS_ENABLED', "啟用");
DEFINE('_EW_GOALS_EDIT', "編輯");
DEFINE('_EW_GOALS_DELETE', "刪除");
DEFINE('_EW_GOALS_DELETE_CONFIRM', "你將失去所有這一目標最近的統計數據.你真的要刪除這個目標編號.");

// Frontend.
DEFINE('_EW_FRONTEND_COUNTRIES', "國家");
DEFINE('_EW_FRONTEND_VISITORS', "訪客");
DEFINE('_EW_FRONTEND_TODAY', "今天");
DEFINE('_EW_FRONTEND_YESTERDAY', "昨天");
DEFINE('_EW_FRONTEND_THIS_WEEK', "本週");
DEFINE('_EW_FRONTEND_LAST_WEEK', "上週");
DEFINE('_EW_FRONTEND_THIS_MONTH', "本月");
DEFINE('_EW_FRONTEND_LAST_MONTH', "上個月");
DEFINE('_EW_FRONTEND_TOTAL', "總計");

// Settings description - quite long.
DEFINE('_EW_DESC_DEBUG', "ExtraWatch運行在調試模式.通過這種方式,你可以發現錯誤的原因.要關閉它,請更改EXTRAWATCH_DEBUG 的值/components/com_extrawatch/config.php 從1到0 ");
DEFINE('_EW_DESC_STATS_MAX_ROWS', "當統計在擴展模式時顯示的最大行數.");
DEFINE('_EW_DESC_STATS_IP_HITS', "過去幾天中少於這個點擊數值的所有IP地址將被從IP歷史列表中刪除.");
DEFINE('_EW_DESC_STATS_URL_HITS', "過去幾天中少於這個點擊數值的所有URL將被從IP歷史列表中刪除.");
DEFINE('_EW_DESC_IGNORE_IP', "從統計中排除某些IP.用一個新行分開.這裡您可以使用通配符. <br/>例如: 192 .*會忽略192.168.51.31,192.168.16.2等.");
DEFINE('_EW_DESC_UPDATE_TIME_VISITS', "訪客刷新時間以毫秒為單位,默認是2000,不用隨意修改此值.修改後請重新載入ExtraWatch後台.");
DEFINE('_EW_DESC_UPDATE_TIME_STATS', "統計刷新時間以毫秒為單位,默認是4000,不用隨意修改此值.修改後請重新載入ExtraWatch後台.");
DEFINE('_EW_DESC_MAXID_BOTS', "多少機器人訪問保持在一個數據庫中.");
DEFINE('_EW_DESC_MAXID_VISITORS', "多少真正的訪問保持在一個數據庫中.");
DEFINE('_EW_DESC_LIMIT_BOTS', "在後台顯示多少機器人.");
DEFINE('_EW_DESC_LIMIT_VISITORS', "在後台顯示多少真正的訪客.");
DEFINE('_EW_DESC_TRUNCATE_VISITS', "在長標題和URI中顯示的最多字符數.");
DEFINE('_EW_DESC_TRUNCATE_STATS', "在右側統計面板中顯示的最多字符數.");
DEFINE('_EW_DESC_STATS_KEEP_DAYS', "在數據庫中保存的統計信息的天數,0 =無限.");
DEFINE('_EW_DESC_TIMEZONE_OFFSET', "當你和您的服務器處在不同的時區(正, 負多少小時)");
DEFINE('_EW_DESC_WEEK_OFFSET', "週偏移,時間戳/(3600 * 24 * 7)從1.1.1970週數,這個偏移是一種修正,使其從星期一開始");
DEFINE('_EW_DESC_DAY_OFFSET', "日偏移,時間戳/(3600 * 24)給天數從1.1.1970,這個偏移校正在00:00開始");
DEFINE('_EW_DESC_FRONTEND_HIDE_LOGO', "<b>(專業版功能)</b>要使用前台1x1px的一個空白圖標");
DEFINE('_EW_DESC_IP_STATS', "啟用IP地址統計.在一些國家保持較長時間的IP數據庫是被法律禁止的.使用者風險自負.");
DEFINE('_EW_DESC_HIDE_ADS', "如果後台廣告惹惱了你, 通過此設置可以隱藏.多謝你的理解,通過這些廣告的收入可以支持該軟件的進一步發展");
DEFINE('_EW_DESC_TOOLTIP_ONCLICK', "取消選中,如果你要顯示的幫助提示, 可以懸停鼠標顯示幫助提示.");
DEFINE('_EW_DESC_SERVER_URI_KEY', "默認為'REDIRECT_URL',這是標準的,如果你使用URL重寫,可以設置為'SCRIPT_URL',如果它僅記錄index.php ");
DEFINE('_EW_DESC_BLOCKING_MESSAGE', "消息顯示被阻止的用戶或進一步的信息,你為什麼阻止這些用戶.");
DEFINE('_EW_DESC_TOOLTIP_WIDTH', "幫助提示寬度");
DEFINE('_EW_DESC_TOOLTIP_HEIGHT', "說明文字高度");
DEFINE('_EW_DESC_TOOLTIP_URL', "在此處輸入URL,可以查看對應的IP. {IP}訪問者的IP地址將被替換.例如: http://somewebsite.com/query?iplookup={ip}");
DEFINE('_EW_DESC_IGNORE_URI', "您可以輸入想從統計中忽略的URI. 在這裡, 您可以使用通配符(*和？). 例如: /freel?n* ");
DEFINE('_EW_DESC_GOALS_NAME', "在這裡指定一​​個目標名字.這個名字,你會在統計看到.");
DEFINE('_EW_DESC_GOALS_URI_CONDITION', "域名後的其他內容. 例如http://www.codegravity.com/projects/ the URI 是: /projects/ (例如: <b>/projects*</b>)");
DEFINE('_EW_DESC_GOALS_GET_VAR', " GET變量是一個你可以在URL的?或者&後面看到的符號.例如: http://www.codegravity.com/index.php?<u>name</u>= peter&amp;<u>surname</u>=smith. 你也可以使用<u>*</u> 來掃描所有的GET變量. (例如: <b>n*me</b>)");
DEFINE('_EW_DESC_GOALS_GET_CONDITION', "在這裡你必須指定一個匹配前面字段的值. (例如:<b>p?t*r</b>) ");
DEFINE('_EW_DESC_GOALS_POST_VAR', "頗為相似,但我們檢查從表單提​​交的值.因此,當您在您的網站有一個表單,有一個字段&lt;input type='text' name='< u>experiences</u>' /&gt;. (例如: <b> exper * CES </b>)");
DEFINE('_EW_DESC_GOALS_POST_CONDITION', "一個匹配POST字段中的值.例如:我們要檢查用戶是否有Java經驗. (例如: <b>*java*</b>)");
DEFINE('_EW_DESC_GOALS_TITLE_CONDITION', "相匹配的頁面標題. (例如:<b>*freelance programmers*</b>)");
DEFINE('_EW_DESC_GOALS_USERNAME_CONDITION', "一個登錄用戶名. (例如:<b>psmith*</b>)");
DEFINE('_EW_DESC_GOALS_IP_CONDITION', " IP用戶來自: (例如:<b>201.9?.*.*</b>)");
DEFINE('_EW_DESC_GOALS_CAME_FROM_CONDITION', "用戶來自於的URL. (例如:<b>*www.google.*</b>)");
DEFINE('_EW_DESC_GOALS_REDIRECT', "用戶重定向到您指定的URL.有一個比'blocking'更高的優先級: (例如:<b>http://www.codegravity.com/goaway.html</b >)");
DEFINE('_EW_DESC_TRUNCATE_GOALS', "多少個字符將被截斷的目標表");
DEFINE('_EW_DESC_FRONTEND_NO_BACKLINK', "<b>(專業版功能)</b>鏈接至codegravity.com,你可以禁用它,但我們會感激您保留它.謝謝");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES', "在前台模塊顯示國家總的統計.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FIRST', "如果你想交換觀眾/國家在前台的順序.取消選中它,訪客將首先出現.");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NUM', "在前台顯示國家的數量");
DEFINE('_EW_DESC_FRONTEND_VISITORS', "顯示國家的訪客在前台模塊.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ");
DEFINE('_EW_DESC_CACHE_FRONTEND_COUNTRIES', "多久緩存前台獲取的全部國家, 單位為秒");
DEFINE('_EW_DESC_CACHE_FRONTEND_VISITORS', "多久緩存前台獲取的全部訪客, 單位為秒");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TODAY', "顯示在前台的訪客: 今天.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_YESTERDAY', "顯示在前台的訪客: 昨天.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_WEEK', "顯示在前台的訪客: 這個星期.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_WEEK', "顯示在前台的訪客: 上週.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_THIS_MONTH', "顯示在前台的訪客: 這個月.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_LAST_MONTH', "顯示在前台的旅客: 上個月.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL', "顯示自ExtraWatch安裝後的全部訪客.此設置更改後在前台生效的時間由後面變量確定CACHE_FRONTEND_ ...");
DEFINE('_EW_DESC_LANGUAGE', "使用的語言文件.它們被放置在/components/com_extrawatch/lang/.如果你想創建一個全新的語言文件,首先檢查extrawatch 項目的主頁,如果語言文件仍然是不存在的,只要復制默認的english.php 到你要翻譯的語言, 如. german.php 保存在同一個目錄.然後翻譯其中的所有鍵值.");
DEFINE('_EW_DESC_GOALS', "目標允許你指定特殊的參數.當這些參數匹配,目標計數器增加.這樣你就可以監視用戶是否具有訪問某個特定的URL,發布一個特定的值,有一個特定的用戶名或來自一個特定的地址.您還可以阻止或重定向這些用戶到其他一些URL .");
DEFINE('_EW_DESC_GOALS_INSERT', "在除了name以外的所有的字段,你都可以使用*和？作為通配符.例如: ?ear (將匹配: near, tear, ..), p*r (將匹配: pr, peer, pear ..) ");
DEFINE('_EW_DESC_GOALS_BLOCK', "設置為1,如果你想阻擋訪客.除了顯示封鎖消息,他不會看到餘下的內容,沒有任何重定向而且他的IP添加到'阻擋'統計中(例如: <b>1</b>)");

/* new translations */
DEFINE('_EW_GOALS_COUNTRY_CONDITION', "國家條件");
DEFINE('_EW_GOALS_COUNTRY_INVERSED', "國家反演條件");
DEFINE('_EW_DESC_GOALS_COUNTRY_CONDITION', " 2大寫字母的國家代碼(如: <b>TH</b>)");
DEFINE('_EW_STATS_INTERNAL', "內部");
DEFINE('_EW_STATS_FROM', "從");
DEFINE('_EW_STATS_TO', "要");
DEFINE('_EW_STATS_ADD_TO_GOALS', "添加到目標");
DEFINE('_EW_VISITS_ADD_GOAL_COUNTRY', "為這個國家添加目標");
DEFINE('_EW_MENU_REPORT_BUG', "報告錯誤或功能");
DEFINE('_EW_GOALS_COUNTRY', "國家");


/* translations 1.2.8b_12 */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_UPPERCASE', "如果你想在前台讓國家名稱大寫顯示(例如:GERMANY, UNITED KINGDOM 而不是Germany, United Kingdom)");
DEFINE('_EW_DESC_CACHE_FRONTEND_USERS', "多久緩存前台獲取的用戶, 單位為秒");
DEFINE('_EW_DESC_FRONTEND_VISITORS_TOTAL_INITIAL', "在總計中顯示的初始值: 在前台.當你從其他統計工具遷移. (如: 20000).重新設置為0,如果你不想使用此功能.");
DEFINE('_EW_DESC_IGNORE_USER', "忽略在這個文本框中列出的用戶.每行一個. (如: 自己{換行} mark_ *)");
DEFINE('_EW_FRONTEND_USERS_MOST', "今天最活躍的用戶");
DEFINE('_EW_DESC_SPAMWORD_BANS_ENABLED', "啟用基於下面的spamword列表的阻止功能?");
DEFINE('_EW_DESC_SPAMWORD_LIST', "最常見的垃圾郵件,防垃圾郵件程序使用的詞語.您可以使用通配符(如: ph?rmac*).如果上面的設置是啟用的,ExtraWatch將檢查攻擊者是否通過(HTTP POST請求)的形式向你的網站提交垃圾郵件詞彙. (如果表單只加載基於Joomla的網站- 論壇,評論,對於阻止試圖提交各種可能表單垃圾郵件機器人是相當有效的)");
DEFINE('_EW_SETTINGS_ANTI_SPAM', "防垃圾");
DEFINE('_EW_DESC_FRONTEND_USER_LINK', "在前台用戶模塊的鏈接- 允許你指定一個當用戶點擊用戶名時打開的URL,必須包含字符串{user},這將被實際的用戶名代替. (例如: index. php?option=com_comprofiler&task=userProfile&user={user}) ");

/* translations 1.2.11b */
DEFINE('_EW_DESC_HISTORY_MAX_VALUES', "在歷史標籤的最大值(例如: <i>100</i>)");

DEFINE('_EW_DESC_ONLY_LAST_URI', "在訪問列表中只顯示訪問的最後一頁,而不是所有");
DEFINE('_EW_DESC_HIDE_REPETITIVE_TITLE', "在訪問列表中隱藏在訪問頁面標題重複的站點名");
DEFINE('_EW_DESC_HISTORY_MAX_DB_RECORDS', "保存在訪問歷史數據庫中的最大訪客數量.小心使用此設置,如果你有高流量,增長的非常快.請務必檢查狀態中的歷史表包含多少數據");
DEFINE('_EW_DESC_UNINSTALL_KEEP_DATA', "卸載時保留數據庫表.勾選此選項,如果你正在做升級之前卸載,並希望保持您的數據.");

/* email reports */
DEFINE('_EW_DESC_EMAIL_REPORTS_ENABLED', "您將夜間在收到前一天報告的電子郵件,方便你在早上閱讀");
DEFINE('_EW_DESC_EMAIL_REPORTS_ADDRESS', "您將收到這些報告的電子郵件地址");
DEFINE('_EW_DESC_EMAIL_PERCENT_HIGHER_THAN', "在電子郵件報告只包括比例值比{value} 高的行.設置為0,如果你不想使用此功能<i>(例如: 5)</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_POSITIVE', "在電子郵件報告只包括變化值高於{value} ％的<b>1天正值</b>.設置為0,如果你不想使用此功能<i>(例如: 5 )</i>");
DEFINE('_EW_DESC_EMAIL_ONE_DAY_CHANGE_NEGATIVE', "在電子郵件報告只包括變化值低於{value} ％的<b>1天負值</b>.設置為0,如果你不想使用此功能<i>(例如: -10)</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_POSITIVE', "在電子郵件報告只包括變化值高於{value} ％的<b>7天正值</b>.設置為0,如果你不想使用此功能<i>(例如: 2 )</i>");
DEFINE('_EW_DESC_EMAIL_SEVEN_DAY_CHANGE_NEGATIVE', "在電子郵件報告只包括變化值低於{value} ％的<b>7天負值</b>.設置為0,如果你不想使用此功能<i>(例如: -13)</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_POSITIVE', "在電子郵件報告只包括變化值高於{value} ％的<b>28天正值</b>.設置為0,如果你不想使用此功能<i>(例如: 2 )</i>");
DEFINE('_EW_DESC_EMAIL_TWENTY_EIGHT_DAY_CHANGE_NEGATIVE', "在電子郵件報告只包括變化值低於{value} ％的<b>28天負值</b>.設置為0,如果你不想使用此功能<i>(例如: -13)</i>");

DEFINE('_EW_DESC_FRONTEND_NOFOLLOW', "<b>(專業版功能)</b>啟用此設置,如果你想標誌鏈接中包含屬性rel='nofollow' ");
DEFINE('_EW_DESC_EMAIL_NAME_TRUNCATE', "電子郵件列名的最大字符數.更改此值,如果您的email客戶端的消息窗口太小");

DEFINE('_EW_MENU_HISTORY', "歷史");
DEFINE('_EW_MENU_EMAILS', "電子郵件");
DEFINE('_EW_MENU_STATUS', " DB狀態");
DEFINE('_EW_DESC_BLOCKED', "這些IP阻止被防垃圾郵件功能");


DEFINE('_EW_HISTORY_VISITORS', "訪客歷史");
DEFINE('_EW_HISTORY_SHOWING_ONLY', "顯示只有%d 的最後一個記錄.
                要更改此值,去設置-&gt; 歷史與性能-&gt; HISTORY_MAX_DB_RECORDS.要小心,此設置會影響下面的數據加載時間. ");
DEFINE('_EW_MENU_BUG', "報告錯誤");
DEFINE('_EW_MENU_FEATURE', "請求功能");

DEFINE('_EW_VISITS_CAME_FROM_KEYWORDS', "關鍵詞");

DEFINE('_EW_BLOCKING_UNBLOCK', "疏通");
DEFINE('_EW_STATS_KEYPHRASE', "關鍵詞短語");

DEFINE('_EW_STATUS_DATABASE_TABLE_NAME', "表的名稱");
DEFINE('_EW_STATUS_DATABASE_ROWS', "行");
DEFINE('_EW_STATUS_DATABASE_DATA', "數據");
DEFINE('_EW_STATUS_DATABASE_TOTAL', "總");

DEFINE('_EW_EMAIL_REPORTS', "電子郵件報告");
DEFINE('_EW_EMAIL_REPORT_GENERATED', "生成從昨天起的電子郵件過濾報告");
DEFINE('_EW_EMAIL_REPORTS_VALUE_FILTERS', "電子郵件值過濾");
DEFINE('_EW_EMAIL_REPORTS_VALUE', "值");
DEFINE('_EW_EMAIL_REPORTS_PERCENT', "％");
DEFINE('_EW_EMAIL_REPORTS_1DAY_CHANGE', " 1天的變化");
DEFINE('_EW_EMAIL_REPORTS_7DAY_CHANGE', " 7天的變化");
DEFINE('_EW_EMAIL_REPORTS_28DAY_CHANGE', " 28天的變化");
DEFINE('_EW_ANTISPAM_BLOCKED', "ExtraWatch今天阻止了%d 的垃圾郵件發送者的點擊,總記: %d");
DEFINE('_EW_ANTISPAM_ADDRESSES', "封鎖的IP 地址");
DEFINE('_EW_ANTISPAM_SETTINGS', "反垃圾郵件設置");
DEFINE('_EW_TRAFFIC_AJAX', " AJAX更新交通(地圖除外)");


DEFINE('_EW_HISTORY_PREVIOUS', "以前");
DEFINE('_EW_HISTORY_NEXT', "未來");

/** additional translation for 1.2.11 for countries in more rows */
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_COLUMNS', "國家的列數");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_MAX_ROWS', "國家的行數");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_NAMES', "是否顯示國名");
DEFINE('_EW_DESC_FRONTEND_COUNTRIES_FLAGS_FIRST', "首先顯示標誌,然後再百分比");

/* ExtraWatch 1.2.14 translations */

DEFINE('_EW_GOALS_GET_INVERSED', "反演條件");
DEFINE('_EW_GOALS_POST_INVERSED', "發表反演條件");
DEFINE('_EW_GOALS_TITLE_INVERSED', "標題反演條件");
DEFINE('_EW_GOALS_USERNAME_INVERSED', "用戶名反演條件");
DEFINE('_EW_GOALS_CAME_FROM_INVERSED', "來自反演條件");

DEFINE('_EW_STATS_MAP', "上次訪問地圖");
DEFINE('_EW_STATS_MAP_ENTER_KEY', "請輸入<a href='http://www.ipinfodb.com/register.php' target='_blank'> ipinfodb.com </ A>鍵以顯示上次訪問地圖:");
DEFINE('_EW_STATS_MAP_STORE_KEY', "存儲的關鍵");
DEFINE('_EW_STATS_MAP_INVALID_KEY', "請輸入您是從有效ipinfodb關鍵碼: <a href='http://www.ipinfodb.com/register.php' target='_blank'> ipinfodb.com </ A >");

DEFINE('_EW_SIZEQUERY_BAD_REQUEST', "錯誤的請求: ");

DEFINE('_EW_VISIT_SUBMITED_FIELDS', "提交表單字段:");
DEFINE('_EW_VISIT_URL_PARAMETERS', " URL參數:");
DEFINE('_EW_VISIT_ADD_PAGE', "添加頁面作為目標");
DEFINE('_EW_VISIT_BLOCK_IP', "封鎖此IP地址");
DEFINE('_EW_VISIT_SUBMITED_FROM_VARIABLE', "添加的表單變量作為目標");
DEFINE('_EW_VISIT_URL_PARAMETER_GOAL', "將此的URL參數作為目標");

DEFINE('_EW_TREND_EMPTY', "空");

DEFINE('_EW_NOT_NUMBER', "警告: 您輸入的值不是一個數字. ExtraWatch不會正確工作!");
DEFINE('_EW_EVALUATION_LEFT', "這是15天評估版本.還剩下: <b>%d</b>.請購買終身<a href='http://www.codegravity.com/donate/extrawatch/ ' target='_blank'> ExtraWatch 許可證,為您的域</a> 當前和後續的版本.");
DEFINE('_EW_TRIAL_VERSION_EXPIRED', "你的試用版已過期.請購買ExtraWatch ");

DEFINE('_EW_CONFIG_LICENSE_ACTIVATED', "許可證激活成功.謝謝您");
DEFINE('_EW_CONFIG_LICENCE_DONT_MATCH', "<b>錯誤的許可證密鑰,您的域名不匹配: </b> <br/>你輸入的域名是否和你捐贈時填寫的相同,如下? <br/>點擊“<b>請求正確的激活密鑰</b>”下面,或聯繫: info@codegravity.com <br/> ");

DEFINE('_EW_VIEW_ADMINBODY_LONG_MESSAGE', "如果您一直看到上面消息,您的實際網站設置可能是錯誤的的.
                    打開comp​​onents/com_extrawatch/config.php 文件
                    註釋,並設置您的實際網站.例如:
                    define('EXTRAWATCH_LIVE_SITE', 'http://www.codegravity.com');");

DEFINE('_EW_ADMINBODY_LIVE_SITE', "警告: 在您的瀏覽器中的網站的配置中的實際網站: %s and %s 不匹配.");
DEFINE('_EW_ADMINBODY_SET_LIVE_SITE', "到設置實際網站: %s 並繼續...");

DEFINE('_EW_ADMINHEADER_JW', "ExtraWatch ");
DEFINE('_EW_ADMINHEADER_REMOVE_BACKLINK', "刪除鏈接");
DEFINE('_EW_ADMINHEADER_KNOWLEDGE_BASE', "知識庫");
DEFINE('_EW_ADMINHEADER_FLOW', "流量");
DEFINE('_EW_ADMINHEADER_GRAPHS', "圖");
DEFINE('_EW_ADMINHEADER_COMPONENTS', "組件");
DEFINE('_EW_ADMINHEADER_REVIEW', "審查");
DEFINE('_EW_ADMINHEADER_WRITE', "寫");

DEFINE('_EW_FLOW_TRAFFIC', "交通流");
DEFINE('_EW_FLOW_SELECT_PAGE', "選擇頁面:");
DEFINE('_EW_FLOW_OUTG_LINKS', "根外向鏈接數:");
DEFINE('_EW_FLOW_NESTING', "嵌套級別:");
DEFINE('_EW_FLOW_SCALE', "規模:");

DEFINE('_EW_COMERCIAL_AD_FREE', "帶廣告的免費版本");
DEFINE('_EW_COMERCIAL_THANK_DONATION', "非常感謝您的捐贈!​​");
DEFINE('_EW_COMERCIAL_REGISTRATION_KEY', "您的域%s 的註冊碼是: ");
DEFINE('_EW_COMERCIAL_BACKLINKS_REMOVE', "現在你可以刪除鏈接或隱藏在前台的ExtraWatch標誌");


DEFINE('_EW_SIZES_LAST_CHECK', "最後一次檢查是在:");
DEFINE('_EW_SIZES_ADMINISTRATOR', "藍色= 在/administrator 文件夾中component/module 的尺寸");

DEFINE('_EW_SIZECOMPONENTS_COMPONENT', "組件");
DEFINE('_EW_SIZECOMPONENTS_TOTAL', "總計:");
DEFINE('_EW_SIZECOMPONENTS_SIZE', "大小");
DEFINE('_EW_SIZECOMPONENTS_REFRESH_ALL', "刷新所有");

DEFINE('_EW_SIZEDATABASE_TABLE', "表");
DEFINE('_EW_SIZEDATABASE_SIZE', "大小");
DEFINE('_EW_SIZEDATABASE_1DAY', " 1天的變化");
DEFINE('_EW_SIZEDATABASE_7DAY', " 7天的變化");
DEFINE('_EW_SIZEDATABASE_28DAY', " 28天的變化");
DEFINE('_EW_SIZEDATABASE_NO_DATA', "沒有數據");
DEFINE('_EW_SIZEDATABASE_TOTAL', "共有:");

DEFINE('_EW_SIZEMODULES_REFRESH_ALL', "刷新所有");
DEFINE('_EW_SIZEMODULES_TOTAL', "共有:");
DEFINE('_EW_SIZEMODULES_MODULE', "模塊");
DEFINE('_EW_SIZEMODULES_SIZE', "大小");

DEFINE('_EW_SIZES_FILES', "文件和目錄");
DEFINE('_EW_SIZES_BYTES', "字節");
DEFINE('_EW_SIZES_KB', "KB");
DEFINE('_EW_SIZES_MB', "MB");
DEFINE('_EW_SIZES_GB', "GB");
DEFINE('_EW_SIZES_REFRESH', "刷新");

DEFINE('_EW_STATS_FOOTER', "ExtraWatch &copy;2006-@YEAR@ by CodeGravity.com");

DEFINE('_EW_STATUS_MB', "MB");
DEFINE('_EW_STATUS_DATABASE', "數據庫表的大小");


DEFINE('_EW_DESC_IPINFODB_KEY', "最後訪問地圖ipinfodb.com鍵: <a href='http://www.ipinfodb.com/register.php' target='_blank'>ipinfodb.com</a>");
DEFINE('_EW_SETTINGS_FORCE_TIMEZONE_OFFSET', "強制時區偏移");


/* ExtraWatch 1.2.17 translations */
DEFINE('_EW_MENU_UPDATE', "更新");
DEFINE('_EW_MENU_UPDATE_TITLE', "備份和升級");
DEFINE('_EW_ADMINHEADER_NA_IN_THIS_VERSION', "在免費版本里不可用,請檢查許可證選項卡");
DEFINE('_EW_SPAMWORD_BANS_ENABLED', "垃圾單詞班啟用");
DEFINE('_EW_SPAMWORD_LIST', "垃圾單詞列表");
DEFINE('_EW_HIDE_REPETITIVE_TITLE', "隱藏重複的標題");
DEFINE('_EW_TRUNCATE_VISITS', "截斷訪問");
DEFINE('_EW_TRUNCATE_STATS', "截斷統計");
DEFINE('_EW_TRUNCATE_GOALS', "截斷目標");
DEFINE('_EW_LIMIT_BOTS', "限制機器人");
DEFINE('_EW_LIMIT_VISITORS', "限制訪客");
DEFINE('_EW_TOOLTIP_WIDTH', "幫助提示寬度");
DEFINE('_EW_TOOLTIP_HEIGHT', "說明文字高度");
DEFINE('_EW_TOOLTIP_URL', "幫助提示的網址");
DEFINE('_EW_TOOLTIP_ONCLICK', "幫助提示OnClick ");
DEFINE('_EW_IP_STATS', " IP統計");
DEFINE('_EW_IPINFODB_KEY', " IP信息數據庫的關鍵字");
DEFINE('_EW_ONLY_LAST_URI', "只有最後的URI ");

DEFINE('_EW_FRONTEND_HIDE_LOGO', "前台隱藏標誌");
DEFINE('_EW_FRONTEND_NOFOLLOW', "前台沒有後續");
DEFINE('_EW_FRONTEND_NO_BACKLINK', "前台沒有返回鏈接");
DEFINE('_EW_FRONTEND_USER_LINK', "前台用戶鏈接");
DEFINE('_EW_FRONTEND_COUNTRIES_FIRST', "前台的國家第一");
DEFINE('_EW_FRONTEND_COUNTRIES_NAMES', "前台的國家名稱");
DEFINE('_EW_FRONTEND_COUNTRIES_UPPERCASE', "前台國家的大寫");
DEFINE('_EW_FRONTEND_COUNTRIES_FLAGS_FIRST', "前台各國國旗第一");
DEFINE('_EW_FRONTEND_COUNTRIES_NUM', "前台的國家數量");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_COLUMNS', "前台國家的最大列數");
DEFINE('_EW_FRONTEND_COUNTRIES_MAX_ROWS', "前台國家的最大行數");
DEFINE('_EW_FRONTEND_VISITORS_TODAY', "今天前台訪客");
DEFINE('_EW_FRONTEND_VISITORS_YESTERDAY', "昨天前台訪客");
DEFINE('_EW_FRONTEND_VISITORS_THIS_WEEK', "本週前台訪客");
DEFINE('_EW_FRONTEND_VISITORS_LAST_WEEK', "上週前台訪客");

DEFINE('_EW_FRONTEND_VISITORS_THIS_MONTH', "本月前台訪客");
DEFINE('_EW_FRONTEND_VISITORS_LAST_MONTH', "上個月前台訪客");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL', "前台隱藏訪客總記");
DEFINE('_EW_FRONTEND_VISITORS_TOTAL_INITIAL', "前台總計初步");
DEFINE('_EW_HISTORY_MAX_VALUES', "歷史最高值");
DEFINE('_EW_HISTORY_MAX_DB_RECORDS', "歷史最高記錄");
DEFINE('_EW_UPDATE_TIME_VISITS', "更新時間訪問");
DEFINE('_EW_UPDATE_TIME_STATS', "更新時間統計");
DEFINE('_EW_STATS_MAX_ROWS', "統計最大行");
DEFINE('_EW_STATS_IP_HITS', "統計的IP點擊");
DEFINE('_EW_MAXID_BOTS', "最大ID機器人");
DEFINE('_EW_MAXID_VISITORS', " 最大ID訪客");
DEFINE('_EW_STATS_KEEP_DAYS', "統計保持天數");
DEFINE('_EW_CACHE_FRONTEND_COUNTRIES', "緩存前台國家");
DEFINE('_EW_CACHE_FRONTEND_VISITORS', "緩存前台訪客");

DEFINE('_EW_UNINSTALL_KEEP_DATA', "卸載保持數據");
DEFINE('_EW_IGNORE_IP', "忽略IP ");
DEFINE('_EW_IGNORE_URI', "忽略URI ");
DEFINE('_EW_IGNORE_USER', "忽略用戶");
DEFINE('_EW_BLOCKING_MESSAGE', "非阻塞消息");
DEFINE('_EW_SERVER_URI_KEY', "服務器URI關鍵碼");
DEFINE('_EW_SIZEDATABASE_RECORDS', "記錄");
/***********EDITs*****************/
DEFINE('_EW_ANTISPAM_BLOCKING_TEXT', "為了使阻塞有效,你需要把ExtraWatch代理髮佈在任何內容和表單之前.例如:在您的模板的左側.
                    <br/>
                    進入模塊管理- >ExtraWatch代理- >選擇位置左");

DEFINE('_EW_EMAIL_SEO_REPORTS', " SEO報告");
DEFINE('_EW_DESC_EMAIL_SEO_REPORTS_ENABLED', " SEO每晚電子郵件報告啟用");
DEFINE('_EW_WATCH_INSTALLATION_DEMO', "觀看安裝演示");

/** JW 1.2.18 */
DEFINE('_EW_ADMINHEADER_HEATMAP', "Heatmap");
DEFINE('_EW_HEATMAP_CLICKS', "clicks");
DEFINE('_EW_HEATMAP_TITLE', "title");
DEFINE('_EW_HEATMAP_CLICK_OPEN', "Click to open heatmap");
DEFINE('_EW_NO_DATA', "This section contains no data yet ...");
DEFINE('_EW_POSITION', "Search result num.");
DEFINE('_EW_BLOCKING_REASON', 'reason');
DEFINE('_EW_BLOCKING_UNAUTHORIZED_ACCESS', 'Unauthorized Access');
DEFINE('_EW_BLOCKING_BLOCKED_MANUALLY', 'Blocked manually');
DEFINE('_EW_BLOCKING_BAD_WORD', "bad word");
DEFINE('_EW_HEATMAP_OF', "of");
DEFINE('_EW_URI', "uri");
DEFINE('_EW_COUNT', "count");
DEFINE('_EW_SEO_REPORT_FOR', "SEO report for");
DEFINE('_EW_SEO_MOST_DYNAMIC_KEYPHRASES', "Most dynamic keyphrases");
DEFINE('_EW_SEO_MIN_POSITION', "min position");
DEFINE('_EW_SEO_AVG_POSITION', "average position");
DEFINE('_EW_SEO_MAX_POSITION', "max position");
DEFINE('_EW_SEO_CHANGE', "change");
DEFINE('_EW_SEO_DATE_OF_LAST_CHANGE', "date of last change");
DEFINE('_EW_SEO_TOTAL_VISITS_FROM_SEARCH_ENGINES', "Total visits by keyphrase from search engines");
DEFINE('_EW_GOAL_ADD_SUBMITTED_VALUE', "Add submitted variable as goal");
DEFINE('_EW_RENDERED_IN', "Rendered in");
DEFINE('_EW_DESC_SEO_RENDER_ONLY_CHANGED', "Render only values which were already used in previous days (have some percentage in change column)");
DEFINE('_EW_SEO_REPORT_SETTINGS', "SEO Report Settings");


DEFINE('_EW_HTTP500_ERROR', "Could not initialize ExtraWatch javascript functions! Browser could not load: \\n%s, because it returned HTTP 500 internal server error.  \\nThis usually of security restrictions by other components/plugins. Please check your .htaccess file in your root Joomla directory.  \\nIf you use Akeeba Admin tools, you need to go \ 'Akeeba htaccess maker\ ' -> \ 'Server Protection\ ' -> \ 'Exceptions\ ' -> \ 'Allow direct access to these files\ ', and add: \\n/components/com_joomlawatch/block.php \\n/components/com_joomlawatch/img.php \\n/components/com_joomlawatch/last.php \\n/components/com_joomlawatch/lastvisit.php \\n/components/com_joomlawatch/sizequery.php \\n/components/com_joomlawatch/sizequerytotal.php \\n/components/com_joomlawatch/stats.php \\n/components/com_joomlawatch/timezone.php \\n/components/com_joomlawatch/tooltip.php \\n/components/com_joomlawatch/trendtooltip.php \\n/components/com_joomlawatch/vars.php \\n/components/com_joomlawatch/visits.php \\n/components/com_joomlawatch/js/joomlawatch.js.php \\n/components/com_joomlawatch/js/maps.js.php ");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_JOOMLA',"Warning: No visits are currently being recorded. Your ExtraWatch Agent module is published, but most probably in position which does not exist in your template.
                <br/><br/>
                To fix this: <br/>
                1. go to Modules section -&gt; ExtraWatch Agent <br/>
                2. change the Position to 'left' or 'footer' (or some other position).<br/>
                3. check if new visits are being recorded
                <br/><br/>
                If this won't help, you can also: <br/>
                1. set 'Show Title' to 'Yes' in  Modules section -&gt; ExtraWatch Agent <br/>
                2. try to use some other positions of ExtraWatch agent module<br/>
                3. save<br/>
                4. after reload of your main page look for 'ExtraWatch Agent' text.<br/>
                5. this way you'll make sure the Agent module is published.<br/>
                6. after that you can set 'Show Title' back to 'No'.
                ");

/** Goals/Import IP */
DEFINE('_EW_GOALS', "Goals");
DEFINE('_EW_GOALS_IMPORT', "Import goals");
DEFINE('_EW_GOALS_IMPORT_XML', "Import XML");
DEFINE('_EW_GOALS_EXPORT', "Export goals");
DEFINE('_EW_GOALS_FILENAME', "Select goals previously exported as XML");
DEFINE('_EW_ANTISPAM_IMPORT_CSV', "import anti-spam ip csv");

DEFINE('_EW_AGENT_NOT_PUBLISHED_ERROR_WORDPRESS',"Warning: No visits are being recorded. You must go to Appearance->Widgets section, <br/>find ExtraWatchAgent widget and drag&drop it to some of the containers on the right side. <br/>You can publish also other ExtraWatch modules this way.");
