<?php

/*
 * @version		$Id: utils.php 1.2.3 01-10-2015 $
 * @package		Yendif Video Share
 * @copyright   Copyright (C) 2014-2016 Yendif Technologies PVT Ltd
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class YendifVideoShareUtils  {
	
	public static function hasPermission( $access = 1, $viewLevels = '' ) {
		if($access == '') return true;
		
		if( $viewLevels == '' ) {
			$user = JFactory::getUser();	
			$viewLevels = $user->getAuthorisedViewLevels();
		}
		
		return in_array( $access, $viewLevels ) ? true : false;
	}
	
	public static function addSubMenu( $view ) {
		$views = array(
			'dashboard'  => false,
			'categories' => false,
			'videos'     => false, 
			'approval'   => false,
			//'adverts'    => false,
			'ratings'    => false,
			//'import'     => false,
			'config'     => false
		);
		$view = JRequest::getCmd('view', 'dashboard');
		$views[ $view ] = true;		
		
		JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_CONTROL_PANEL'), 'index.php?option=com_yendifvideoshare', $views['dashboard'] );
		JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_CATEGORIES'), 'index.php?option=com_yendifvideoshare&view=categories', $views['categories'] );	
		JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_VIDEOS'), 'index.php?option=com_yendifvideoshare&view=videos', $views['videos'] );
		JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_APPROVAL_QUEUE'), 'index.php?option=com_yendifvideoshare&view=approval', $views['approval'] );
		//JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_ADVERTISEMENTS'), 'index.php?option=com_yendifvideoshare&view=adverts', $views['adverts'] );	
		JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_RATINGS'), 'index.php?option=com_yendifvideoshare&view=ratings', $views['ratings'] );
		//JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_QUICK_IMPORT_YOUTUBE_VIDEOS'), 'index.php?option=com_yendifvideoshare&view=import', $views['import'] );	
		JSubMenuHelper::addEntry( JText::_('YENDIF_VIDEO_SHARE_GLOBAL_CONFIGURATION'), 'index.php?option=com_yendifvideoshare&view=config', $views['config'] );	
	}
	
	public static function getToken() {	
		return JSession::getFormToken();
	}
	
	public static function safeString( $value = '' ) {
		$value = JString::trim( $value );
		return htmlspecialchars( $value );
	}
	
	public static function Truncate( $text, $length = 150 ) {
		$text = strip_tags( $text );
		
    	if( $length > 0 && JString::strlen( $text ) > $length ) {
        	$tmp = JString::substr( $text, 0, $length );
            $tmp = JString::substr( $tmp, 0, JString::strrpos( $tmp, ' ' ) );

            if( JString::strlen( $tmp ) >= $length - 3 ) {
            	$tmp = JString::substr( $tmp, 0, JString::strrpos( $tmp, ' ' ) );
            }
 
            $text = $tmp.'...';
        }
 
        return $text;
	}
	
	public static function getUsers() {
		$db = JFactory::getDBO();
		$query = 'SELECT id,username FROM #__users';
		$db->setQuery( $query );
		$items = $db->loadObjectList();
		 
        return $items;
	}
	
	public static function getColumn( $table, $column, $id ) {
		$db = JFactory::getDBO();
        $query = "SELECT ".$column." FROM #__yendifvideoshare_".$table." WHERE id=".$id;
		$db->setQuery($query);
		$item = $db->loadResult();
		
        return $item;
	}
	
	public static function getConfig() {
         $db = JFactory::getDBO();
         $query = "SELECT * FROM #__yendifvideoshare_config";
         $db->setQuery( $query );
         $item = $db->loadObject();
		 
         return $item;
	}
	
	public static function getVideoInsertId() {
		jimport('joomla.filesystem.folder');	
		
		$db = JFactory::getDBO();
		$user_id = JFactory::getUser()->get('id');
		$insert_id = 0;		
		
        $query = "SELECT id FROM #__yendifvideoshare_videos WHERE title='' AND userid=$user_id ORDER BY id DESC";
		$db->setQuery($query);
		$items = $db->loadObjectList();
		
		foreach( $items as $key => $item ) {
			if( 0 == $key && $item->id > 0 ) {
				$insert_id = $item->id;
			} else {
				$query = "DELETE FROM #__yendifvideoshare_videos WHERE id=".$item->id;
            	$db->setQuery( $query );
            	$db->query();
			}	
			$del_dir = YENDIF_VIDEO_SHARE_UPLOAD_BASE.'videos'.DS.$item->id.DS;
			if( JFolder::exists( $del_dir) ) JFolder::delete( $del_dir );
		}
		
		if( 0 == $insert_id ) {
			$row = new JObject();
   			$row->id = NULL;
   			$row->userid = $user_id;
   			$row->title = '';
   			$db->insertObject( '#__yendifvideoshare_videos', $row );
			
			$insert_id = $db->insertid();			
		}
		
        return $insert_id;
	}
	
	public static function getAdvertInsertId() {
		jimport('joomla.filesystem.folder');	
		
		$db = JFactory::getDBO();
		$insert_id = 0;		
		
        $query = "SELECT id FROM #__yendifvideoshare_adverts WHERE title='' ORDER BY id DESC";
		$db->setQuery($query);
		$items = $db->loadObjectList();
		
		foreach( $items as $key => $item ) {
			if( 0 == $key && $item->id > 0 ) {
				$insert_id = $item->id;
			} else {
				$query = "DELETE FROM #__yendifvideoshare_adverts WHERE id=".$item->id;
            	$db->setQuery( $query );
            	$db->query();
			}	
			$del_dir = YENDIF_VIDEO_SHARE_UPLOAD_BASE.'videos'.DS.$item->id.DS;
			if( JFolder::exists( $del_dir) ) JFolder::delete( $del_dir );
		}
		
		if( 0 == $insert_id ) {
			$row = new JObject();
   			$row->id = NULL;
   			$row->title = '';
   			$db->insertObject( '#__yendifvideoshare_adverts', $row );
			
			$insert_id = $db->insertid();			
		}
		
        return $insert_id;
	}
	
	public static function getCategoryTree( $ids ) {		
		$db = JFactory::getDBO();			
		$ids = (array) $ids;
		JArrayHelper::toInteger( $ids );
		$catid  = array_unique( $ids );
		sort($ids);
		
		$array = $ids;				
		while( count( $array ) ) {
			$query = "SELECT id FROM #__yendifvideoshare_categories 
					WHERE parent IN (".implode(',', $array).") 
					AND id NOT IN (".implode(',', $array).") ";
			$db->setQuery($query);
			$array = $db->loadColumn();
			$ids = array_merge( $ids, $array );
		}
		JArrayHelper::toInteger( $ids );
		$ids = array_unique( $ids );
					
		return $ids;
	}
	
	public static function getMediaCount( $id ) {		
		$db = JFactory::getDBO();
		$publish = self::getConfig();			
		$nullDate = $db->quote($db->getNullDate());
		$date = JFactory::getDate();
		$nowDate = $db->quote($date->toSql());
		
		$query = "SELECT COUNT(id) FROM #__yendifvideoshare_videos WHERE published=1";
		if( $publish->schedule_video_publishing ) {
			$query .= " AND ( published_up = " . $nullDate . " OR published_up <= " . $nowDate .' )';
			$query .= " AND ( published_down = " . $nullDate . " OR published_down >= " . $nowDate .' )';
		}				
		$query .= " AND  catid IN(".implode( ',', self::getCategoryTree( $id ) ).")";
		$db->setQuery( $query );
		$count = $db->loadResult();			
		
		return $count;	
	}
	
	public static function getSubCategoryMediaCount( $id, $check_publishing_options ) {
		$db = JFactory::getDBO();

		$query = "SELECT COUNT(id) FROM #__yendifvideoshare_videos WHERE published=1";
		
		if( $check_publishing_options ) {
			$date = JFactory::getDate();
			
			$nullDate = $db->quote( $db->getNullDate() );
			$nowDate  = $db->quote( $date->toSql() );
		
			$query .= " AND ( published_up = " . $nullDate . " OR published_up <= " . $nowDate .' )';
			$query .= " AND ( published_down = " . $nullDate . " OR published_down >= " . $nowDate .' )';
		}				
		
		$query .= " AND catid IN(".$id.")";
		$db->setQuery( $query );
		$count = $db->loadResult();			
		
		return $count;	
	}
	
	public static function getImage( $file, $sfx, $default ) {
		if( empty( $file ) ) {
			return $default;
		}
		
		$pos = strpos( $file, 'media/yendifvideoshare/' );		
		if( $pos !== false ) {
			$ext = '.'.substr( $file, strrpos( $file, "." ) + 1 );
			$optFile = str_replace( $ext, $sfx.$ext, $file );		
			$relPath = explode( 'media', $optFile );
			$extracted = JPATH_ROOT.DS.'media'.str_replace('/', DS, $relPath[1]);
			
			return file_exists( $extracted ) ? $optFile : $file;
		} else {
			return $file;
		}		
	}
	
	public static function RatingWidget( $rating = 0, $id, $total_users ) {		
		$html  = '<div class="yendif-ratings">';
		$html .= '<span class="yendif-ratings-stars">';
		$html .= '<span class="yendif-current-ratings" style="width:'.$rating.'%;"></span>';
		
		$j = 0.5;
		for( $i = 0; $i < 10; $i++ ) {
			$j += 0.5;
			$html .= '<span class="yendif-ratings-star">';
			$html .= '<a class="yendif-rating-trigger yendif-star-'.($j * 10).'" title="'.JText::sprintf('YENDIF_VIDEO_SHARE_RATING_TITLE', $j, 5).'" data-id="'.$id.'" data-value="'.$j.'">1</a>';
			$html .= '</span>';
		}
		
		$html .= '</span>';
		$html .= '<span class="yendif-ratings-info">'.JText::sprintf('YENDIF_VIDEO_SHARE_RATING_INFO', ($rating * 5 ) / 100, $total_users).'</span>';
		$html .= '</div>';
		
		return $html;
	}
	
	public static function showRating( $rating = 0 ) {
		$html  = '<div class="yendif-ratings-small">';
		$html .= '<span class="yendif-ratings-stars"><span class="yendif-current-ratings" style="width:'.$rating.'%;"></span></span>';
		$html .= '</div>';
		
		return $html;
	}	
	
	public static function VotingWidget( $id, $allow_guest_like ) {	
		$status = self::getLikeDislikeStatus( $id, $allow_guest_like );
		
		$like_class_suffix = $dislike_class_suffix = '';
		if( ! empty( $status ) ) {
			if( $status->likes > 0 ) $like_class_suffix = ' active';
			if( $status->dislikes > 0 ) $dislike_class_suffix = ' active';	
		}
	
		$html  = '<div class="yendif-likes-dislikes">';
        $html .= '<span class="yendif-like-btn" data-id="'.$id.'" data-like="1" data-dislike="0">';
        $html .= '<span class="yendif-like-icon'.$like_class_suffix.'"></span>';
        $html .= '<span class="yendif-like-dislike-divider"></span>';
        $html .= '<span class="yendif-like-count">'.self::getLikes( $id ).'</span>';              
        $html .= '</span>';
        $html .= '<span class="yendif-dislike-btn" data-id="'.$id.'" data-like="0" data-dislike="1">';
        $html .= '<span class="yendif-dislike-icon'.$dislike_class_suffix.'"></span>';
        $html .= '<span class="yendif-like-dislike-divider"></span>';
        $html .= '<span class="yendif-dislike-count">'.self::getDislikes( $id ).'</span>';          
      	$html .= '</span>';
        $html .= '</div>';
		
		return $html;		
	}
	
	public static function getLikes( $id ) {		
		$db = JFactory::getDBO();
		$query = "SELECT COUNT(id) FROM #__yendifvideoshare_likes_dislikes WHERE videoid = ".$id." AND likes=1";
		$db->setQuery( $query );
		
		return $db->loadResult();		
	}
	
	public static function getDislikes( $id ) {		
		$db = JFactory::getDBO();
		$query = "SELECT COUNT(id) FROM #__yendifvideoshare_likes_dislikes WHERE videoid = ".$id." AND dislikes=1";
		$db->setQuery( $query );
		
		return $db->loadResult();		
	}		
	
	public static function getLikeDislikeStatus( $id, $allow_guest_like ) {
		$session = JFactory::getSession();	
		$db = JFactory::getDBO();
				
		$userid    = JFactory::getUser()->get('id');
		$sessionid = $session->getId();	

		$query  = "SELECT likes, dislikes FROM #__yendifvideoshare_likes_dislikes WHERE videoid = ".$id;
		$query .= $allow_guest_like == 1 ? " AND sessionid=".$db->quote( $sessionid ) : " AND userid=".$userid;
		$db->setQuery( $query );
		
		return $db->loadObject();			
	}	
}