# JSN Template Solution
# http://joomlashine.com/
#
# Copyright (c) 2012 JoomlaShine.com. All rights reserved.
#
# Database: testsite
# Database Server: localhost
#
# Backup Date: October 18, 2012, 6:42 am


DROP TABLE IF EXISTS `np846_menu_types`;
CREATE TABLE `np846_menu_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_menutype` (`menutype`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `np846_menu_types` (`id`, `menutype`, `title`, `description`) VALUES ('1', 'mainmenu', 'Main Menu', 'The main menu for the site');
INSERT INTO `np846_menu_types` (`id`, `menutype`, `title`, `description`) VALUES ('2', 'topmenu', 'Top Menu', '');
INSERT INTO `np846_menu_types` (`id`, `menutype`, `title`, `description`) VALUES ('3', 'mustsee', 'Must-see Stuff', '');
INSERT INTO `np846_menu_types` (`id`, `menutype`, `title`, `description`) VALUES ('4', 'footermenu', 'Footer Menu', '');
INSERT INTO `np846_menu_types` (`id`, `menutype`, `title`, `description`) VALUES ('5', 'advanced-stuff', 'Advanced Stuff', '');

DROP TABLE IF EXISTS `np846_menu`;
CREATE TABLE `np846_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `ordering` int(11) NOT NULL DEFAULT '0' COMMENT 'The relative ordering of the menu item in the tree.',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`,`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_path` (`path`(255)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8;

INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '', '', '', '', '', '0000-00-00 00:00:00', '', '', '', '', '', '', '125', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('101', 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"featured_categories\":[\"\"],\"layout_type\":\"blog\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"1\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"use_article\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"1\",\"show_vote\":\"0\",\"show_readmore\":\"\",\"show_readmore_title\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"\",\"show_noauth\":\"0\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"Start here...\",\"menu-anchor_css\":\"icon-home\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '43', '44', '1', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('172', 'advanced-stuff', 'Easy to Start', 'easy-to-start', '', 'easy-to-start', 'index.php?option=com_content&view=article&id=5', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '45', '46', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('173', 'advanced-stuff', 'Painless Configuration', 'painless-configuration', '', 'painless-configuration', 'index.php?option=com_content&view=article&id=39', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '47', '48', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('174', 'advanced-stuff', 'RTL Support', 'rtl-support', '', 'rtl-support', 'index.php?option=com_content&view=article&id=41', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '49', '50', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('175', 'advanced-stuff', 'Flash Gallery', 'flash-gallery', '', 'flash-gallery', 'index.php?option=com_content&view=article&id=8', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '51', '52', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('176', 'advanced-stuff', 'Docs / Support', 'docs-a-support', '', 'docs-a-support', 'index.php?option=com_content&view=article&id=3', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '53', '54', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('177', 'advanced-stuff', 'Multilingual Support', 'multilingual-support', '', 'multilingual-support', 'index.php?option=com_content&view=article&id=32', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '55', '56', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('178', 'footermenu', 'JoomlaShine', 'joomlashine', '', 'joomlashine', 'http://www.joomlashine.com', 'url', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '57', '58', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('179', 'footermenu', 'Joomla Templates', 'joomla-templates', '', 'joomla-templates', 'http://www.joomlashine.com/joomla-templates.html', 'url', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '59', '60', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('180', 'footermenu', 'Joomla Extensions', 'joomla-extensions', '', 'joomla-extensions', 'http://www.joomlashine.com/joomla-extensions.html', 'url', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '61', '62', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('181', 'mustsee', 'Easy to start', '2011-11-25-07-20-55', '', '2011-11-25-07-20-55', 'index.php?Itemid=', 'alias', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"aliasoptions\":\"172\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '63', '64', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('182', 'mustsee', 'Painless Configuration', '2011-03-31-04-10-55', '', '2011-03-31-04-10-55', 'index.php?Itemid=', 'alias', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"aliasoptions\":\"173\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}', '65', '66', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('183', 'mainmenu', 'Layout', 'layout', '', 'layout', 'index.php?option=com_content&view=article&id=22', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"Over 40 positions...\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '67', '80', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('184', 'mainmenu', 'Left | Center | Right ', 'left--center--right', '', 'layout/left--center--right', 'index.php?option=com_content&view=article&id=26', 'component', '1', '183', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '68', '69', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('185', 'mainmenu', 'Left | Innerleft | Center', 'left--innerleft--center', '', 'layout/left--innerleft--center', 'index.php?option=com_content&view=article&id=27', 'component', '1', '183', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '70', '71', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('186', 'mainmenu', 'Left | Center | Innerright', 'left--center--innerright', '', 'layout/left--center--innerright', 'index.php?option=com_content&view=article&id=25', 'component', '1', '183', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '72', '73', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('187', 'mainmenu', 'Center | Innerright | Right', 'center--innerright--right', '', 'layout/center--innerright--right', 'index.php?option=com_content&view=article&id=23', 'component', '1', '183', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '74', '75', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('188', 'mainmenu', 'Innerleft | Center | Right', 'innerleft--center--right', '', 'layout/innerleft--center--right', 'index.php?option=com_content&view=article&id=24', 'component', '1', '183', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '76', '77', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('189', 'mainmenu', 'Main content only', 'main-content-only', '', 'layout/main-content-only', 'index.php?option=com_content&view=article&id=28', 'component', '1', '183', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '78', '79', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('190', 'mainmenu', 'Menu Styles', 'menu-styles', '', 'menu-styles', 'index.php?option=com_content&view=article&id=30', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"For efficient navigation\\u2026\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '81', '86', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('191', 'mainmenu', 'Main Menu', 'main-menu', '', 'menu-styles/main-menu', 'index.php?option=com_content&view=article&id=29', 'component', '1', '190', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '82', '83', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('192', 'mainmenu', 'Tree menu', 'tree-menu', '', 'menu-styles/tree-menu', 'index.php?option=com_content&view=article&id=44', 'component', '1', '190', '2', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '84', '85', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('193', 'mainmenu', 'Module Styles', 'module-styles', '', 'module-styles', 'index.php?option=com_content&view=article&id=31', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"Make it clear and beautiful\\u2026\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '87', '88', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('194', 'mainmenu', 'Get it now', 'download-now', '', 'download-now', 'http://www.joomlashine.com/joomla-templates/jsn-epic-download.html', 'url', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"menu-anchor_title\":\"Yes, this template is free\\u2026\",\"menu-anchor_css\":\"icon-cart\",\"menu_image\":\"\",\"menu_text\":1}', '89', '90', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('195', 'mustsee', 'Layout', '2011-03-31-04-22-51', '', '2011-03-31-04-22-51', 'index.php?Itemid=', 'alias', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"aliasoptions\":\"183\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '91', '92', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('196', 'mustsee', 'Menu Styles', '2011-03-31-04-23-33', '', '2011-03-31-04-23-33', 'index.php?Itemid=', 'alias', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"aliasoptions\":\"190\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '93', '94', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('197', 'mustsee', 'Module Styles', '2011-03-31-04-24-11', '', '2011-03-31-04-24-11', 'index.php?Itemid=', 'alias', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"aliasoptions\":\"193\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}', '95', '96', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('198', 'mustsee', 'RTL Support', '2011-03-31-04-24-46', '', '2011-03-31-04-24-46', 'index.php?Itemid=', 'alias', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"aliasoptions\":\"174\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\"}', '97', '98', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('199', 'topmenu', 'Quick Tour', 'quick-tour', '', 'quick-tour', 'index.php?option=com_content&view=article&id=21', 'component', '1', '1', '1', '22', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1,\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"menu-meta_keywords\":\"\",\"robots\":\"\",\"secure\":0}', '99', '100', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('200', 'topmenu', 'Get it now', 'downloadnow', '', 'downloadnow', 'http://www.joomlashine.com/joomla-templates/jsn-epic-download.html', 'url', '1', '1', '1', '', '', '', '0000-00-00 00:00:00', '', '1', '', '', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '101', '102', '', '*', '');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('201', 'menu', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', '', '1', '1', '4', '', '', '0000-00-00 00:00:00', '', '', 'class:banners', '', '', '1', '10', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('202', 'menu', 'com_banners', 'banners', '', 'Banners/banners', 'index.php?option=com_banners', 'component', '', '201', '2', '4', '', '', '0000-00-00 00:00:00', '', '1', 'class:banners', '', '', '2', '3', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('203', 'menu', 'com_banners_categories', 'categories', '', 'Banners/categories', 'index.php?option=com_categories&extension=com_banners', 'component', '', '201', '2', '6', '', '', '0000-00-00 00:00:00', '', '1', 'class:banners-cat', '', '', '4', '5', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('204', 'menu', 'com_banners_clients', 'clients', '', 'Banners/clients', 'index.php?option=com_banners&view=clients', 'component', '', '201', '2', '4', '', '', '0000-00-00 00:00:00', '', '1', 'class:banners-clients', '', '', '6', '7', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('205', 'menu', 'com_banners_tracks', 'tracks', '', 'Banners/tracks', 'index.php?option=com_banners&view=tracks', 'component', '', '201', '2', '4', '', '', '0000-00-00 00:00:00', '', '1', 'class:banners-tracks', '', '', '8', '9', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('206', 'menu', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', '', '1', '1', '8', '', '', '0000-00-00 00:00:00', '', '', 'class:contact', '', '', '11', '16', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('207', 'menu', 'com_contact', 'contacts', '', 'Contacts/contacts', 'index.php?option=com_contact', 'component', '', '206', '2', '8', '', '', '0000-00-00 00:00:00', '', '1', 'class:contact', '', '', '12', '13', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('208', 'menu', 'com_contact_categories', 'categories', '', 'Contacts/categories', 'index.php?option=com_categories&extension=com_contact', 'component', '', '206', '2', '6', '', '', '0000-00-00 00:00:00', '', '1', 'class:contact-cat', '', '', '14', '15', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('209', 'menu', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', '', '1', '1', '15', '', '', '0000-00-00 00:00:00', '', '', 'class:messages', '', '', '17', '22', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('210', 'menu', 'com_messages_add', 'new-private-message', '', 'Messaging/new-private-message', 'index.php?option=com_messages&task=message.add', 'component', '', '209', '2', '15', '', '', '0000-00-00 00:00:00', '', '1', 'class:messages-add', '', '', '18', '19', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('211', 'menu', 'com_messages_read', 'read-private-message', '', 'Messaging/read-private-message', 'index.php?option=com_messages', 'component', '', '209', '2', '15', '', '', '0000-00-00 00:00:00', '', '1', 'class:messages-read', '', '', '20', '21', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('212', 'menu', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', '', '1', '1', '17', '', '', '0000-00-00 00:00:00', '', '', 'class:newsfeeds', '', '', '23', '28', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('213', 'menu', 'com_newsfeeds_feeds', 'feeds', '', 'News Feeds/feeds', 'index.php?option=com_newsfeeds', 'component', '', '212', '2', '17', '', '', '0000-00-00 00:00:00', '', '1', 'class:newsfeeds', '', '', '24', '25', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('214', 'menu', 'com_newsfeeds_categories', 'categories', '', 'News Feeds/categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', '', '212', '2', '6', '', '', '0000-00-00 00:00:00', '', '1', 'class:newsfeeds-cat', '', '', '26', '27', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('215', 'menu', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', '', '1', '1', '24', '', '', '0000-00-00 00:00:00', '', '', 'class:redirect', '', '', '41', '42', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('216', 'menu', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', '', '1', '1', '19', '', '', '0000-00-00 00:00:00', '', '', 'class:search', '', '', '31', '32', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('217', 'menu', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', '', '1', '1', '21', '', '', '0000-00-00 00:00:00', '', '', 'class:weblinks', '', '', '33', '38', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('218', 'menu', 'com_weblinks_links', 'links', '', 'Weblinks/links', 'index.php?option=com_weblinks', 'component', '', '217', '2', '21', '', '', '0000-00-00 00:00:00', '', '1', 'class:weblinks', '', '', '34', '35', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('219', 'menu', 'com_weblinks_categories', 'categories', '', 'Weblinks/categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', '', '217', '2', '6', '', '', '0000-00-00 00:00:00', '', '1', 'class:weblinks-cat', '', '', '36', '37', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('220', 'menu', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', '', '1', '1', '27', '', '', '0000-00-00 00:00:00', '', '', 'class:finder', '', '', '29', '30', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('221', 'menu', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', '', '1', '1', '28', '', '', '0000-00-00 00:00:00', '', '', 'class:joomlaupdate', '', '', '39', '40', '', '*', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('222', 'main', 'COM_IMAGESHOW', 'com-imageshow', '', 'com-imageshow', 'index.php?option=com_imageshow', 'component', '', '1', '1', '10035', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_imageshow/assets/images/icons-16/icon-picture.png', '', '', '103', '114', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('223', 'main', 'LAUNCH_PAD', 'launch-pad', '', 'com-imageshow/launch-pad', 'index.php?option=com_imageshow', 'component', '', '222', '2', '10035', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_imageshow/assets/images/icons-16/icon-off.png', '', '', '104', '105', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('224', 'main', 'SHOWLISTS', 'showlists', '', 'com-imageshow/showlists', 'index.php?option=com_imageshow&controller=showlist', 'component', '', '222', '2', '10035', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_imageshow/assets/images/icons-16/icon-file.png', '', '', '106', '107', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('225', 'main', 'SHOWCASES', 'showcases', '', 'com-imageshow/showcases', 'index.php?option=com_imageshow&controller=showcase', 'component', '', '222', '2', '10035', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_imageshow/assets/images/icons-16/icon-monitor.png', '', '', '108', '109', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('226', 'main', 'CONFIGURATION_AND_MAINTENANCE', 'configuration-and-maintenance', '', 'com-imageshow/configuration-and-maintenance', 'index.php?option=com_imageshow&controller=maintenance&type=configs', 'component', '', '222', '2', '10035', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_imageshow/assets/images/icons-16/icon-cog.png', '', '', '110', '111', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('227', 'main', 'ABOUT', 'about', '', 'com-imageshow/about', 'index.php?option=com_imageshow&controller=about', 'component', '', '222', '2', '10035', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_imageshow/assets/images/icons-16/icon-star.png', '', '', '112', '113', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('228', 'main', 'JSN_POWERADMIN_MENU_TEXT', 'jsn-poweradmin-menu-text', '', 'jsn-poweradmin-menu-text', 'index.php?option=com_poweradmin', 'component', '', '1', '1', '10040', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_poweradmin/assets/images/icons-16/icon-wrench.png', '', '', '115', '124', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('229', 'main', 'JSN_POWERADMIN_MENU_RAWMODE_TEXT', 'jsn-poweradmin-menu-rawmode-text', '', 'jsn-poweradmin-menu-text/jsn-poweradmin-menu-rawmode-text', 'index.php?option=com_poweradmin&view=rawmode', 'component', '', '228', '2', '10040', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_poweradmin/assets/images/icons-16/icon-finder.png', '', '', '116', '117', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('230', 'main', 'JSN_POWERADMIN_MENU_SITESEARCH_TEXT', 'jsn-poweradmin-menu-sitesearch-text', '', 'jsn-poweradmin-menu-text/jsn-poweradmin-menu-sitesearch-text', 'index.php?option=com_poweradmin&task=search.query', 'component', '', '228', '2', '10040', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_poweradmin/assets/images/icons-16/icon-search.png', '', '', '118', '119', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('231', 'main', 'JSN_POWERADMIN_MENU_CONFIGURATION_TEXT', 'jsn-poweradmin-menu-configuration-text', '', 'jsn-poweradmin-menu-text/jsn-poweradmin-menu-configuration-text', 'index.php?option=com_poweradmin&view=configuration', 'component', '', '228', '2', '10040', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_poweradmin/assets/images/icons-16/icon-cog.png', '', '', '120', '121', '', '', '1');
INSERT INTO `np846_menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `ordering`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES ('232', 'main', 'JSN_POWERADMIN_MENU_ABOUT_TEXT', 'jsn-poweradmin-menu-about-text', '', 'jsn-poweradmin-menu-text/jsn-poweradmin-menu-about-text', 'index.php?option=com_poweradmin&view=about', 'component', '', '228', '2', '10040', '', '', '0000-00-00 00:00:00', '', '1', 'components/com_poweradmin/assets/images/icons-16/icon-star.png', '', '', '122', '123', '', '', '1');

DROP TABLE IF EXISTS `np846_modules_menu`;
CREATE TABLE `np846_modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('2', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('3', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('4', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('6', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('7', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('8', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('9', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('10', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('12', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('13', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('14', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('15', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('19', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('23', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('30', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('49', '120');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('55', '119');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('57', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('57', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('57', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('57', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('57', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('57', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('67', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('77', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('77', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('77', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('77', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('77', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('77', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('77', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('78', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('78', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('78', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('78', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('78', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('78', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('78', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('79', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('80', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('81', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '194');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '199');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('82', '200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '194');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '199');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('83', '200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '194');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '199');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('84', '200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('85', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('86', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('87', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('87', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('88', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('88', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('89', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('89', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('89', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '194');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('91', '200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '194');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('92', '200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('93', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('94', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('95', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('95', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('95', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('96', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('96', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('96', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('96', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('96', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('96', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('97', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('97', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('97', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('97', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('97', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('97', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('98', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('98', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('98', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('98', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('98', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('98', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('99', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('100', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('100', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('100', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('100', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('100', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('100', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('101', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('101', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('101', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('101', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('101', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('101', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('102', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('103', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('104', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('105', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('106', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('107', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('108', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('109', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('110', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('111', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '194');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '199');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('114', '200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('115', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('116', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('116', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('116', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('117', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('117', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('117', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('117', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('117', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('117', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('118', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('119', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('119', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('119', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('119', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('119', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('119', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('119', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('120', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('121', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '101');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '183');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '190');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '191');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '192');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '193');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '194');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('122', '198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('123', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('124', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('125', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('126', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('127', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('127', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('127', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('127', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('127', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('127', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('128', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('128', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('128', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('128', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('128', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('128', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('129', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('129', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('129', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('129', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('129', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('129', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('130', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('130', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('130', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('130', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('130', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('130', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('131', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('131', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('131', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('131', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('131', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('131', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('132', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('132', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('132', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('132', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('132', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('132', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('133', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('133', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('133', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('133', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('133', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('133', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '199');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('134', '200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('135', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('135', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('135', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('135', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('135', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('135', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('136', '189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-200');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-199');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-198');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-197');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-196');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-195');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-189');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-188');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-187');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-186');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-185');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-184');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-182');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-181');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-180');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-179');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-178');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-177');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-176');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-175');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-174');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-173');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('138', '-172');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('139', '');
INSERT INTO `np846_modules_menu` (`moduleid`, `menuid`) VALUES ('194', '');

DROP TABLE IF EXISTS `np846_modules`;
CREATE TABLE `np846_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `published` (`published`,`access`),
  KEY `newsfeeds` (`module`,`published`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=195 DEFAULT CHARSET=utf8;

INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('2', 'Login', '', '', '1', 'login', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_login', '1', '1', '', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('3', 'Popular Articles', '', '', '3', 'cpanel', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_popular', '3', '1', '{\"count\":\"5\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('4', 'Recently Added Articles', '', '', '4', 'cpanel', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_latest', '3', '1', '{\"count\":\"5\",\"ordering\":\"c_dsc\",\"catid\":\"\",\"user_id\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('8', 'Toolbar', '', '', '1', 'toolbar', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_toolbar', '3', '1', '', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('9', 'Quick Icons', '', '', '1', 'icon', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_quickicon', '3', '1', '', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('10', 'Logged-in Users', '', '', '2', 'cpanel', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_logged', '3', '1', '{\"count\":\"5\",\"name\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"0\",\"automatic_title\":\"1\"}', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('12', 'Admin Menu', '', '', '1', 'menu', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '3', '1', '{\"layout\":\"\",\"moduleclass_sfx\":\"\",\"shownew\":\"1\",\"showhelp\":\"1\",\"cache\":\"0\"}', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('13', 'Admin Submenu', '', '', '1', 'submenu', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_submenu', '3', '1', '', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('14', 'User Status', '', '', '2', 'status', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_status', '3', '1', '', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('15', 'Title', '', '', '1', 'title', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_title', '3', '1', '', '1', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('77', 'Banners', '', '', '', 'banner', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_banners', '1', '', '{\"target\":\"1\",\"count\":\"1\",\"cid\":\"1\",\"catid\":[\"53\"],\"tag_search\":\"0\",\"ordering\":\"random\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('78', 'Banners', '', '', '', 'banner', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_banners', '1', '', '{\"target\":\"1\",\"count\":\"1\",\"cid\":\"0\",\"catid\":[\"53\"],\"tag_search\":\"0\",\"ordering\":\"random\",\"header_text\":\"\",\"footer_text\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('79', 'dfghdfgfd', '', '', '', 'banner', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('80', 'Joomla! Copyright', '', '<p>The <a href=\"http://www.joomla.org/\" target=\"_blank\">Joomla!</a> name is used under a limited license from <a href=\"http://www.opensourcematters.org/\" target=\"_blank\">Open Source Matters</a> in the United States and other countries.<a href=\"http://www.joomlashine.com\" target=\"_blank\">JoomlaShine.com</a> is not affiliated with or endorsed by Open Source Matters or the Joomla! Project.</p>', '', 'bottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('81', 'Breadcrumbs', '', '', '1', 'breadcrumbs', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_breadcrumbs', '1', '1', '{\"showHere\":\"0\",\"showHome\":\"1\",\"homeText\":\"Home\",\"showLast\":\"1\",\"separator\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('82', 'Easy to start', '', '<p><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/easy-start/easy-start-banner.jpg\" alt=\"Easy to start\" width=\"100\" height=\"100\" class=\"image-left image-border\" />JSN Epic provides  unique mechanism of installing sample data on directly your current website. Just  few clicks and the demo website is here.</p>
<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=5&amp;Itemid=172\" class=\"link-action\">Read more...</a></p>', '1', 'content-bottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('83', 'Docs / Support', '', '<p><img class=\"image-left image-border\" src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/docs-support/docs-support-banner.jpg\" border=\"0\" alt=\"Docs / Support\" width=\"100\" height=\"100\" />In addition to comprehensive documentations in PDF format, you also get support from friendly forum and dedicated support system.</p>
<p><a class=\"link-action\" href=\"index.php?option=com_content&amp;view=article&amp;id=3&amp;Itemid=176\">Read more...</a></p>', '1', 'content-bottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('84', 'Native RTL Support', '', '<p><img class=\"image-border image-left\" src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/rtl-support/rtl-support-banner.jpg\" border=\"0\" alt=\"Native RTL Support\" width=\"100\" height=\"100\" />Native RTL support means that every elements on the page is mirror swapped including layout, menus, typography, icons...everything.</p>
<p><a class=\"link-action\" href=\"index.php?option=com_content&amp;view=article&amp;id=41&amp;Itemid=172\">Read more...</a></p>', '1', 'content-bottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('85', 'Footer Menu', '', '', '', 'footer', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_menu', '1', '', '{\"menutype\":\"footermenu\",\"startLevel\":\"1\",\"endLevel\":\"1\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"menu-divmenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('86', 'JoomlaShine copyright', '', '<p>Copyright  2008 - 2012 JoomlaShine.com. All rights reserved. To see more feature of this template, please check out <a href=\"http://www.joomlashine.com/joomla-templates/jsn-epic-download.html\">JSN Epic PRO edition</a>.</p>
<p>All stock photos used on this JSN Epic demo site are only for demo purposes and not included in the template package.</p>', '1', 'footer', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('87', 'Position \"innerleft\"', '', '<p>This is sample module in position <strong>innerleft</strong>. The whole position will be collapsed, if there are no modules published.</p>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>', '1', 'innerleft', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('88', 'Position \"innerright\"', '', '<p>This is sample module in position <strong>innerright</strong>. The whole position will be collapsed, if there are no modules published.</p>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>', '1', 'innerright', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('89', 'Position \"left\"', '', '<p>This is a sample module in position <strong>left</strong>. The whole position will be collapsed, if there are no modules published.</p>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>', '1', 'left', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-grey\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('90', 'Docs Download', '', '<p>Full details about all template features can be found in comprehensive documentation package available for free download.</p>
<p class=\"content-center\"><a href=\"http://www.joomlashine.com/joomla-templates/jsn-epic-docs.zip\" class=\"link-action\">Download documentation</a></p>', '1', 'left', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-yellow icon-help\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('91', 'JSN ImageShow Replacement', '', '<a href=\"http://www.joomlashine.com/joomla-extensions/jsn-imageshow.html\" target=\"_blank\" style=\"display: block; height: 300px; background: url(http://demo.joomlashine.com/joomla-templates/jsn_epic/images/extensions/custom-html/jsn-imageshow-promo/jsn-imageshow-promo.jpg) center center no-repeat;\"></a>', '1', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('92', 'Why choose JSN Epic?', '', '<p>If you are looking for a clean and professional business template, the solution is right here.</p>
<p>In 5 minutes you will see how JSN Epic can be the perfect template for your business website.</p>
<p class=\"content-center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=21&amp;Itemid=199\"><strong>Take a quick tour</strong></a></p>', '1', 'promo-right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('93', '\"RichBox 1\" Style', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>
<p>Module Class Suffix:<br />
  <strong>&quot;richbox-1&quot;</strong></p>', '1', 'left', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"richbox-1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('94', 'Docs Download', '', '<p>Full details about all template features can be found in comprehensive documentation package available for free download.</p>
<p class=\"content-center\"><a href=\"http://www.joomlashine.com/joomla-templates/jsn-epic-docs.zip\" class=\"link-action\">Download documentation</a></p>', '6', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-yellow icon-help\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('95', 'Position \"right\"', '', '<p>This is sample module in position <strong>right</strong>. The whole position will be collapsed, if there are no modules published.</p>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>', '1', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-yellow\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('96', 'Position \"stick-leftbottom\"', '', '<a><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/position-stick-x/position-stick-leftbottom.png\" width=\"65\" height=\"190\" alt=\"Sample module in position -stick-leftbottom-\" /></a>', '1', 'stick-leftbottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('97', 'Position \"stick-leftmiddle\"', '', '<a><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/position-stick-x/position-stick-leftmiddle.png\" width=\"65\" height=\"190\" alt=\"Sample module in position -stick-leftmiddle-\" /></a>', '1', 'stick-leftmiddle', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('98', 'Position \"stick-lefttop\"', '', '<a><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/position-stick-x/position-stick-lefttop.png\" width=\"65\" height=\"190\" alt=\"Sample module in position -stick-lefttop-\" /></a>', '1', 'stick-lefttop', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('99', 'See other templates', '', '<a rel=\"{handler: \'iframe\', size: {x: 640, y: 510}}\" href=\"http://www.joomlashine.com/free-joomla-templates-promo.html\" class=\"modal link-tooltip\" style=\"z-index: 90;\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/see-other-templates/see-other-templates-banner.png\" width=\"120\" height=\"120\" alt=\"See other templates\" /><span style=\"left: -90px; top: -260px\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/see-other-templates/see-other-templates-banner-text.png\" width=\"200\" height=\"200\" alt=\"See other templates\" /></span></a>', '1', 'stick-rightbottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('100', 'Position \"stick-rightmiddle\"', '', '<a><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/position-stick-x/position-stick-rightmiddle.png\" width=\"65\" height=\"190\" alt=\"Sample module in position -stickrightmiddle-\" /></a>', '1', 'stick-rightmiddle', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('101', 'Position \"stick-righttop\"', '', '<a><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/position-stick-x/position-stick-righttop.png\" width=\"65\" height=\"190\" alt=\"Sample module in position -righttop-\" /></a>', '1', 'stick-righttop', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('102', 'See PRO edition', '', '<a href=\"http://demo.joomlashine.com/joomla-templates/jsn-epic.html\" class=\"link-tooltip\" style=\"z-index: 90;\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/pro-edition/pro-edition-banner.png\" width=\"120\" height=\"120\" alt=\"See PRO edition\" /><span style=\"left: -120px; top: -20px\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/pro-edition/pro-edition-banner-text.png\" width=\"240\" height=\"250\" alt=\"See PRO edition\" /></span></a>', '2', 'stick-righttop', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('103', 'Plain Style', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>
<p>Module Class Suffix:<br />
  <em>empty</em></p>', '1', 'user-bottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('104', 'Plain Style', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>
<p>Module Class Suffix:<br />
  <em>empty</em></p>', '1', 'user-bottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('105', '\"Blue Box\" Style', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>
<p>Module Class Suffix:<br />
  <strong>&quot;box-blue&quot;</strong></p>', '1', 'user-top', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-blue\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('106', 'Versatile Layout', '', '<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/versatile-layout/layout-banner.jpg\" alt=\"Versatile Layout\" class=\"image-border\" /></p>
<p>JSN Epic provides <strong>36 module positions</strong> allowing you to have multiple layout configurations.</p>
<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=22&amp;Itemid=183\" class=\"link-action\">More about layout...</a></p>', '1', 'user-top', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-image\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('107', '\"RichBox 2\" Style', '', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc varius nisl id lectus ultricies ut elementum nulla ornare. Nulla sed mi massa, at tincidunt felis.</p>
<p>Module Class Suffix:<br />
  <strong>&quot;richbox-2&quot;</strong></p>', '1', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"richbox-2\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('108', 'Multiple Module Styles', '', '<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/module-styles/colors-banner.jpg\" alt=\"Multiple Module Styles\" class=\"image-border\" /></p>
<p>With JSN Epic you can decorate modules with <strong>4 appealing module styles</strong> in any positions.</p>
<p><a href=\"index.php?option=com_content&amp;view=article&amp;id=31&amp;Itemid=193\" class=\"link-action\">More about module styles...</a></p>', '1', 'user-top', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-selection\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('109', 'Footer Menu', '', '', '2', 'footer', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '', '{\"menutype\":\"footermenu\",\"startLevel\":\"1\",\"endLevel\":\"1\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"menu-divmenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('110', 'Tree Menu with rich text', '', '', '1', 'left', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"menu-treemenu menu-iconmenu menu-richmenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-yellow\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('111', 'Must-see Stuff', '', '', '1', 'left', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"mustsee\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"menu-treemenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-grey icon-star\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('112', 'Side Menu', '', '', '', 'left', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"10\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"menu-sidemenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-yellow icon-settings\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('113', 'J! Stuff', '', '', '1', 'left', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '-2', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"startLevel\":\"2\",\"endLevel\":\"10\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"menu-sidemenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-blue icon-article\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('114', 'Main Menu', '', '', '1', 'mainmenu', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '', '{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"menu-mainmenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('115', 'Tree Menu', '', '', '1', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"menu-treemenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-grey\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('116', 'Menu', '', '', '1', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"mainmenu\",\"startLevel\":\"2\",\"endLevel\":\"3\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"menu-treemenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-grey icon-star \",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('117', 'Advanced Stuff', '', '', '1', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '1', '{\"menutype\":\"advanced-stuff\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"menu-treemenu \",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-grey icon-star\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('118', 'Top Menu', '', '', '', 'top', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '', '{\"menutype\":\"topmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"tag_id\":\"\",\"class_sfx\":\"menu-divmenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('119', 'Who\'s Online', '', '', '7', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_whosonline', '1', '1', '{\"showmode\":\"0\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"icon-info\",\"cache\":\"0\",\"filter_groups\":\"0\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('120', 'Main Menu (Icons & Rich Text)', '', '', '1', 'mainmenu', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_menu', '1', '', '{\"menutype\":\"mainmenu\",\"startLevel\":\"1\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"menu-mainmenu menu-iconmenu menu-richmenu\",\"window_open\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('121', 'Native Compatibility', '', '<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/native-compatibility/j25-j15-promo.png\" width=\"170\" height=\"50\" alt=\"Joomla! 2.5 - Get more\" /></p>
<p>JSN Epic is delivered in 2 separated versions <strong>natively</strong> <strong>compatible for Joomla! 2.5 and Joomla! 1.5</strong>.</p>
<p>Installation package for both Joomla! versions can be downloaded for free.</p>', '1', 'right', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"box-yellow\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('122', 'JSN ImageShow', '', '', '1', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '', '{\"moduleclass_sfx\":\"\",\"showlist_id\":\"1\",\"showcase_id\":\"1\",\"width\":\"\",\"height\":\"\",\"pretext\":\"\",\"posttext\":\"\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('126', 'Built with JSN PowerAdmin', '', '<a href=\"http://www.joomlashine.com/joomla-extensions/jsn-poweradmin.html\" target=\"_blank\" class=\"link-tooltip\" style=\"z-index: 90;\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/built-with-poweradmin/built-with-poweradmin-banner.png\" width=\"120\" height=\"120\" alt=\"Built with JSN PowerAdmin\" /><span style=\"top: -260px\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/built-with-poweradmin/built-with-poweradmin-banner-text.png\" width=\"200\" height=\"200\" alt=\"Built with JSN PowerAdmin\" style=\"max-width: none;\" /></span></a>', '1', 'stick-leftbottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('127', 'Position \"content-top\"', '', '<p>This is a sample module in position <strong>&ldquo;content-top&rdquo;</strong>. All modules in this position will be arranged in <strong>horizontal row</strong>. The whole position will be collapsed, if there are no modules published.</p>
', '1', 'content-top', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('128', 'Position \"content-top\"', '', '<p>This is a sample module in position <strong>&ldquo;content-top&rdquo;</strong>. All modules in this position will be arranged in <strong>horizontal row</strong>. The whole position will be collapsed, if there are no modules published.</p>
', '1', 'content-top', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('129', 'Position \"user1\"', '', '<p>This is a sample module in position <strong>&ldquo;user1&rdquo;</strong>. All modules in this position will be arranged in <strong>vertical column</strong>. The whole position will be collapsed, if there are no modules published.</p>', '1', 'user1', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('130', 'Position \"user2\"', '', '<p>This is a sample module in position <strong>&ldquo;user2&rdquo;</strong>. All modules in this position will be arranged in <strong>vertical column</strong>. The whole position will be collapsed, if there are no modules published.</p>', '1', 'user2', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('131', 'Position \"user3\"', '', '<p>This is a sample module in position <strong>&ldquo;user3&rdquo;</strong>. All modules in this position will be arranged in <strong>vertical column</strong>. The whole position will be collapsed, if there are no modules published.</p>', '1', 'user3', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('132', 'Position \"user4\"', '', '<p>This is a sample module in position <strong>&ldquo;user4&rdquo;</strong>. All modules in this position will be arranged in <strong>vertical column</strong>. The whole position will be collapsed, if there are no modules published.</p>', '1', 'user4', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('133', 'Position \"user5\"', '', '<p>This is a sample module in position <strong>&ldquo;user5&rdquo;</strong>. All modules in this position will be arranged in <strong>vertical column</strong>. The whole position will be collapsed, if there are no modules published.</p>', '1', 'user5', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('134', 'Position \"user7\"', '', '<p>This is a sample module in position <strong>&ldquo;user7&rdquo;</strong>. All modules in this position will be arranged in <strong>horizontal row</strong>. The whole position will be collapsed, if there are no modules published.</p>', '', 'user7', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('135', 'Position \"user6\"', '', '<p>This is a sample module in position <strong>&ldquo;user6&rdquo;</strong>. All modules in this position will be arranged in <strong>horizontal row</strong>. The whole position will be collapsed, if there are no modules published.</p>', '1', 'user6', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('136', 'Layout Variations', '', '<div class=\"grid-layout\" style=\"margin-top: 10px\">
<div class=\"content-center\"><a href=\"index.php?option=com_content&view=article&id=90&Itemid=472\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-lcr.png\" width=\"160\" height=\"90\" alt=\"Left | Center | Right\" style=\"vertical-align: middle;\" class=\"margin-right\" /><br />
Left | Center | Right</a></div>
<div class=\"content-center\"><a href=\"index.php?option=com_content&view=article&id=92&Itemid=477\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-mc.png\" width=\"160\" height=\"90\" alt=\"Main content only\" style=\"vertical-align: middle;\" class=\"margin-right\" /><br />
Main content only</a></div>
</div>
<div class=\"grid-layout\" style=\"margin-top: 10px\">
<div class=\"content-center\"><a href=\"index.php?option=com_content&view=article&id=89&Itemid=474\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-lcir.png\" width=\"160\" height=\"90\" alt=\"Left | Center | InnerRight\" style=\"vertical-align: middle;\" class=\"margin-right\" /><br />
Left | Center | InnerRight</a></div>
<div class=\"content-center\"><a href=\"index.php?option=com_content&view=article&id=88&Itemid=476\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-ilcr.png\" width=\"160\" height=\"90\" alt=\"InnerLeft | Center | Right\" style=\"vertical-align: middle;\" class=\"margin-right\" /><br />
InnerLeft | Center | Right</a></div>
</div>
<div class=\"grid-layout\" style=\"margin-top: 10px\">
<div class=\"content-center\"><a href=\"index.php?option=com_content&view=article&id=91&Itemid=473\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-lilc.png\" width=\"160\" height=\"90\" alt=\"Left | Center | InnerRight\" style=\"vertical-align: middle;\" class=\"margin-right\" /><br />
Left | InnerLeft | Center</a></div>
<div class=\"content-center\"><a href=\"index.php?option=com_content&view=article&id=87&Itemid=475\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-cirr.png\" width=\"160\" height=\"90\" alt=\"Left | Center | Right\" style=\"vertical-align: middle;\" class=\"margin-right\" /><br />
Center | InnerRight | Right</a></div>
</div>
', '1', 'user-bottom', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '1', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('138', 'Demo Builder Button', '', '<style>

div#jsn-demo-builder-toggle {
    position: absolute;
    width: 650px;
    left: -565px;
    transition: all 0.6s ease;
    -moz-transition: all 0.6s ease;
    -webkit-transition: all 0.6s ease;
}
div#jsn-demo-builder-toggle > a:hover:not(.active) {
    left: -560px;
}
div#jsn-demo-builder-toggle.active {
    left: 0;
}
div#jsn-demo-builder-toggle > div,
div#jsn-demo-builder-toggle > a {
    float: left;
    cursor: default;
}
div#jsn-demo-builder-toggle > a {
    overflow: hidden;
}
div#jsn-demo-builder-toggle > a img {
    position: relative;
    left: -5px;
    transition: all 0.3s ease;
    -moz-transition: all 0.3s ease;
    -webkit-transition: all 0.3s ease;
    cursor: pointer;
}
div#jsn-demo-builder-toggle > a img:hover,
div#jsn-demo-builder-toggle > a.active img {
    left: 0;
}
div#jsn-demo-builder-toggle > div > iframe {
    background-color: #fff;
    border-top: solid 10px #434448;
    border-right: solid 10px #434448;
    border-bottom: solid 10px #434448;
    border-left: none;
    border-bottom-right-radius: 5px;
}
div#jsn-demo-builder-toggle {
    margin: 0;
    padding: 0;
}
</style>
<div id=\"jsn-demo-builder-toggle\">
    <div>
        <iframe src=\"http://myjoomlashine.com/demo-builder/index.php?template=epic\" width=\"550px\" height=\"625px\"></iframe>
    </div>
    <a id=\"jsn-demo-builder-button\" href=\"javascript:void(0);\">
        <img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/demo_builder_button_black.png\" alt=\"Demo Builder Toggle\" />
    </a>
</div>
<script type=\"text/javascript\">
$(\"jsn-demo-builder-button\").addEvent(\"click\", function() {
    this.toggleClass(\"active\");
    $(\"jsn-demo-builder-toggle\").toggleClass(\"active\");
});
</script>
', '1', 'stick-lefttop', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_custom', '1', '', '{\"prepare_content\":\"1\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('187', 'JSN ImageShow', '', '', '1', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '', '{\"moduleclass_sfx\":\"\",\"showlist_id\":\"3\",\"showcase_id\":\"1\",\"width\":\"\",\"height\":\"\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('188', 'JSN ImageShow', '', '', '1', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '', '{\"moduleclass_sfx\":\"\",\"showlist_id\":\"3\",\"showcase_id\":\"4\",\"width\":\"\",\"height\":\"270\",\"pretext\":\"\",\"posttext\":\"\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('189', 'JSN ImageShow', '', '', '1', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '', '{\"moduleclass_sfx\":\"\",\"showlist_id\":\"3\",\"showcase_id\":\"1\",\"width\":\"\",\"height\":\"\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('190', 'JSN ImageShow', '', '', '1', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '', '{\"moduleclass_sfx\":\"\",\"showlist_id\":\"3\",\"showcase_id\":\"1\",\"width\":\"\",\"height\":\"\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('191', 'JSN ImageShow', '', '', '1', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '', '{\"moduleclass_sfx\":\"\",\"showlist_id\":\"1\",\"showcase_id\":\"1\",\"width\":\"\",\"height\":\"\",\"pretext\":\"\",\"posttext\":\"\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('192', 'JSN ImageShow', '', '', '2', 'promo', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '', '{\"moduleclass_sfx\":\"\",\"showlist_id\":\"3\",\"showcase_id\":\"1\",\"width\":\"\",\"height\":\"\",\"pretext\":\"\",\"posttext\":\"\"}', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('193', 'JSN ImageShow', '', '', '', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', 'mod_imageshow', '1', '1', '', '', '*');
INSERT INTO `np846_modules` (`id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES ('194', 'JSN ImageShow Quick Icons', '', '', '99', 'icon', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_imageshow_quickicon', '1', '1', '', '1', '*');

DROP TABLE IF EXISTS `np846_assets`;
CREATE TABLE `np846_assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=182 DEFAULT CHARSET=utf8;

INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('1', '', '1', '702', '', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":[],\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('3', '1', '3', '12', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('4', '1', '13', '14', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('5', '1', '15', '16', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('6', '1', '17', '18', '1', 'com_config', 'com_config', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('7', '1', '19', '24', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('8', '1', '25', '302', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('9', '1', '303', '304', '1', 'com_cpanel', 'com_cpanel', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('10', '1', '305', '306', '1', 'com_installer', 'com_installer', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1},\"core.delete\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('11', '1', '307', '308', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('12', '1', '309', '310', '1', 'com_login', 'com_login', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('13', '1', '311', '312', '1', 'com_mailto', 'com_mailto', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('14', '1', '313', '314', '1', 'com_massmail', 'com_massmail', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('15', '1', '315', '316', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('16', '1', '317', '318', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('17', '1', '319', '320', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('18', '1', '321', '322', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('19', '1', '323', '326', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('20', '1', '327', '328', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('21', '1', '329', '330', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1},\"core.manage\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('22', '1', '331', '332', '1', 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('23', '1', '333', '334', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('24', '1', '335', '336', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1},\"core.manage\":[],\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.own\":{\"6\":1},\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('25', '1', '337', '340', '1', 'com_weblinks', 'com_weblinks', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":[],\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('26', '1', '341', '342', '1', 'com_wrapper', 'com_wrapper', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('27', '8', '26', '27', '2', 'com_content.category.2', 'News', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('29', '7', '20', '21', '2', 'com_contact.category.4', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('30', '19', '324', '325', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('31', '25', '338', '339', '2', 'com_weblinks.category.6', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('32', '161', '194', '195', '4', 'com_content.article.1', 'Can Joomla! 1.5 operate with PHP Safe Mode On?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('33', '8', '28', '35', '2', 'com_content.category.7', 'About Joomla!', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('34', '8', '36', '41', '2', 'com_content.category.8', 'News', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('35', '8', '42', '57', '2', 'com_content.category.9', 'FAQs', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('36', '8', '58', '147', '2', 'com_content.category.10', 'Template Details', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('37', '33', '29', '30', '3', 'com_content.category.11', 'The Project', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('38', '33', '31', '32', '3', 'com_content.category.12', 'The CMS', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('39', '33', '33', '34', '3', 'com_content.category.13', 'The Community', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('40', '35', '43', '48', '3', 'com_content.category.14', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('41', '35', '49', '50', '3', 'com_content.category.15', 'Current Users', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('42', '35', '51', '54', '3', 'com_content.category.16', 'New to Joomla!', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('43', '35', '55', '56', '3', 'com_content.category.17', 'Languages', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('44', '34', '37', '38', '3', 'com_content.category.18', 'Latest', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('45', '34', '39', '40', '3', 'com_content.category.19', 'Newsflash', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('46', '36', '59', '72', '3', 'com_content.category.20', 'Design & Features', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('47', '36', '73', '80', '3', 'com_content.category.21', 'Advanced Stuff', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('48', '36', '81', '86', '3', 'com_content.category.22', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('49', '36', '87', '100', '3', 'com_content.category.23', 'Layout Variations', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('50', '36', '101', '134', '3', 'com_content.category.24', 'Testimonials', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('51', '36', '135', '146', '3', 'com_content.category.25', 'Menu Styles', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('52', '165', '230', '231', '4', 'com_content.article.2', 'Content Layouts', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('53', '169', '258', '259', '4', 'com_content.article.3', 'Docs & Support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('54', '162', '212', '213', '4', 'com_content.article.4', 'Does the PDF icon render pictures and special characters?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('55', '169', '260', '261', '4', 'com_content.article.5', 'Easy to Start', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('56', '155', '151', '152', '3', 'com_content.article.6', 'Example Pages and Menu Links', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('57', '165', '232', '233', '4', 'com_content.article.7', 'Extensions', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('58', '169', '262', '263', '4', 'com_content.article.8', 'Image Gallery', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('59', '169', '264', '265', '4', 'com_content.article.9', 'Flash Gallery Alternative', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('60', '161', '196', '197', '4', 'com_content.article.10', 'How do I install Joomla! 1.5?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('61', '162', '214', '215', '4', 'com_content.article.11', 'How do I localise Joomla! to my language?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('62', '159', '174', '175', '4', 'com_content.article.12', 'How do I remove an Article?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('63', '160', '182', '183', '4', 'com_content.article.13', 'How do I upgrade to Joomla! 1.5 ?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('64', '162', '216', '217', '4', 'com_content.article.14', 'I installed with my own language, but the Back-end is still in English', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('65', '170', '274', '275', '4', 'com_content.article.15', 'Introducing JSN Epic', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('66', '161', '198', '199', '4', 'com_content.article.16', 'Is it possible to change A Menu Item\'s Type?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('67', '159', '176', '177', '4', 'com_content.article.17', 'Is it useful to install the sample data?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('68', '166', '242', '243', '4', 'com_content.article.18', 'Joomla! Facts', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('69', '165', '234', '235', '4', 'com_content.article.19', 'Joomla! Features', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('70', '165', '236', '237', '4', 'com_content.article.20', 'Joomla! Overview', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('71', '170', '276', '277', '4', 'com_content.article.21', 'JSN Epic Product Tour', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('72', '168', '250', '251', '4', 'com_content.article.22', 'Layout', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('73', '171', '280', '281', '4', 'com_content.article.23', 'Layout variation Center | Innerright | Right ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('74', '171', '282', '283', '4', 'com_content.article.24', 'Layout variation Innerleft | Center | Right ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('75', '171', '284', '285', '4', 'com_content.article.25', 'Layout variation Left | Center | Innerright ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('76', '171', '286', '287', '4', 'com_content.article.26', 'Layout variation Left | Center | Right', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('77', '171', '288', '289', '4', 'com_content.article.27', 'Layout variation Left | Innerleft | Center', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('78', '171', '290', '291', '4', 'com_content.article.28', 'Main content only', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('79', '173', '296', '297', '4', 'com_content.article.29', 'Main Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('80', '168', '252', '253', '4', 'com_content.article.30', 'Menu Styles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('81', '168', '254', '255', '4', 'com_content.article.31', 'Module Styles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('82', '169', '266', '267', '4', 'com_content.article.32', 'Multilingual Support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('83', '161', '200', '201', '4', 'com_content.article.33', 'My MySQL database does not support UTF-8. Do I have a problem?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('84', '174', '160', '161', '4', 'com_content.article.34', 'Newsflash 1', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('85', '174', '162', '163', '4', 'com_content.article.35', 'Newsflash 2', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('86', '174', '164', '165', '4', 'com_content.article.36', 'Newsflash 3', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('87', '174', '166', '167', '4', 'com_content.article.37', 'Newsflash 4', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('88', '174', '168', '169', '4', 'com_content.article.38', 'Newsflash 5', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('89', '169', '268', '269', '4', 'com_content.article.39', 'Painless Configuration ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('90', '164', '224', '225', '4', 'com_content.article.40', 'Platforms and Open Standards', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('91', '169', '270', '271', '4', 'com_content.article.41', 'RTL Layout Support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('92', '164', '226', '227', '4', 'com_content.article.42', 'Support and Documentation', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('93', '166', '244', '245', '4', 'com_content.article.43', 'The Joomla! Community', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('94', '173', '298', '299', '4', 'com_content.article.44', 'Tree Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('95', '157', '156', '157', '4', 'com_content.article.45', 'Welcome to Joomla!', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('96', '161', '202', '203', '4', 'com_content.article.46', 'What are the requirements to run Joomla! 1.5?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('97', '160', '184', '185', '4', 'com_content.article.47', 'What happened to the locale setting?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('98', '161', '204', '205', '4', 'com_content.article.48', 'What is an Uncategorised Article?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('99', '159', '178', '179', '4', 'com_content.article.49', 'What is the difference between Archiving and Trashing an Article? ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('100', '161', '206', '207', '4', 'com_content.article.50', 'What is the FTP layer for?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('101', '162', '218', '219', '4', 'com_content.article.51', 'What is the purpose of the collation selection in the installation screen?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('102', '165', '238', '239', '4', 'com_content.article.52', 'What\'s New in 1.5?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('103', '160', '186', '187', '4', 'com_content.article.53', 'Where did the Installers go?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('104', '160', '188', '189', '4', 'com_content.article.54', 'Where did the Mambots go?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('105', '160', '190', '191', '4', 'com_content.article.55', 'Where is the Static Content Item?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('106', '161', '208', '209', '4', 'com_content.article.56', 'Why does Joomla! 1.5 use UTF-8 encoding?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('107', '47', '74', '75', '4', 'com_content.article.57', 'SEO & Accessibility', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('108', '47', '76', '77', '4', 'com_content.article.58', 'IE6 Support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('109', '47', '78', '79', '4', 'com_content.article.59', 'RTL Layout Support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('110', '46', '60', '61', '4', 'com_content.article.60', 'Font Styles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('111', '46', '62', '63', '4', 'com_content.article.61', 'Module Styles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('112', '46', '64', '65', '4', 'com_content.article.62', 'Typography', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('113', '46', '66', '67', '4', 'com_content.article.63', 'Menu Styles', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('114', '46', '68', '69', '4', 'com_content.article.64', 'Color Variations', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('115', '46', '70', '71', '4', 'com_content.article.65', 'Layout', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('116', '48', '82', '83', '4', 'com_content.article.66', 'JSN Epic Showcase', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('117', '48', '84', '85', '4', 'com_content.article.67', 'Introducing JSN Epic', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('118', '49', '88', '89', '4', 'com_content.article.68', 'Main content only', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('119', '49', '90', '91', '4', 'com_content.article.69', 'Layout variation Innerleft | Center | Right ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('120', '49', '92', '93', '4', 'com_content.article.70', 'Layout variation Center | Innerright | Right ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('121', '49', '94', '95', '4', 'com_content.article.71', 'Layout variation Left | Center | Innerright ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('122', '49', '96', '97', '4', 'com_content.article.72', 'Layout variation Left | Innerleft | Center', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('123', '49', '98', '99', '4', 'com_content.article.73', 'Layout variation Left | Center | Right', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('124', '51', '136', '137', '4', 'com_content.article.74', 'Side Menu RTL', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('125', '51', '138', '139', '4', 'com_content.article.75', 'Tree Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('126', '51', '140', '141', '4', 'com_content.article.76', 'Top Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('127', '51', '142', '143', '4', 'com_content.article.77', 'Side Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('128', '51', '144', '145', '4', 'com_content.article.78', 'Main Menu', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('129', '50', '102', '103', '4', 'com_content.article.79', 'Thank you for doing a good job', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('130', '50', '104', '105', '4', 'com_content.article.80', 'No words to describe this wonderful product', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('131', '50', '106', '107', '4', 'com_content.article.81', 'Love your tech support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('132', '50', '108', '109', '4', 'com_content.article.82', 'Keep up the good work', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('133', '50', '110', '111', '4', 'com_content.article.83', 'Just what I have been looking for', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('134', '50', '112', '113', '4', 'com_content.article.84', 'JSN Epic DEV', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('135', '50', '114', '115', '4', 'com_content.article.85', 'JSN Epic and JSN ImageShow', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('136', '50', '116', '117', '4', 'com_content.article.86', 'JoomlaShine Dedicated support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('137', '50', '118', '119', '4', 'com_content.article.87', 'I love your products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('138', '50', '120', '121', '4', 'com_content.article.88', 'I had looked at a lot of templates', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('139', '50', '122', '123', '4', 'com_content.article.89', 'Im happy and satisfied', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('140', '50', '124', '125', '4', 'com_content.article.90', 'Great product support and documentation', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('141', '50', '126', '127', '4', 'com_content.article.91', 'Great job JoomlaShine Team', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('142', '50', '128', '129', '4', 'com_content.article.92', 'Good products', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('143', '50', '130', '131', '4', 'com_content.article.93', 'Excellent support', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('144', '50', '132', '133', '4', 'com_content.article.94', 'After spending a lot of Dollars', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('145', '7', '22', '23', '2', 'com_contact.category.26', 'Contacts', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('146', '3', '6', '7', '2', 'com_banners.category.27', 'Promo', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('147', '42', '52', '53', '4', 'com_content.article.95', 'What is the difference between Archiving and Trashing an Article? ', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('148', '40', '44', '45', '4', 'com_content.article.96', 'Can Joomla! 1.5 operate with PHP Safe Mode On?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('149', '40', '46', '47', '4', 'com_content.article.97', 'How do I install Joomla! 1.5?', '{\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('150', '8', '148', '149', '2', 'com_content.category.1', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('155', '8', '150', '153', '2', 'com_content.category.32', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('156', '8', '154', '171', '2', 'com_content.category.33', 'News', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('157', '156', '155', '158', '3', 'com_content.category.34', 'Latest', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('158', '8', '172', '221', '2', 'com_content.category.35', 'FAQs', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('159', '158', '173', '180', '3', 'com_content.category.36', 'New to Joomla!', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('160', '158', '181', '192', '3', 'com_content.category.37', 'Current Users', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('161', '158', '193', '210', '3', 'com_content.category.38', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('162', '158', '211', '220', '3', 'com_content.category.39', 'Languages', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('163', '8', '222', '247', '2', 'com_content.category.40', 'About Joomla!', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('164', '163', '223', '228', '3', 'com_content.category.41', 'The Project', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('165', '163', '229', '240', '3', 'com_content.category.42', 'The CMS', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('166', '163', '241', '246', '3', 'com_content.category.43', 'The Community', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('167', '8', '248', '301', '2', 'com_content.category.44', 'Template Details', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('168', '167', '249', '256', '3', 'com_content.category.45', 'Design & Features', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('169', '167', '257', '272', '3', 'com_content.category.46', 'Advanced Stuff', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('170', '167', '273', '278', '3', 'com_content.category.47', 'General', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('171', '167', '279', '292', '3', 'com_content.category.48', 'Layout Variations', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('172', '167', '293', '294', '3', 'com_content.category.49', 'Testimonials', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('173', '167', '295', '300', '3', 'com_content.category.50', 'Menu Styles', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('174', '156', '159', '170', '3', 'com_content.category.51', 'Newsflash', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[],\"core.edit.own\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('175', '3', '8', '9', '2', 'com_banners.category.52', 'Uncategorised', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('176', '3', '10', '11', '2', 'com_banners.category.53', 'Promo', '{\"core.create\":[],\"core.delete\":[],\"core.edit\":[],\"core.edit.state\":[]}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('179', '1', '696', '697', '1', 'com_poweradmin', 'poweradmin', '{}');
INSERT INTO `np846_assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES ('180', '1', '698', '699', '1', 'com_imageshow', 'imageshow', '{}');

DROP TABLE IF EXISTS `np846_banners`;
CREATE TABLE `np846_banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `np846_banners` (`id`, `cid`, `type`, `name`, `alias`, `imptotal`, `impmade`, `clicks`, `clickurl`, `state`, `catid`, `description`, `custombannercode`, `sticky`, `ordering`, `metakey`, `params`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `reset`, `created`, `language`) VALUES ('1', '1', '1', 'Product Tour', 'product-tour', '', '372', '12', 'index.php?option=com_content&view=article&id=21&Itemid=199', '1', '53', '', '<a title=\"Product Tour\" target=\"_blank\" href=\"index.php?option=com_content&amp;view=article&amp;id=21&amp;Itemid=199\"><img alt=\"Product Tour\" src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/banners/product-tour.jpg\"/></a>', '', '1', '', '{\"imageurl\":\"images\\/banners\\/product-tour.jpg\",\"width\":\"\",\"height\":\"\",\"alt\":\"\"}', '', '', '1', '', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2011-04-29 00:00:00', '2011-03-29 09:33:42', '*');

DROP TABLE IF EXISTS `np846_banner_clients`;
CREATE TABLE `np846_banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `np846_banner_clients` (`id`, `name`, `contact`, `email`, `extrainfo`, `state`, `checked_out`, `checked_out_time`, `metakey`, `own_prefix`, `metakey_prefix`, `purchase_type`, `track_clicks`, `track_impressions`) VALUES ('1', 'JoomlaShine', 'Administrator', 'admin@joomlashine.com', '', '1', '', '0000-00-00 00:00:00', '', '', '', '-1', '', '');

DROP TABLE IF EXISTS `np846_banner_tracks`;
CREATE TABLE `np846_banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_categories`;
CREATE TABLE `np846_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;

INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('1', '', '', '', '97', '', '', 'system', 'ROOT', 'root', '', '', '1', '', '0000-00-00 00:00:00', '1', '{}', '', '', '', '', '2009-10-18 16:07:09', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('32', '155', '1', '53', '54', '1', 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 02:59:06', '42', '2011-04-01 01:26:39', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('33', '156', '1', '55', '60', '1', 'news', 'com_content', 'News', 'news', '', 'Select a news topic from the list below, then select a news article to read.', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 02:59:51', '42', '2011-04-01 01:26:49', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('34', '157', '33', '56', '57', '2', 'news/latest', 'com_content', 'Latest', 'latest', '', 'The latest news from the Joomla! Team', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:00:44', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('35', '158', '1', '61', '70', '1', 'faqs', 'com_content', 'FAQs', 'faqs', '', 'From the list below choose one of our FAQs topics, then select an FAQ to read. If you have a question which is not in this section, please contact us.', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:01:15', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('36', '159', '35', '62', '63', '2', 'faqs/new-to-joomla', 'com_content', 'New to Joomla!', 'new-to-joomla', '', 'Questions for new users of Joomla!', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:01:54', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('37', '160', '35', '64', '65', '2', 'faqs/current-users', 'com_content', 'Current Users', 'current-users', '', 'Questions that users migrating to Joomla! 1.5 are likely to raise<br />', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:02:14', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('38', '161', '35', '66', '67', '2', 'faqs/general', 'com_content', 'General', 'general', '', 'General questions about the Joomla! CMS', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:02:40', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('39', '162', '35', '68', '69', '2', 'faqs/languages', 'com_content', 'Languages', 'languages', '', 'Questions related to localisation and languages', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:03:02', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('40', '163', '1', '71', '78', '1', 'about-joomla', 'com_content', 'About Joomla!', 'about-joomla', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:03:21', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('41', '164', '40', '72', '73', '2', 'about-joomla/the-project', 'com_content', 'The Project', 'the-project', '', 'General facts about Joomla!<br />', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:03:46', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('42', '165', '40', '74', '75', '2', 'about-joomla/the-cms', 'com_content', 'The CMS', 'the-cms', '', 'Information about the software behind Joomla!<br />', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:04:15', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('43', '166', '40', '76', '77', '2', 'about-joomla/the-community', 'com_content', 'The Community', 'the-community', '', 'About the millions of Joomla! users and Web sites<br />', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:04:36', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('44', '167', '1', '79', '92', '1', 'template-details', 'com_content', 'Template Details', 'template-details', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:04:48', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('45', '168', '44', '80', '81', '2', 'template-details/design-a-features', 'com_content', 'Design & Features', 'design-a-features', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:05:09', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('46', '169', '44', '82', '83', '2', 'template-details/advanced-stuff', 'com_content', 'Advanced Stuff', 'advanced-stuff', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:05:34', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('47', '170', '44', '84', '85', '2', 'template-details/general', 'com_content', 'General', 'general', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:05:54', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('48', '171', '44', '86', '87', '2', 'template-details/layout-variations', 'com_content', 'Layout Variations', 'layout-variations', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:13:39', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('49', '172', '44', '88', '89', '2', 'template-details/testimonials', 'com_content', 'Testimonials', 'testimonials', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:14:03', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('50', '173', '44', '90', '91', '2', 'template-details/menu-styles', 'com_content', 'Menu Styles', 'menu-styles', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:14:58', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('51', '174', '33', '58', '59', '2', 'news/newsflash', 'com_content', 'Newsflash', 'newsflash', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:36:23', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('52', '175', '1', '93', '94', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:53:57', '', '0000-00-00 00:00:00', '', '*');
INSERT INTO `np846_categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`) VALUES ('53', '176', '1', '95', '96', '1', 'promo', 'com_banners', 'Promo', 'promo', '', '', '1', '', '0000-00-00 00:00:00', '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '42', '2011-03-31 03:54:23', '', '0000-00-00 00:00:00', '', '*');

DROP TABLE IF EXISTS `np846_content`;
CREATE TABLE `np846_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `title_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'Deprecated in Joomla! 3.0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `sectionid` int(10) unsigned NOT NULL DEFAULT '0',
  `mask` int(10) unsigned NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `parentid` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8;

INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('1', '', 'Can Joomla! 1.5 operate with PHP Safe Mode On?', 'can-joomla-15-operate-with-php-safe-mode-on', '', '<p>Yes it can! This is a significant security improvement.</p><p>The <em>safe mode</em> limits PHP to be able to perform actions only on files/folders who\'s owner is the same as PHP is currently using (this is usually \'apache\'). As files normally are created either by the Joomla! application or by FTP access, the combination of PHP file actions and the FTP Layer allows Joomla! to operate in PHP Safe Mode.</p>', '', '1', '', '', '38', '2011-03-31 03:16:15', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:16:15', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '7', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('2', '', 'Content Layouts', 'content-layouts', '', '<p>Joomla! provides plenty of flexibility when displaying your Web content. Whether you are using Joomla! for a blog site, news or a Web site for a company, you\'ll find one or more content styles to showcase your information. You can also change the style of content dynamically depending on your preferences. Joomla! calls how a page is laid out a <strong>layout</strong>. Use the guide below to understand which layouts are available and how you might use them. </p> <h2>Content </h2> <p>Joomla! makes it extremely easy to add and display content. All content  is placed where your mainbody tag in your template is located. There are three main types of layouts available in Joomla! and all of them can be customised via parameters. The display and parameters are set in the Menu Item used to display the content your working on. You create these layouts by creating a Menu Item and choosing how you want the content to display.</p> <h3>Blog Layout<br /> </h3> <p>Blog layout will show a listing of all Articles of the selected blog type (Section or Category) in the mainbody position of your template. It will give you the standard title, and Intro of each Article in that particular Category and/or Section. You can customise this layout via the use of the Preferences and Parameters, (See Article Parameters) this is done from the Menu not the Section Manager!</p> <h3>Blog Archive Layout<br /> </h3> <p>A Blog Archive layout will give you a similar output of Articles as the normal Blog Display but will add, at the top, two drop down lists for month and year plus a search button to allow Users to search for all Archived Articles from a specific month and year.</p> <h3>List Layout<br /> </h3> <p>Table layout will simply give you a <em>tabular </em>list<em> </em>of all the titles in that particular Section or Category. No Intro text will be displayed just the titles. You can set how many titles will be displayed in this table by Parameters. The table layout will also provide a filter Section so that Users can reorder, filter, and set how many titles are listed on a single page (up to 50)</p> <h2>Wrapper</h2> <p>Wrappers allow you to place stand alone applications and Third Party Web sites inside your Joomla! site. The content within a Wrapper appears within the primary content area defined by the \"mainbody\" tag and allows you to display their content as a part of your own site. A Wrapper will place an IFRAME into the content Section of your Web site and wrap your standard template navigation around it so it appears in the same way an Article would.</p> <h2>Content Parameters</h2> <p>The parameters for each layout type can be found on the right hand side of the editor boxes in the Menu Item configuration screen. The parameters available depend largely on what kind of layout you are configuring.</p>', '', '1', '', '', '42', '2011-03-31 03:16:46', '42', '', '2011-03-31 03:18:00', '42', '', '0000-00-00 00:00:00', '2011-03-31 03:16:46', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '2', '', '4', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('3', '', 'Docs & Support', 'docs-a-support', '', '<h3>Documentation</h3>
<p>JSN Epic is equipped with very comprehensive documentation package that will help you with template utilization.</p>
<ul>
<li><strong>Quick Start  Video</strong><br /> This video gives you a quick-start describing how to configure the template to make it look exactly like the one on the demo server. </li>
<li><strong>Configuration Manual</strong><br /> This PDF document gives you detailed description of every template feature. You can print and use this document as a reference every time you want to configure your template.</li>
<li><strong>Customization Manual</strong><br /> This PDF document gives you easy-to-understand instruction how to customize template elements to make it suites you or your client.</li>
</ul>
<p class=\"content-center\"><a class=\"link-action\" href=\"http://www.joomlashine.com/joomla-templates/jsn-epic-docs.zip\">Download documentation</a></p>
<hr class=\"line-dots\" />
<h3>Support</h3>
<p>When purchasing our products you are backed up with professional and timely support providing via:</p>
<ul>
<li><strong>Support Forum</strong><br /> 
In the support forum we provide support for everyone who bought the <strong>PRO Edition</strong> of our products. Here you will get support from our support team as well as thousands of active members.</li>
<li><strong>Dedicated Ticket Support</strong><br /> Dedicated Ticket Support is for developers who bought<strong> PRO UNLIMITED Edition </strong>of our products. With ticket support we can investigate the issue in-depth and provide a solution much faster. <strong>12-hour</strong> response time is guaranteed.<br /> One more great benefit is that we provide support for all questions related not only to the product, but also to your Joomla! configuration.</li>
</ul>', '', '1', '', '', '46', '2011-03-31 03:17:26', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:17:26', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '6', '', '', '1', '39', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('4', '', 'Does the PDF icon render pictures and special characters?', 'does-the-pdf-icon-render-pictures-and-special-characters', '', 'Yes! Prior to Joomla! 1.5, only the text values of an Article and only for ISO-8859-1 encoding was allowed in the PDF rendition. With the new PDF library in place, the complete Article including images is rendered and applied to the PDF. The PDF generator also handles the UTF-8 texts and can handle any character sets from any language. The appropriate fonts must be installed but this is done automatically during a language pack installation.', '', '1', '', '', '39', '2011-03-31 03:18:37', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:18:37', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '3', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('5', '', 'Easy to Start', 'easy-to-start', '', '<p>One of the fastest and easiest ways to learn template is to install sample data and start playing with it. JSN Epic provides unique mechanism of installing sample data directly on your current website. Just few steps and the demo website is here.</p>
<h3>Step 1. Find the sample data parameter</h3>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/easy-start/sampledata-step01.png\" border=\"0\" width=\"600\" height=\"200\" alt=\"Run sample data installer\" /></p>
<p>Go to template settings page and click button <strong>\"Install sample data\".</strong></p>
<h3>Step 2. Run sample data installer</h3>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/easy-start/sampledata-step02.png\" border=\"0\" width=\"600\" height=\"350\" alt=\"Download sample data package\" /></p>
<p>Type the Super Administrator login details then click on the button <strong>\"Install sample data\"</strong>. The installation process would start instantly and you would get the website in less than a minute.</p>
<h3>Step 3. Read template documentation and start playing</h3>
<p><strong>Done!</strong> Just 2 simple steps and you have sample data installed.</p>
<p>Now it\'s time to read documentation and play with the template. You can download documentation package for free.</p>
<ul type=\"disc\">
<li><a class=\"link-action\" href=\"http://www.joomlashine.com/joomla-templates/jsn-epic-docs.zip\">Download documentation package</a>.</li>
</ul>', '', '1', '', '', '46', '2011-03-31 03:19:15', '42', '', '2012-06-16 07:05:26', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:19:15', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '', '5', '', '', '1', '68', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('6', '', 'Example Pages and Menu Links', 'example-pages-and-menu-links', '', '<p>This page is an example of content that is <em>Uncategorized</em>; that is, it does not belong to any Section or Category. You will see there is a new Menu in the left column. It shows links to the same content presented in 4 different page layouts.</p><ul><li>Section Blog</li><li>Section Table</li><li> Blog Category</li><li>Category Table</li></ul><p>Follow the links in the <strong>Example Pages</strong> Menu to see some of the options available to you to present all the different types of content included within the default installation of Joomla!.</p><p>This includes Components and individual Articles. These links or Menu Item Types (to give them their proper name) are all controlled from within the <strong><font face=\"courier new,courier\">Menu Manager-&gt;[menuname]-&gt;Menu Items Manager</font></strong>. </p>', '', '1', '', '', '32', '2011-03-31 03:19:47', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:19:47', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('7', '', 'Extensions', 'extensions', '', '<p>Out of the box, Joomla! does a great job of managing the content needed to make your Web site sing. But for many people, the true power of Joomla! lies in the application framework that makes it possible for developers all around the world to create powerful add-ons that are called <strong>Extensions</strong>. An Extension is used to add capabilities to Joomla! that do not exist in the base core code. Here are just some examples of the hundreds of available Extensions:</p>
<ul>
<li>Dynamic form builders</li>
<li>Business or organisational directories</li>
<li>Document management</li>
<li>Image and multimedia galleries</li>
<li>E-commerce and shopping cart engines</li>
<li>Forums and chat software</li>
<li>Calendars</li>
<li>E-mail newsletters</li>
<li>Data collection and reporting tools</li>
<li>Banner advertising systems</li>
<li>Paid subscription services</li>
<li>and many, many, more</li>
</ul>
<p>You can find more examples over at our ever growing <a href=\"http://extensions.joomla.org\" target=\"_blank\" title=\"Joomla! Extensions Directory\">Joomla! Extensions Directory</a>. Prepare to be amazed at the amount of exciting work produced by our active developer community!</p>
<p>A useful guide to the Extension site can be found at:<br /><a href=\"http://extensions.joomla.org/content/view/15/63/\" target=\"_blank\" title=\"Guide to the Joomla! Extension site\">http://extensions.joomla.org/content/view/15/63/</a></p>
<h3>Types of Extensions</h3>
<p>There are five types of extensions:</p>
<ul>
<li>Components</li>
<li>Modules</li>
<li>Templates</li>
<li>Plugins</li>
<li>Languages</li>
</ul>
<p>You can read more about the specifics of these using the links in the Article Index - a Table of Contents (yet another useful feature of Joomla!) - at the top right or by clicking on the <strong>Next </strong>link below.</p>
<hr title=\"Components\" class=\"system-pagebreak\" />
<h3><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/stories/ext_com.png\" border=\"0\" alt=\"Component - Joomla! Extension Directory\" title=\"Component - Joomla! Extension Directory\" width=\"17\" height=\"17\" /> Components</h3>
<p>A Component is the largest and most complex of the Extension types.  Components are like mini-applications that render the main body of the  page. An analogy that might make the relationship easier to understand  would be that Joomla! is a book and all the Components are chapters in  the book. The core Article Component (<span style=\"font-family: \'courier new\', courier;\">com_content</span>), for example, is the  mini-application that handles all core Article rendering just as the  core registration Component (<span style=\"font-family: \'courier new\', courier;\">com_user</span>) is the mini-application  that handles User registration.</p>
<p>Many of Joomla!\'s core features are provided by the use of default Components such as:</p>
<ul>
<li>Contacts</li>
<li>Front Page</li>
<li>News Feeds</li>
<li>Banners</li>
<li>Mass Mail</li>
<li>Polls</li>
</ul>
<p>A Component will manage data, set displays, provide functions, and in general can perform any operation that does not fall under the general functions of the core code.</p>
<p>Components work hand in hand with Modules and Plugins to provide a rich variety of content display and functionality aside from the standard Article and content display. They make it possible to completely transform Joomla! and greatly expand its capabilities.</p>
<hr title=\"Modules\" class=\"system-pagebreak\" />
<h3><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/stories/ext_mod.png\" border=\"0\" alt=\"Module - Joomla! Extension Directory\" title=\"Module - Joomla! Extension Directory\" width=\"17\" height=\"17\" /> Modules</h3>
<p>A more lightweight and flexible Extension used for page rendering is a Module. Modules are used for small bits of the page that are generally  less complex and able to be seen across different Components. To  continue in our book analogy, a Module can be looked at as a footnote  or header block, or perhaps an image/caption block that can be rendered  on a particular page. Obviously you can have a footnote on any page but  not all pages will have them. Footnotes also might appear regardless of  which chapter you are reading. Simlarly Modules can be rendered  regardless of which Component you have loaded.</p>
<p>Modules are like little mini-applets that can be placed anywhere on your site. They work in conjunction with Components in some cases and in others are complete stand alone snippets of code used to display some data from the database such as Articles (Newsflash) Modules are usually used to output data but they can also be interactive form items to input data for example the Login Module or Polls.</p>
<p>Modules can be assigned to Module positions which are defined in your Template and in the back-end using the Module Manager and editing the Module Position settings. For example, \"left\" and \"right\" are common for a 3 column layout.</p>
<h4>Displaying Modules</h4>
<p>Each Module is assigned to a Module position on your site. If you wish it to display in two different locations you must copy the Module and assign the copy to display at the new location. You can also set which Menu Items (and thus pages) a Module will display on, you can select all Menu Items or you can pick and choose by holding down the control key and selecting multiple locations one by one in the Modules [Edit] screen</p>
<p>Note: Your Main Menu is a Module! When you create a new Menu in the Menu Manager you are actually copying the Main Menu Module (<span style=\"font-family: \'courier new\', courier;\">mod_mainmenu</span>) code and giving it the name of your new Menu. When you copy a Module you do not copy all of its parameters, you simply allow Joomla! to use the same code with two separate settings.</p>
<h4>Newsflash Example</h4>
<p>Newsflash is a Module which will display Articles from your site in an assignable Module position. It can be used and configured to display one Category, all Categories, or to randomly choose Articles to highlight to Users. It will display as much of an Article as you set, and will show a <em>Read more...</em> link to take the User to the full Article.</p>
<p>The Newsflash Component is particularly useful for things like Site News or to show the latest Article added to your Web site.</p>
<hr title=\"Plugins\" class=\"system-pagebreak\" />
<h3><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/stories/ext_plugin.png\" border=\"0\" alt=\"Plugin - Joomla! Extension Directory\" title=\"Plugin - Joomla! Extension Directory\" width=\"17\" height=\"17\" /> Plugins</h3>
<p>One  of the more advanced Extensions for Joomla! is the Plugin. In previous  versions of Joomla! Plugins were known as Mambots. Aside from changing their name their  functionality has been expanded. A Plugin is a section of code that  runs when a pre-defined event happens within Joomla!. Editors are Plugins, for example, that execute when the Joomla! event <span style=\"font-family: \'courier new\', courier;\">onGetEditorArea</span> occurs. Using a Plugin allows a developer to change  the way their code behaves depending upon which Plugins are installed  to react to an event.</p>
<hr title=\"Languages\" class=\"system-pagebreak\" />
<h3><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/stories/ext_lang.png\" border=\"0\" alt=\"Language - Joomla! Extensions Directory\" title=\"Language - Joomla! Extensions Directory\" width=\"17\" height=\"17\" /> Languages</h3>
<p>New  to Joomla! 1.5 and perhaps the most basic and critical Extension is a Language. Joomla! is released with multiple Installation Languages but the base Site and Administrator are packaged in just the one Language <strong>en-GB</strong> - being English with GB spelling for example. To include all the translations currently available would bloat the core package and make it unmanageable for uploading purposes. The Language files enable all the User interfaces both Front-end and Back-end to be presented in the local preferred language. Note these packs do not have any impact on the actual content such as Articles.</p>
<p>More information on languages is available from the <br /> <a href=\"http://community.joomla.org/translations.html\" target=\"_blank\" title=\"Joomla! Translation Teams\">http://community.joomla.org/translations.html</a></p>', '', '1', '', '', '42', '2011-03-31 03:20:22', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:20:22', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '3', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('8', '', 'Image Gallery', 'flash-gallery', '', '<p>The image gallery you see on this website is another cool product <strong><a href=\"http://www.joomlashine.com/joomla-extensions/jsn-imageshow.html\" target=\"_blank\">JSN ImageShow</a></strong> from JoomlaShine.com. This product is shipped with component, module and content plugin, so you can place it anywhere on every website.</p>
<p>On this page you can see how JSN ImageShow is presented as module on top and as plugin in article content.  With flash technology applied, you get smooth experience and consistent performance in all browsers.</p>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/flash-gallery/flash-gallery-preview.png\" border=\"0\" alt=\"JSN ImageShow preview\" width=\"638\" height=\"500\" />
</p>
<p class=\"content-center\"><em>JSN ImageShow presented as plugin article content</em></p>
<h3>Mobile optimized</h3>
<p>For mobile device, we have built special lightweight Javascript version, so you can be absolutely sure about images presentation.</p>

<div class=\"grid-layout\">
<div>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/flash-gallery/flash-gallery.png\" width=\"320\" height=\"480\" alt=\"Mobile optimized presentation (screenshot made by iPhone 3GS)\" /></p>
</div>
<div>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/flash-gallery/flash-gallery-iphone.png\" width=\"320\" height=\"480\" alt=\"Mobile optimized presentation in active mode (screenshot made by iPhone 3GS)\" /> </p>
</div>
   <p class=\"content-center\"><em>Mobile optimized presentation (screenshot made by iPhone 3GS)</em></p>
</div>

<p class=\"text-info\">This extension is NOT included in the template package, but you can download it for free. <a href=\"http://www.joomlashine.com/joomla-extensions/jsn-imageshow.html\" class=\"link-action\">Read more</a>.</p>', '', '1', '', '', '46', '2011-03-31 03:20:55', '42', '', '2012-06-18 03:02:24', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:20:55', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '', '4', '', '', '1', '12', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('9', '', 'Flash Gallery Alternative', 'flash-gallery-alternative', '', '<a href=\"http://www.joomlashine.com/joomla-extensions/jsn-imageshow.html\" target=\"_blank\" style=\"display: block; height: 300px; background: url(http://demo.joomlashine.com/joomla-templates/jsn_epic/images/extensions/custom-html/jsn-imageshow-promo/jsn-imageshow-promo.jpg) center center no-repeat;\"></a>', '', '-2', '', '', '46', '2011-03-31 03:21:24', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:21:24', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '3', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('10', '', 'How do I install Joomla! 1.5?', 'how-do-i-install-joomla-15', '', '<p>Installing of Joomla! 1.5 is pretty easy. We assume you have set-up your Web site, and it is accessible with your browser.<br /><br />Download Joomla! 1.5, unzip it and upload/copy the files into the directory you Web site points to, fire up your browser and enter your Web site address and the installation will start.  </p><p>For full details on the installation processes check out the <a href=\"http://help.joomla.org/content/category/48/268/302\" target=\"_blank\" title=\"Joomla! 1.5 Installation Manual\">Installation Manual</a> on the <a href=\"http://help.joomla.org\" target=\"_blank\" title=\"Joomla! Help Site\">Joomla! Help Site</a> where you will also find download instructions for a PDF version too. </p>', '', '1', '', '', '38', '2011-03-31 03:21:58', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:21:58', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '6', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('11', '', 'How do I localise Joomla! to my language?', 'how-do-i-localise-joomla-to-my-language', '', '<h4>General<br /></h4><p>In Joomla! 1.5 all User interfaces can be localised. This includes the installation, the Back-end Control Panel and the Front-end Site.</p><p>The core release of Joomla! 1.5 is shipped with multiple language choices in the installation but, other than English (the default), languages for the Site and Administration interfaces need to be added after installation. Links to such language packs exist below.</p>', '<p>Translation Teams for Joomla! 1.5 may have also released fully localised installation packages where site, administrator and sample data are in the local language. These localised releases can be found in the specific team projects on the <a href=\"http://extensions.joomla.org/component/option,com_mtree/task,listcats/cat_id,1837/Itemid,35/\" target=\"_blank\" title=\"JED\">Joomla! Extensions Directory</a>.</p><h4>How do I install language packs?</h4><ul><li>First download both the admin and the site language packs that you require.</li><li>Install each pack separately using the Extensions-&gt;Install/Uninstall Menu selection and then the package file upload facility.</li><li>Go to the Language Manager and be sure to select Site or Admin in the sub-menu. Then select the appropriate language and make it the default one using the Toolbar button.</li></ul><h4>How do I select languages?</h4><ul><li>Default languages can be independently set for Site and for Administrator</li><li>In addition, users can define their preferred language for each Site and Administrator. This takes affect after logging in.</li><li>While logging in to the Administrator Back-end, a language can also be selected for the particular session.</li></ul><h4>Where can I find Language Packs and Localised Releases?</h4><p><em>Please note that Joomla! 1.5 is new and language packs for this version may have not been released at this time.</em> </p><ul><li><a href=\"http://joomlacode.org/gf/project/jtranslation/\" target=\"_blank\" title=\"Accredited Translations\">The Joomla! Accredited Translations Project</a>  - This is a joint repository for language packs that were developed by teams that are members of the Joomla! Translations Working Group.</li><li><a href=\"http://extensions.joomla.org/component/option,com_mtree/task,listcats/cat_id,1837/Itemid,35/\" target=\"_blank\" title=\"Translations\">The Joomla! Extensions Site - Translations</a>  </li><li><a href=\"http://community.joomla.org/translations.html\" target=\"_blank\" title=\"Translation Work Group Teams\">List of Translation Teams and Translation Partner Sites for Joomla! 1.5</a> </li></ul>', '1', '', '', '39', '2011-03-31 03:22:32', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:22:32', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '2', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('12', '', 'How do I remove an Article?', 'how-do-i-remove-an-article', '', '<p>To completely remove an Article, select the Articles that you want to delete and move them to the Trash. Next, open the Article Trash in the Content Menu and select the Articles you want to delete. After deleting an Article, it is no longer available as it has been deleted from the database and it is not possible to undo this operation.  </p>', '', '1', '', '', '36', '2011-03-31 03:23:08', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:23:08', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '2', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('13', '', 'How do I upgrade to Joomla! 1.5 ?', 'how-do-i-upgrade-to-joomla-15-', '', '<p>Joomla! 1.5 does not provide an upgrade path from earlier versions. Converting an older site to a Joomla! 1.5 site requires creation of a new empty site using Joomla! 1.5 and then populating the new site with the content from the old site. This migration of content is not a one-to-one process and involves conversions and modifications to the content dump.</p> <p>There are two ways to perform the migration:</p>', ' <div id=\"post_content-107\"><li>An automated method of migration has been provided which uses a migrator Component to create the migration dump out of the old site (Mambo 4.5.x up to Joomla! 1.0.x) and a smart import facility in the Joomla! 1.5 Installation that performs required conversions and modifications during the installation process.</li> <li>Migration can be performed manually. This involves exporting the required tables, manually performing required conversions and modifications and then importing the content to the new site after it is installed.</li>  <p></p> <h2><strong> Automated migration</strong></h2>  <p>This is a two phased process using two tools. The first tool is a migration Component named <font face=\"courier new,courier\">com_migrator</font>. This Component has been contributed by Harald Baer and is based on his <strong>eBackup </strong>Component. The migrator needs to be installed on the old site and when activated it prepares the required export dump of the old site\'s data. The second tool is built into the Joomla! 1.5 installation process. The exported content dump is loaded to the new site and all conversions and modification are performed on-the-fly.</p> <h3><u> Step 1 - Using com_migrator to export data from old site:</u></h3> <li>Install the <font face=\"courier new,courier\">com_migrator</font> Component on the <u><strong>old</strong></u> site. It can be found at the <a href=\"http://joomlacode.org/gf/project/pasamioprojects/frs/\" target=\"_blank\" title=\"JoomlaCode\">JoomlaCode developers forge</a>.</li> <li>Select the Component in the Component Menu of the Control Panel.</li> <li>Click on the <strong>Dump it</strong> icon. Three exported <em>gzipped </em>export scripts will be created. The first is a complete backup of the old site. The second is the migration content of all core elements which will be imported to the new site. The third is a backup of all 3PD Component tables.</li> <li>Click on the download icon of the particular exports files needed and store locally.</li> <li>Multiple export sets can be created.</li> <li>The exported data is not modified in anyway and the original encoding is preserved. This makes the <font face=\"courier new,courier\">com_migrator</font> tool a recommended tool to use for manual migration as well.</li> <h3><u> Step 2 - Using the migration facility to import and convert data during Joomla! 1.5 installation:</u></h3><p>Note: This function requires the use of the <em><font face=\"courier new,courier\">iconv </font></em>function in PHP to convert encodings. If <em><font face=\"courier new,courier\">iconv </font></em>is not found a warning will be provided.</p> <li>In step 6 - Configuration select the \'Load Migration Script\' option in the \'Load Sample Data, Restore or Migrate Backed Up Content\' section of the page.</li> <li>Enter the table prefix used in the content dump. For example: \'jos_\' or \'site2_\' are acceptable values.</li> <li>Select the encoding of the dumped content in the dropdown list. This should be the encoding used on the pages of the old site. (As defined in the _ISO variable in the language file or as seen in the browser page info/encoding/source)</li> <li>Browse the local host and select the migration export and click on <strong>Upload and Execute</strong></li> <li>A success message should appear or alternately a listing of database errors</li> <li>Complete the other required fields in the Configuration step such as Site Name and Admin details and advance to the final step of installation. (Admin details will be ignored as the imported data will take priority. Please remember admin name and password from the old site)</li> <p><u><br /></u></p></div>', '1', '', '', '37', '2011-03-31 03:23:37', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:23:37', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '4', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('14', '', 'I installed with my own language, but the Back-end is still in English', 'i-installed-with-my-own-language-but-the-back-end-is-still-in-english', '', '<p>A lot of different languages are available for the Back-end, but by default this language may not be installed. If you want a translated Back-end, get your language pack and install it using the Extension Installer. After this, go to the Extensions Menu, select Language Manager and make your language the default one. Your Back-end will be translated immediately.</p><p>Users who have access rights to the Back-end may choose the language they prefer in their Personal Details parameters. This is of also true for the Front-end language.</p><p> A good place to find where to download your languages and localised versions of Joomla! is <a href=\"http://extensions.joomla.org/index.php?option=com_mtree&task=listcats&cat_id=1837&Itemid=35\" target=\"_blank\" title=\"Translations for Joomla!\">Translations for Joomla!</a> on JED.</p>', '', '1', '', '', '39', '2011-03-31 03:24:07', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:24:07', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('15', '', 'Introducing JSN Epic', 'introducing-jsn-epic', '', '<p>JSN Epic is polished, clean looking template designed mainly for corporate websites. Equipped with powerful features this template allows you to present content in whatever way you like. <a href=\"index.php?option=com_content&amp;view=article&amp;id=22&amp;Itemid=183\">Super flexible layout</a>, <a href=\"index.php?option=com_content&amp;view=article&amp;id=30&amp;Itemid=190\">3 menu styles</a> and <a href=\"index.php?option=com_content&amp;view=article&amp;id=31&amp;Itemid=193\">4 modules styles</a> under your management via convenient <a href=\"index.php?option=com_content&amp;view=article&amp;id=39&amp;Itemid=173\">template parameters</a>.</p>
<p>JSN Epic is distributed in 2 editions: <strong>Free</strong> and <strong>PRO</strong>. This website demonstrates JSN Epic Free edition. For full details about all template features, please <a href=\"http://www.joomlashine.com/joomla-templates/jsn-epic-docs.zip\">download template documentation</a>.</p>
<p class=\"content-center\">
<a href=\"index.php?option=com_content&amp;view=article&amp;id=21&amp;Itemid=199\" class=\"link-action\">Take a quick tour</a></p>
', '', '1', '', '', '47', '2011-03-31 03:25:00', '42', '', '2011-07-11 03:26:41', '42', '', '0000-00-00 00:00:00', '2011-03-31 03:25:00', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"0\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '10', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '1', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('16', '', 'Is it possible to change A Menu Item\'s Type?', 'is-it-possible-to-change-a-menu-items-type', '', '<p>You indeed can change the Menu Item\'s Type to whatever you want, even after they have been created. </p><p>If, for instance, you want to change the Blog Section of a Menu link, go to the Control Panel-&gt;Menus Menu-&gt;[menuname]-&gt;Menu Item Manager and edit the Menu Item. Select the <strong>Change Type</strong> button and choose the new style of Menu Item Type from the available list. Thereafter, alter the Details and Parameters to reconfigure the display for the new selection  as you require it.</p>', '', '1', '', '', '38', '2011-03-31 03:25:29', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:25:29', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '5', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('17', '', 'Is it useful to install the sample data?', 'is-it-useful-to-install-the-sample-data', '', 'Well you are reading it right now! This depends on what you want to achieve. If you are new to Joomla! and have no clue how it all fits together, just install the sample data. If you don\'t like the English sample data because you - for instance - speak Chinese, then leave it out.', '', '1', '', '', '36', '2011-03-31 03:26:01', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:26:01', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('18', '', 'Joomla! Facts', 'joomla-facts', '', '<p>Here are some interesting facts about Joomla!</p><ul><li><span>Over 210,000 active registered Users on the <a href=\"http://forum.joomla.org\" target=\"_blank\" title=\"Joomla Forums\">Official Joomla! community forum</a> and more on the many international community sites.</span><ul><li><span>over 1,000,000 posts in over 200,000 topics</span></li><li>over 1,200 posts per day</li><li>growing at 150 new participants each day!</li></ul></li><li><span>1168 Projects on the JoomlaCode (<a href=\"http://joomlacode.org/\" target=\"_blank\" title=\"JoomlaCode\">joomlacode.org</a> ). All for open source addons by third party developers.</span><ul><li><span>Well over 6,000,000 downloads of Joomla! since the migration to JoomlaCode in March 2007.<br /></span></li></ul></li><li><span>Nearly 4,000 extensions for Joomla! have been registered on the <a href=\"http://extensions.joomla.org\" target=\"_blank\" title=\"http://extensions.joomla.org\">Joomla! Extension Directory</a>  </span></li><li><span>Joomla.org exceeds 2 TB of traffic per month!</span></li></ul>', '', '1', '', '', '43', '2011-03-31 03:26:33', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:26:33', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('19', '', 'Joomla! Features', 'joomla-features', '', '<h4><font color=\"#ff6600\">Joomla! features:</font></h4> <ul><li>Completely database driven site engines </li><li>News, products, or services sections fully editable and manageable</li><li>Topics sections can be added to by contributing Authors </li><li>Fully customisable layouts including <em>left</em>, <em>center</em>, and <em>right </em>Menu boxes </li><li>Browser upload of images to your own library for use anywhere in the site </li><li>Dynamic Forum/Poll/Voting booth for on-the-spot results </li><li>Runs on Linux, FreeBSD, MacOSX server, Solaris, and AIX', '  </li></ul> <h4>Extensive Administration:</h4> <ul><li>Change order of objects including news, FAQs, Articles etc. </li><li>Random Newsflash generator </li><li>Remote Author submission Module for News, Articles, FAQs, and Links </li><li>Object hierarchy - as many Sections, departments, divisions, and pages as you want </li><li>Image library - store all your PNGs, PDFs, DOCs, XLSs, GIFs, and JPEGs online for easy use </li><li>Automatic Path-Finder. Place a picture and let Joomla! fix the link </li><li>News Feed Manager. Easily integrate news feeds into your Web site.</li><li>E-mail a friend and Print format available for every story and Article </li><li>In-line Text editor similar to any basic word processor software </li><li>User editable look and feel </li><li>Polls/Surveys - Now put a different one on each page </li><li>Custom Page Modules. Download custom page Modules to spice up your site </li><li>Template Manager. Download Templates and implement them in seconds </li><li>Layout preview. See how it looks before going live </li><li>Banner Manager. Make money out of your site.</li></ul>', '1', '', '', '42', '2011-03-31 03:27:06', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:27:06', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '2', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('20', '', 'Joomla! Overview', 'joomla-overview', '', '<p>If you\'re new to Web publishing systems, you\'ll find that Joomla! delivers sophisticated solutions to your online needs. It can deliver a robust enterprise-level Web site, empowered by endless extensibility for your bespoke publishing needs. Moreover, it is often the system of choice for small business or home users who want a professional looking site that\'s simple to deploy and use. <em>We do content right</em>.<br /> </p><p>So what\'s the catch? How much does this system cost?</p><p> Well, there\'s good news ... and more good news! Joomla! 1.5 is free, it is released under an Open Source license - the GNU/General Public License v 2.0. Had you invested in a mainstream, commercial alternative, there\'d be nothing but moths left in your wallet and to add new functionality would probably mean taking out a second mortgage each time you wanted something adding!</p><p>Joomla! changes all that ... <br />Joomla! is different from the normal models for content management software. For a start, it\'s not complicated. Joomla! has been developed for everybody, and anybody can develop it further. It is designed to work (primarily) with other Open Source, free, software such as PHP, MySQL, and Apache. </p><p>It is easy to install and administer, and is reliable. </p><p>Joomla! doesn\'t even require the user or administrator of the system to know HTML to operate it once it\'s up and running.</p><p>To get the perfect Web site with all the functionality that you require for your particular application may take additional time and effort, but with the Joomla! Community support that is available and the many Third Party Developers actively creating and releasing new Extensions for the 1.5 platform on an almost daily basis, there is likely to be something out there to meet your needs. Or you could develop your own Extensions and make these available to the rest of the community. </p>', '', '1', '', '', '42', '2011-03-31 03:27:39', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:27:39', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('21', '', 'JSN Epic Product Tour', 'jsn-epic-product-tour', '', '<div style=\"padding: 3em 0\">
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/general/product-tour/slide-easy-start.jpg\" width=\"770\" height=\"520\" alt=\"Easy to Start\" /></p>
<p>One of the fastest and easiest ways to learn template is to install sample data and start playing with it. JSN Epic provides unique mechanism of <strong>installing sample data directly on your current website</strong>. Just few steps and the demo website is here. <a href=\"index.php?option=com_content&amp;view=article&amp;id=5&amp;Itemid=172\" class=\"link-action\">More about easy start</a></p>
</div>
<hr class=\"line-dots\" />
<div style=\"padding: 3em 0\">
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/general/product-tour/slide-configuration.jpg\" width=\"770\" height=\"520\" alt=\"Painless Configuration\" /></p>
<p>All JoomlaShine templates can be effortlessly configured by template parameters. In template setting page, you will find <strong>16 template parameters</strong> arranged into logical groups for convenient operation. All parameters are equipped with description text for easier understanding. <a href=\"index.php?option=com_content&amp;view=article&amp;id=39&amp;Itemid=173\" class=\"link-action\">More about configuration</a></p>
</div>
<hr class=\"line-dots\" />
<div style=\"padding: 3em 0\">
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/general/product-tour/slide-layout.jpg\" width=\"770\" height=\"520\" alt=\"Flexible layout\" /></p>
<p>JSN Epic provides <strong>36 module positions </strong>allowing you to have multiple layout configurations. Module positions are designed in smart way to cover all possible spot where you might want to put content. You can specify width of both overall layout and specific columns conveniently via template parameters. <a href=\"index.php?option=com_content&amp;view=article&amp;id=22&amp;Itemid=183\" class=\"link-action\">More about layout</a></p>
</div>
<hr class=\"line-dots\" />
<div style=\"padding: 3em 0\">
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/general/product-tour/slide-menu-styles.jpg\" width=\"770\" height=\"520\" alt=\"Menu Styles\" /></p>
<p>JSN Epic Free edition provides <strong>3 menu styles</strong> to present your website navigation. The default Joomla! built-in menu module <strong>(mod_mainmenu)</strong> is utilized, so you don\'t need to install any external menu modules. <a href=\"index.php?option=com_content&amp;view=article&amp;id=30&amp;Itemid=190\" class=\"link-action\">More about menu styles</a></p>
</div>
<hr class=\"line-dots\" />
<div style=\"padding: 3em 0\">
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/general/product-tour/slide-rtl-support.jpg\" width=\"770\" height=\"520\" alt=\"RTL Support\" /></p>
<p>All JoomlaShine templates are equipped with <strong>native RTL layout support</strong>. We spent huge amount of time tweaking every tiny details of the template to make it look absolutely awesome in RTL mode. Everything is horizontally-flipped including dropdown main menu and side menu. <a href=\"index.php?option=com_content&amp;view=article&amp;id=41&amp;Itemid=174\" class=\"link-action\">More about RTL support</a></p>
</div>

<hr class=\"line-dots\" />
<div style=\"padding: 3em 0\">
<div style=\"width: 770px; height: 520px; margin: 0 auto; background: url(http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/general/product-tour/slide-flash-gallery.jpg) no-repeat;\">
<div style=\"padding: 70px 25px;\">
{imageshow sl=2 sc=2 w=650 h=400 /}
</div></div>
<p>The image gallery you see on this website is another cool product <strong>JSN ImageShow</strong> from JoomlaShine.com. With flash technology applied, you get smooth experience and consistent performance in all browsers.</p>
<p>For mobile device, we have built special lightweight Javascript version, so you can be absolutely sure about images presentation.</p>
<p class=\"content-center\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=8&amp;Itemid=175\" class=\"link-button button-light\"><span class=\"link-icon icon-info\">More about image gallery</span></a></p>
</div>

<hr class=\"line-dots\" />
<div style=\"padding: 3em 0\">
<div style=\"width: 770px; height: 520px; margin: 0 auto; background: url(http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/general/product-tour/slide-docs-support.jpg) no-repeat;\">
<div style=\"padding: 60px 25px;\">
<div class=\"grid-layout\">
<div style=\"width: 49%; float: left\">
<h3>Documentation</h3>
<p>JSN Epic is equipped with very comprehensive documentation package that will help you with template utilization.</p>
<ul>
<li><strong>Quick Start  Video</strong><br /> This video gives you a quick-start describing how to configure the template to make it look exactly like the one on the demo server. </li>
<li><strong>Configuration Manual</strong><br /> This PDF document gives you detailed description of every template feature. You can print and use this document as a reference every time you want to configure your template.</li>
<li><strong>Customization Manual</strong><br /> This PDF document gives you easy-to-understand instruction how to customize template elements to make it suites you or your client.</li>
</ul>
</div>
<div style=\"width: 49%; float: right\">
<h3>Support</h3>
<p>When purchasing our products you are backed up with professional and timely support providing via:</p>
<ul>
<li><strong>Support Forum</strong><br /> 
In the support forum we provide support for everyone who bought the <strong>PRO Edition</strong> of our products. Here you will get support from our support team as well as thousands of active members.</li>
<li><strong>Dedicated Ticket Support</strong><br /> Dedicated Ticket Support is for developers who bought<strong> PRO UNLIMITED Edition </strong>of our products. With ticket support we can investigate the issue in-depth and provide a solution much faster. <strong>12-hour</strong> response time is guaranteed.</li>
</ul>
</div>
</div>
<p class=\"content-center clearbreak\"><a class=\"link-action\" href=\"http://www.joomlashine.com/joomla-templates/jsn-epic-docs.zip\">Download documentation</a></p>
<hr class=\"line-dots\" />
</div>
</div>
</div>', '', '1', '', '', '47', '2011-03-31 03:28:25', '42', '', '2012-07-26 11:27:24', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:28:25', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '16', '', '', '', '', '1', '167', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('22', '', 'Layout', 'layout', '', '<h3>Module Positions</h3>
<p>JSN Epic provides <strong>36 module positions</strong> allowing you to have multiple layout configurations. All module positions are collapsible which means if you don\'t publish any modules in some position it will not take any blank spaces leaving those for neighbor modules. Some positions are designed to arrange modules inside in horizontal layout which makes it very easy to reorder modules inside it.</p>
<ul><li><a href=\"images/content/template-details/design-features/layout/layout-full.png\" target=\"_blank\" class=\"link-action\">See all module positions outline</a></li></ul>
<hr class=\"line-dots\" />
<h3>Layout Configuration</h3>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/design-features/layout/params-layout.png\" width=\"600\" height=\"390\" alt=\"Layout configuration by template parameters\" /></p>
<p>JSN Epic allows you to change the width size for several critical layout elements. All settings can be done via template parameters in section <strong>LAYOUT SETTINGS</strong>.</p>
<hr class=\"line-dots\" />
<h3>Layout Variations</h3>
<p>JSN Epic layout system is very flexible and capable. Module positions are designed in smart way to cover all possible spot where you might want to put content. More over, you can specify width of both overall layout and specific columns conveniently via template parameters. Bellow is live presentation of some most popular layout variations:</p>
<div class=\"grid-layout\" style=\"margin-top: 10px\">
<div class=\"content-center\">
    <a href=\"index.php?option=com_content&view=article&id=92&Itemid=477\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-mc.png\" width=\"160\" height=\"90\" alt=\"Main content only\" /><br />Main content only</a>
</div>
<div class=\"content-center\">
    <a href=\"index.php?option=com_content&view=article&id=89&Itemid=474\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-lcir.png\" width=\"160\" height=\"90\" alt=\"Left | Center | InnerRight\" /><br />Left | Center | InnerRight</a>
</div>
<div class=\"content-center\">
    <a href=\"index.php?option=com_content&view=article&id=91&Itemid=473\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-lilc.png\" width=\"160\" height=\"90\" alt=\"Left | Center | InnerRight\" /><br />Left | InnerLeft | Center</a>
</div>
</div>
<div class=\"grid-layout\" style=\"margin-top: 10px\">
<div class=\"content-center\">
    <a href=\"index.php?option=com_content&view=article&id=90&Itemid=472\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-lcr.png\" width=\"160\" height=\"90\" alt=\"Left | Center | Right\" /><br />Left | Center | Right</a>
    </div>
<div class=\"content-center\">
    <a href=\"index.php?option=com_content&view=article&id=88&Itemid=476\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-ilcr.png\" width=\"160\" height=\"90\" alt=\"Left | Center | Right\" /><br />InnerLeft | Center | Right</a>
</div>
<div class=\"content-center\">
    <a href=\"index.php?option=com_content&view=article&id=87&Itemid=475\" class=\"link-highlight\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/extensions/custom-html/layout-variations/layout-thumb-cirr.png\" width=\"160\" height=\"90\" alt=\"Left | Center | Right\" /><br />Center | InnerRight | Right</a>
</div>
</div>', '', '1', '', '', '45', '2011-03-31 03:28:55', '42', '', '2012-07-30 04:49:29', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:28:55', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '12', '', '2', '', '', '1', '147', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('23', '', 'Layout variation Center | Innerright | Right ', 'layout-variation-center-innerright-right', '', '<p>This is  3 columns layout with content presented on the left side, which is typical for blog sites. On right side columns you can  present modules with sumplementary information for main content. The width of side columns can be  adjusted conveniently via template parameters.</p>
<ul>
  <li><a href=\"images/content/template-details/design-features/layout/layout-full.png\" target=\"_blank\" class=\"link-action\">See all module positions outline</a></li>
</ul>
', '', '1', '', '', '48', '2011-03-31 03:29:25', '42', '', '2012-07-24 10:20:20', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:29:25', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '6', '', '4', '', '', '1', '28', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('24', '', 'Layout variation Innerleft | Center | Right ', 'layout-variation-innerleft-center-right', '', '<p>This is also 3 columns layout with content presented at center, but the left side column was designed to present content of secondary importance comparing to those in right side column. On side columns you can present modules with equal importance. The width of side columns can be adjusted conveniently via template parameters.</p>
<ul>
  <li><a href=\"images/content/template-details/design-features/layout/layout-full.png\" target=\"_blank\" class=\"link-action\">See all module positions outline</a></li>
</ul>
', '', '1', '', '', '48', '2011-03-31 03:29:57', '42', '', '2012-07-24 10:20:28', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:29:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '', '3', '', '', '1', '29', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('25', '', 'Layout variation Left | Center | Innerright ', 'layout-variation-left-center-innerright', '', '<p>This is also 3 columns layout with content presented at center, but the right side column was designed to present content of secondary importance comparing to those in left side column. On side columns you can present modules with equal importance. The width of side columns can be adjusted conveniently via template parameters.</p>
<ul>
  <li><a href=\"images/content/template-details/design-features/layout/layout-full.png\" target=\"_blank\" class=\"link-action\">See all module positions outline</a></li>
</ul>
', '', '1', '', '', '48', '2011-03-31 03:30:25', '42', '', '2012-07-24 10:20:37', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:30:25', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '', '2', '', '', '1', '30', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('26', '', 'Layout variation Left | Center | Right', 'layout-variation-left-center-right', '', '<p>This is pretty &ldquo;old-fashioned&rdquo; 3 columns layout with content presented at center. On side columns you can present modules with equal importance. The width of side columns can be adjusted conveniently via template parameters.</p>
<ul><li><a href=\"images/content/template-details/design-features/layout/layout-full.png\" target=\"_blank\" class=\"link-action\">See all module positions outline</a></li></ul>
', '', '1', '', '', '48', '2011-03-31 03:30:55', '42', '', '2012-07-24 10:20:46', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:30:55', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '', '1', '', '', '1', '79', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('27', '', 'Layout variation Left | Innerleft | Center', 'layout-variation-left-innerleft-center', '', '<p>This is  3 columns layout with content presented on the right side, which is typical for blog sites. On left side columns you can  present modules with sumplementary information for main content. The width of side columns can be  adjusted conveniently via template parameters.</p>
<ul>
  <li><a href=\"images/content/template-details/design-features/layout/layout-full.png\" target=\"_blank\" class=\"link-action\">See all module positions outline</a></li>
</ul>
', '', '1', '', '', '48', '2011-03-31 03:31:23', '42', '', '2012-07-24 10:20:55', '43', '', '0000-00-00 00:00:00', '2011-03-31 03:31:23', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '4', '', '', '', '', '1', '29', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('28', '', 'Main content only', 'main-content-only', '', '<p>Here you can see how content are presented only in main content area. Sometimes, you will need a lot of space to present content and that how it will looks like.</p>
<ul><li><a href=\"images/content/template-details/design-features/layout/layout-full.png\" target=\"_blank\" class=\"link-action\">See all module positions outline</a></li></ul>
<h3>RTL Layout</h3>
<p>All JoomlaShine templates are equipped with RTL layout support. We spent huge amount of time tweaking every tiny details of the template to make it look absolutely awesome in RTL mode. Everything is horizontally-flipped including dropdown main menu and side menu.</p>
<ul>
 <li><a href=\"index.php?option=com_content&amp;view=article&amp;id=28&amp;Itemid=189&amp;jsn_setdirection=rtl\" class=\"link-action\">Switch to RTL layout</a></li>
 <li><a href=\"index.php?option=com_content&amp;view=article&amp;id=28&amp;Itemid=189&amp;jsn_setdirection=ltr\" class=\"link-action\">Switch to Normal layout</a></li>
</ul>', '', '1', '', '', '48', '2011-03-31 03:31:50', '42', '', '2011-07-11 03:45:30', '42', '', '0000-00-00 00:00:00', '2011-03-31 03:31:50', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '4', '', '', '', '', '1', '24', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('29', '', 'Main Menu', 'main-menu', '', '<p>Main Menu is very powerful menu built with clean accessible XHTML code structure and effective drop-down submenu panels.</p>
<h3>Main Menu Rich Text</h3>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/menu-styles/mainmenu/menu-mainmenu-rich.png\" alt=\"Main Menu Rich Text\" width=\"600\" height=\"175\" border=\"0\" /></p>
<p>You can add descriptive text to menu items to make them much clearer.</p>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/menu-styles/mainmenu/menu-mainmenu-rich-settings-j16.png\" alt=\"Main Menu Rich Text Settings\" width=\"600\" height=\"300\" border=\"0\" /></p>
<p>To set up descriptive text, you need to go to menu item settings and add descriptive text to menu items parameter <strong>Link Title Attribute</strong>.</p>', '', '1', '', '', '50', '2011-03-31 03:32:21', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:32:21', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '70', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('30', '', 'Menu Styles', 'menu-styles', '', '<p>JSN Epic provides <strong>3 menu styles </strong>to present your website navigation. The default Joomla! built-in menu module <strong>(mod_mainmenu)</strong> is utilized, so you don\'t need to install any external menu modules.</p>
<h3>Main Menu</h3>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/design-features/menu-styles/menu-mainmenu-submenus.png\" alt=\"Main Menu\" width=\"600\" height=\"300\" border=\"0\" /></p>
<p>Main Menu is very powerful menu built with clean accessible XHTML code structure and effective drop-down submenu panels.</p>
<h4>Main Menu with rich text</h4>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/design-features/menu-styles/menu-mainmenu-rich.png\" alt=\"Main Menu with rich text\" width=\"600\" height=\"175\" border=\"0\" /></p>
<p>You can add icon and descriptive text to each menu item to make them much clearer and more  appealing. Both descriptive text and icons are configured directly in menu item settings page, which is very convenient.</p>
<p class=\"content-center\"><span class=\"link-button button-light\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=29&amp;Itemid=191\" class=\"link-action\">See live demo of Main Menu</a></span></p>
<hr class=\"line-dots\" />
<h3>Tree Menu</h3>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/design-features/menu-styles/menu-treemenu.png\" alt=\"\" width=\"600\" height=\"300\" border=\"0\" /></p>
<p>Tree Menu represents menu items in clear tree-like hierarchy, which is very appropriate for indexing menu. By default all submenu items are collapsed until you select the parent menu item.</p>
<p class=\"content-center\"><span class=\"link-button button-light\"><a href=\"index.php?option=com_content&amp;view=article&amp;id=44&amp;Itemid=192\" class=\"link-action\">See live demo of Tree Menu</a></span></p>
<hr class=\"line-dots\" />
<h3>Div Menu</h3>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/design-features/menu-styles/menu-divmenu.png\" alt=\"Div Menu\" width=\"600\" height=\"175\" border=\"0\" /></p>
<p>Div Menu is simple yet nice menu bar with items separated by slightly visible dashes. This menu is very suitable for footer navigation presentation.</p>', '', '1', '', '', '45', '2011-03-31 03:32:57', '42', '', '2011-07-11 04:08:49', '42', '', '0000-00-00 00:00:00', '2011-03-31 03:32:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '9', '', '1', '', '', '1', '91', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('31', '', 'Module Styles', 'module-styles', '', '<p>JSN Epic provides <strong>2 box designs</strong> for module background styling in Free edition and <strong>4 box designs</strong> in PRO edition. Module styles are configured by module\'s parameter <strong>Module Class Suffix</strong> with very simple syntax.</p>
<p>Take a look around to see how module styles are applied.</p>', '', '1', '', '', '45', '2011-03-31 03:33:27', '42', '', '2011-05-05 09:45:38', '42', '', '0000-00-00 00:00:00', '2011-03-31 03:33:27', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '2', '', '', '', '', '1', '92', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('32', '', 'Multilingual Support', 'multilingual-support', '', '<p>In our templates all wordings of both back-end and front-end are moved to separated language files, so you can easily translate them into any language you want.</p>
<p>Currently our templates support <strong>more then 10 languages</strong> and more to be come in future.</p>
<div class=\"content-center\">
<p>
<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-en.png\" border=\"0\" alt=\"English support\" width=\"600\" height=\"250\" /><br />
<strong>English</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-de.png\" border=\"0\" alt=\"German support\" width=\"600\" height=\"250\" /><br />
<strong>German</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-nl.png\" border=\"0\" alt=\"Dutch support\" width=\"600\" height=\"250\" /><br />
<strong>Dutch</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-it.png\" border=\"0\" alt=\"Italian support\" width=\"600\" height=\"250\" /><br />
<strong>Italian</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-es.png\" border=\"0\" alt=\"Spanish support\" width=\"600\" height=\"250\" /><br />
<strong>Spanish</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-fr.png\" border=\"0\" alt=\"French support\" width=\"600\" height=\"250\" /><br />
<strong>French</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-ja.png\" border=\"0\" alt=\"Japanese support\" width=\"600\" height=\"250\" /><br />
<strong>Japanese</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-da.png\" border=\"0\" alt=\"Danish support\" width=\"600\" height=\"250\" /><br />
<strong>Danish</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-ru.png\" border=\"0\" alt=\"Russian support\" width=\"600\" height=\"250\" /><br />
<strong>Russian</strong> <br />

<img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/multilingual-support/seo-lang-pl.png\" border=\"0\" alt=\"Polish support\" width=\"600\" height=\"250\" /><br />
<strong>Polish</strong> <br />

</p>
</div>', '', '1', '', '', '46', '2011-03-31 03:33:57', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:33:57', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '2', '', '', '1', '8', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('33', '', 'My MySQL database does not support UTF-8. Do I have a problem?', 'my-mysql-database-does-not-support-utf-8-do-i-have-a-problem', '', 'No you don\'t. Versions of MySQL lower than 4.1 do not have built in UTF-8 support. However, Joomla! 1.5 has made provisions for backward compatibility and is able to use UTF-8 on older databases. Let the installer take care of all the settings and there is no need to make any changes to the database (charset, collation, or any other).', '', '1', '', '', '38', '2011-03-31 03:34:27', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:34:27', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '4', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('34', '', 'Newsflash 1', 'newsflash-1', '', '<p>Joomla! makes it easy to launch a Web site of any kind. Whether you want a brochure site or you are building a large online community, Joomla! allows you to deploy a new site in minutes and add extra functionality as you need it. The hundreds of available Extensions will help to expand your site and allow you to deliver new services that extend your reach into the Internet.</p>', '', '1', '', '', '51', '2011-03-31 03:36:56', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:36:56', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '4', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('35', '', 'Newsflash 2', 'newsflash-2', '', '<p>The one thing about a Web site, it always changes! Joomla! makes it easy to add Articles, content, images, videos, and more. Site administrators can edit and manage content \'in-context\' by clicking the \'Edit\' link. Webmasters can also edit content through a graphical Control Panel that gives you complete control over your site.</p>', '', '1', '', '', '51', '2011-03-31 03:37:22', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:37:22', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '3', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('36', '', 'Newsflash 3', 'newsflash-3', '', '<p>With a library of thousands of free <a href=\"http://extensions.joomla.org\" target=\"_blank\" title=\"The Joomla! Extensions Directory\">Extensions</a>, you can add what you need as your site grows. Don\'t wait, look through the <a href=\"http://extensions.joomla.org/\" target=\"_blank\" title=\"Joomla! Extensions\">Joomla! Extensions</a>  library today. </p>', '', '1', '', '', '51', '2011-03-31 03:37:49', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:37:49', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '2', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('37', '', 'Newsflash 4', 'newsflash-4', '', 'Yesterday all servers in the U.S. went out on strike in a bid to get more RAM and better CPUs. A spokes person said that the need for better RAM was due to some fool increasing the front-side bus speed. In future, buses will be told to slow down in residential motherboards.', '', '1', '', '', '51', '2011-03-31 03:38:17', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:38:17', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('38', '', 'Newsflash 5', 'newsflash-5', '', 'Joomla! 1.5 - \'Experience the Freedom\'!. It has never been easier to create your own dynamic Web site. Manage all your content from the best CMS admin interface and in virtually any language you speak.', '', '1', '', '', '51', '2011-03-31 03:38:43', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:38:43', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('39', '', 'Painless Configuration ', 'painless-configuration', '', '<p>All JoomlaShine templates can be effortlessly configured by template parameters. In template setting page, you will find <strong>16 template parameters</strong> arranged into logical groups for convenient operation.</p>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/painless-configuration/params-preview.png\" border=\"0\" alt=\"Over 40 parameters to pick up\" width=\"600\" height=\"350\" /></p>
<hr class=\"line-dots\" />
<h3>Set parameters without confusion</h3>
<p>Most parameters are designed that way that you can simply select options without confusion about what value to define. All parameters are equipped with description text for easier understanding.</p>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/painless-configuration/params-layout.png\" border=\"0\" alt=\"Parameters to control layout dimensions\" width=\"600\" height=\"390\" /><br /> <em>Parameters to control layout dimensions</em></p>', '', '1', '', '', '46', '2011-03-31 03:39:21', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:39:21', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '46', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('40', '', 'Platforms and Open Standards', 'platforms-and-open-standards', '', '<p class=\"MsoNormal\">Joomla! runs on any platform including Windows, most flavours of Linux, several Unix versions, and the Apple OS/X platform.  Joomla! depends on PHP and the MySQL database to deliver dynamic content.  </p>            <p class=\"MsoNormal\">The minimum requirements are:</p>      <ul><li>Apache 1.x, 2.x and higher</li><li>PHP 4.3 and higher</li><li>MySQL 3.23 and higher</li></ul>It will also run on alternative server platforms such as Windows IIS - provided they support PHP and MySQL - but these require additional configuration in order for the Joomla! core package to be successful installed and operated.', '', '1', '', '', '41', '2011-03-31 03:39:52', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:39:52', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('41', '', 'RTL Layout Support', 'rtl-layout-support', '', '<p>All JoomlaShine templates are equipped with <strong>native RTL layout support</strong>. We spent huge amount of time tweaking every tiny details of the template to make it look absolutely awesome in RTL mode. Everything is horizontally-flipped including dropdown main menu and side menu.</p>
<p class=\"content-center\"><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/content/template-details/advanced-stuff/rtl-layout-support/layout-rtl.jpg\" border=\"0\" alt=\"RTL layout support\" width=\"600\" height=\"400\" /></p>', '', '1', '', '', '46', '2011-03-31 03:40:20', '42', '', '2012-07-30 00:30:10', '42', '', '0000-00-00 00:00:00', '2011-03-31 03:40:20', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '', '', '', '', '1', '98', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('42', '', 'Support and Documentation', 'support-and-documentation', '', '<h1>Support </h1><p>Support for the Joomla! CMS can be found on several places. The best place to start would be the <a href=\"http://docs.joomla.org/\" target=\"_blank\" title=\"Joomla! Official Documentation Wiki\">Joomla! Official Documentation Wiki</a>. Here you can help yourself to the information that is regularly published and updated as Joomla! develops. There is much more to come too!</p> <p>Of course you should not forget the Help System of the CMS itself. On the <em>topmenu </em>in the Back-end Control panel you find the Help button which will provide you with lots of explanation on features.</p> <p>Another great place would of course be the <a href=\"http://forum.joomla.org/\" target=\"_blank\" title=\"Forum\">Forum</a> . On the Joomla! Forum you can find help and support from Community members as well as from Joomla! Core members and Working Group members. The forum contains a lot of information, FAQ\'s, just about anything you are looking for in terms of support.</p> <p>Two other resources for Support are the <a href=\"http://developer.joomla.org/\" target=\"_blank\" title=\"Joomla! Developer Site\">Joomla! Developer Site</a> and the <a href=\"http://extensions.joomla.org/\" target=\"_blank\" title=\"Joomla! Extensions Directory\">Joomla! Extensions Directory</a> (JED). The Joomla! Developer Site provides lots of technical information for the experienced Developer as well as those new to Joomla! and development work in general. The JED whilst not a support site in the strictest sense has many of the Extensions that you will need as you develop your own Web site.</p> <p>The Joomla! Developers and Bug Squad members are regularly posting their blog reports about several topics such as programming techniques and security issues.</p> <h1>Documentation</h1> <p>Joomla! Documentation can of course be found on the <a href=\"http://docs.joomla.org/\" target=\"_blank\" title=\"Joomla! Official Documentation Wiki\">Joomla! Official Documentation Wiki</a>. You can find information for beginners, installation, upgrade, Frequently Asked Questions, developer topics, and a lot more. The Documentation Team helps oversee the wiki but you are invited to contribute content, as well.</p> <p>There are also books written about Joomla! You can find a listing of these books in the <a href=\"http://shop.joomla.org/\" target=\"_blank\" title=\"Joomla! Shop\">Joomla! Shop</a>.</p>', '', '1', '', '', '41', '2011-03-31 03:40:58', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:40:58', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('43', '', 'The Joomla! Community', 'the-joomla-community', '', '<p><strong>Got a question? </strong>With more than 210,000 members, the Joomla! Discussion Forums at <a href=\"http://forum.joomla.org/\" target=\"_blank\" title=\"Forums\">forum.joomla.org</a> are a great resource for both new and experienced users. Ask your toughest questions the community is waiting to see what you\'ll do with your Joomla! site.</p><p><strong>Do you want to show off your new Joomla! Web site?</strong> Visit the <a href=\"http://forum.joomla.org/viewforum.php?f=514\" target=\"_blank\" title=\"Site Showcase\">Site Showcase</a>section of our forum.</p><p><strong>Do you want to contribute?</strong></p><p>If you think working with Joomla is fun, wait until you start working on it. We\'re passionate about helping Joomla users become contributors. There are many ways you can help Joomla\'s development:</p><ul><li>Submit news about Joomla. We syndicate Joomla-related news on <a href=\"http://news.joomla.org\" target=\"_blank\" title=\"JoomlaConnect\">JoomlaConnect<sup>TM</sup></a>. If you have Joomla news that you would like to share with the community, find out how to get connected<a href=\"http://community.joomla.org/connect.html\" target=\"_blank\" title=\"JoomlaConnect\">here</a>.</li><li>Report bugs and request features in our <a href=\"http://joomlacode.org/gf/project/joomla/tracker/\" target=\"_blank\" title=\"Joomla! developement trackers\">trackers</a>. Please read <a href=\"http://docs.joomla.org/Filing_bugs_and_issues\" target=\"_blank\" title=\"Reporting Bugs\">Reporting Bugs</a>, for details on how we like our bug reports served up</li><li>Submit patches for new and/or fixed behaviour. Please read <a href=\"http://docs.joomla.org/Patch_submission_guidelines\" target=\"_blank\" title=\"Submitting Patches\">Submitting Patches</a>, for details on how to submit a patch.</li><li>Join the <a href=\"http://forum.joomla.org/viewforum.php?f=509\" target=\"_blank\" title=\"Joomla! development forums\">developer forums</a> and share your ideas for how to improve Joomla. We\'re always open to suggestions, although we\'re likely to be sceptical of large-scale suggestions without some code to back it up.</li><li>Join any of the <a href=\"http://www.joomla.org/about-joomla/the-project/working-groups.html\" target=\"_blank\" title=\"Joomla! working groups\">Joomla Working Groups</a> and bring your personal expertise to the Joomla community.</li></ul><p>These are just a few ways you can contribute. See<a href=\"http://www.joomla.org/about-joomla/contribute-to-joomla.html\" target=\"_blank\" title=\"Contribute\">Contribute to Joomla</a>for many more ways.</p>', '', '1', '', '', '43', '2011-03-31 03:41:49', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:41:49', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('44', '', 'Tree Menu', 'tree-menu', '', '<p>Tree Menu represents menu items in clear tree-like hierarchy, which is very appropriate for indexing menu. By default all submenu items are collapsed until you select the parent menu item.</p>
<p>To setup Tree Menu you just need to configure module parameter &ldquo;<strong>Menu Class Suffix</strong>&rdquo; appropriately and the menu system will take care of the rest.</p>
<h3>Tree Menu with Rich Text</h3>
<p>Tree Menu can present menu items with icons and descriptive text, pretty much like <a href=\"index.php?option=com_content&amp;view=article&amp;id=29&amp;Itemid=191\">Main Menu</a>.</p>
<p>To setup icons you need to configure menu items appropriately just like Main Menu. There are very detailed instructions in template documentation.</p>', '', '1', '', '', '50', '2011-03-31 03:42:20', '42', '', '2011-07-11 04:07:51', '42', '', '0000-00-00 00:00:00', '2011-03-31 03:42:20', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '3', '', '', '', '', '1', '45', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('45', '', 'Welcome to Joomla!', 'welcome-to-joomla', '', '<div align=\"left\"><strong>Joomla! is a free open source framework and content publishing system designed for quickly creating highly interactive multi-language Web sites, online communities, media portals, blogs and eCommerce applications. <br /></strong></div><p><strong><br /></strong><img src=\"http://demo.joomlashine.com/joomla-templates/jsn_epic/free/images/stories/powered_by.png\" border=\"0\" alt=\"Joomla! Logo\" title=\"Example Caption\" hspace=\"6\" vspace=\"0\" width=\"165\" height=\"68\" align=\"left\" />Joomla! provides an easy-to-use graphical user interface that simplifies the management and publishing of large volumes of content including HTML, documents, and rich media.  Joomla! is used by organisations of all sizes for intranets and extranets and is supported by a community of tens of thousands of users. </p>', 'With a fully documented library of developer resources, Joomla! allows the customisation of every aspect of a Web site including presentation, layout, administration, and the rapid integration with third-party applications.<p>Joomla! now provides more developer power while making the user experience all the more friendly. For those who always wanted increased extensibility, Joomla! 1.5 can make this happen.</p><p>A new framework, ground-up refactoring, and a highly-active development team brings the excitement of \'the next generation CMS\' to your fingertips.  Whether you are a systems architect or a complete \'noob\' Joomla! can take you to the next level of content delivery. \'More than a CMS\' is something we have been playing with as a catchcry because the new Joomla! API has such incredible power and flexibility, you are free to take whatever direction your creative mind takes you and Joomla! can help you get there so much more easily than ever before.</p><p>Thinking Web publishing? Think Joomla!</p>', '1', '', '', '34', '2011-03-31 03:42:49', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:42:49', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('46', '', 'What are the requirements to run Joomla! 1.5?', 'what-are-the-requirements-to-run-joomla-15', '', '<p>Joomla! runs on the PHP pre-processor. PHP comes in many flavours, for a lot of operating systems. Beside PHP you will need a Web server. Joomla! is optimized for the Apache Web server, but it can run on different Web servers like Microsoft IIS it just requires additional configuration of PHP and MySQL. Joomla! also depends on a database, for this currently you can only use MySQL. </p>Many people know from their own experience that it\'s not easy to install an Apache Web server and it gets harder if you want to add MySQL, PHP and Perl. XAMPP, WAMP, and MAMP are easy to install distributions containing Apache, MySQL, PHP and Perl for the Windows, Mac OSX and Linux operating systems. These packages are for localhost installations on non-public servers only.<br />The minimum version requirements are:<br /><ul><li>Apache 1.x or 2.x</li><li>PHP 4.3 or up</li><li>MySQL 3.23 or up</li></ul>For the latest minimum requirements details, see <a href=\"http://www.joomla.org/about-joomla/technical-requirements.html\" target=\"_blank\" title=\"Joomla! Technical Requirements\">Joomla! Technical Requirements</a>.', '', '1', '', '', '38', '2011-03-31 03:43:25', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:43:25', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '3', '', '', '1', '17', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('47', '', 'What happened to the locale setting?', 'what-happened-to-the-locale-setting', '', 'This is now defined in the Language [<em>lang</em>].xml file in the Language metadata settings. If you are having locale problems such as dates do not appear in your language for example, you might want to check/edit the entries in the locale tag. Note that multiple locale strings can be set and the host will usually accept the first one recognised.', '', '1', '', '', '37', '2011-03-31 03:44:29', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:44:29', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '3', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('48', '', 'What is an Uncategorised Article?', 'what-is-an-uncategorised-article', '', 'Most Articles will be assigned to a Section and Category. In many cases, you might not know where you want it to appear so put the Article in the <em>Uncategorized </em>Section/Category. The Articles marked as <em>Uncategorized </em>are handled as static content.', '', '1', '', '', '38', '2011-03-31 03:45:09', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:45:09', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '2', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('49', '', 'What is the difference between Archiving and Trashing an Article? ', 'what-is-the-difference-between-archiving-and-trashing-an-article', '', '<p>When you <em>Archive </em>an Article, the content is put into a state which removes it from your site as published content. The Article is still available from within the Control Panel and can be <em>retrieved </em>for editing or republishing purposes. Trashed Articles are just one step from being permanently deleted but are still available until you Remove them from the Trash Manager. You should use Archive if you consider an Article important, but not current. Trash should be used when you want to delete the content entirely from your site and from future search results.  </p>', '', '1', '', '', '36', '2011-03-31 03:45:37', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:45:37', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('50', '', 'What is the FTP layer for?', 'what-is-the-ftp-layer-for', '', '<p>The FTP Layer allows file operations (such as installing Extensions or updating the main configuration file) without having to make all the folders and files writable. This has been an issue on Linux and other Unix based platforms in respect of file permissions. This makes the site admin\'s life a lot easier and increases security of the site.</p><p>You can check the write status of relevent folders by going to \'\'Help-&gt;System Info\" and then in the sub-menu to \"Directory Permissions\". With the FTP Layer enabled even if all directories are red, Joomla! will operate smoothly.</p><p>NOTE: the FTP layer is not required on a Windows host/server. </p>', '', '1', '', '', '38', '2011-03-31 03:46:09', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:46:09', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('51', '', 'What is the purpose of the collation selection in the installation screen?', 'what-is-the-purpose-of-the-collation-selection-in-the-installation-screen', '', 'The collation option determines the way ordering in the database is done. In languages that use special characters, for instance the German umlaut, the database collation determines the sorting order. If you don\'t know which collation you need, select the \"utf8_general_ci\" as most languages use this. The other collations listed are exceptions in regards to the general collation. If your language is not listed in the list of collations it most likely means that \"utf8_general_ci is suitable.', '', '1', '', '', '39', '2011-03-31 03:46:43', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:46:43', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('52', '', 'What\'s New in 1.5?', 'whats-new-in-15', '', '<p>As with previous releases, Joomla! provides a unified and easy-to-use framework for delivering content for Web sites of all kinds. To support the changing nature of the Internet and emerging Web technologies, Joomla! required substantial restructuring of its core functionality and we also used this effort to simplify many challenges within the current user interface. Joomla! 1.5 has many new features.</p>', '<p style=\"margin-bottom: 0in\">In Joomla! 1.5, you\'ll notice: </p>    <ul><li>     <p style=\"margin-bottom: 0in\">       Substantially improved usability, manageability, and scalability far beyond the original Mambo foundations</p>   </li><li>     <p style=\"margin-bottom: 0in\"> Expanded accessibility to support internationalisation, double-byte characters and right-to-left support for Arabic, Farsi, and Hebrew languages among others</p>   </li><li>     <p style=\"margin-bottom: 0in\"> Extended integration of external applications through Web services and remote authentication such as the Lightweight Directory Access Protocol (LDAP)</p>   </li><li>     <p style=\"margin-bottom: 0in\"> Enhanced content delivery, template and presentation capabilities to support accessibility standards and content delivery to any destination</p>   </li><li>     <p style=\"margin-bottom: 0in\">       A more sustainable and flexible framework for Component and Extension developers</p>   </li><li>     <p style=\"margin-bottom: 0in\">Backward compatibility with previous releases of Components, Templates, Modules, and other Extensions</p></li></ul>', '1', '', '', '42', '2011-03-31 03:47:29', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:47:29', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('53', '', 'Where did the Installers go?', 'where-did-the-installers-go', '', 'The improved Installer can be found under the Extensions Menu. With versions prior to Joomla! 1.5 you needed to select a specific Extension type when you wanted to install it and use the Installer associated with it, with Joomla! 1.5 you just select the Extension you want to upload, and click on install. The Installer will do all the hard work for you.', '', '1', '', '', '37', '2011-03-31 03:48:01', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:48:01', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '2', '', '', '1', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('54', '', 'Where did the Mambots go?', 'where-did-the-mambots-go', '', '<p>Mambots have been renamed as Plugins. </p><p>Mambots were introduced in Mambo and offered possibilities to add plug-in logic to your site mainly for the purpose of manipulating content. In Joomla! 1.5, Plugins will now have much broader capabilities than Mambots. Plugins are able to extend functionality at the framework layer as well.</p>', '', '1', '', '', '37', '2011-03-31 03:48:32', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:48:32', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '1', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('55', '', 'Where is the Static Content Item?', 'where-is-the-static-content-item', '', '<p>In Joomla! versions prior to 1.5 there were separate processes for creating a Static Content Item and normal Content Items. The processes have been combined now and whilst both content types are still around they are renamed as Articles for Content Items and Uncategorized Articles for Static Content Items. </p><p>If you want to create a static item, create a new Article in the same way as for standard content and rather than relating this to a particular Section and Category just select <span style=\"font-style: italic\">Uncategorized</span> as the option in the Section and Category drop down lists.</p>', '', '1', '', '', '37', '2011-03-31 03:49:02', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:49:02', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');
INSERT INTO `np846_content` (`id`, `asset_id`, `title`, `alias`, `title_alias`, `introtext`, `fulltext`, `state`, `sectionid`, `mask`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `parentid`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES ('56', '', 'Why does Joomla! 1.5 use UTF-8 encoding?', 'why-does-joomla-15-use-utf-8-encoding', '', '<p>Well... how about never needing to mess with encoding settings again?</p><p>Ever needed to display several languages on one page or site and something always came up in Giberish?</p><p>With utf-8 (a variant of Unicode) glyphs (character forms) of basically all languages can be displayed with one single encoding setting. </p>', '', '1', '', '', '38', '2011-03-31 03:49:35', '42', '', '0000-00-00 00:00:00', '', '', '0000-00-00 00:00:00', '2011-03-31 03:49:35', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\"}', '1', '', '', '', '', '1', '', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', '', '*', '');

DROP TABLE IF EXISTS `np846_content_frontpage`;
CREATE TABLE `np846_content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `np846_content_frontpage` (`content_id`, `ordering`) VALUES ('15', '1');
INSERT INTO `np846_content_frontpage` (`content_id`, `ordering`) VALUES ('67', '2');

DROP TABLE IF EXISTS `np846_content_rating`;
CREATE TABLE `np846_content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_languages`;
CREATE TABLE `np846_languages` (
  `lang_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lang_code` char(7) NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_native` varchar(50) NOT NULL,
  `sef` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `description` varchar(512) NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `sitename` varchar(1024) NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `idx_sef` (`sef`),
  UNIQUE KEY `idx_image` (`image`),
  UNIQUE KEY `idx_langcode` (`lang_code`),
  KEY `idx_access` (`access`),
  KEY `idx_ordering` (`ordering`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `np846_languages` (`lang_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES ('1', 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', '1', '', '');

DROP TABLE IF EXISTS `np846_newsfeeds`;
CREATE TABLE `np846_newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `link` varchar(200) NOT NULL DEFAULT '',
  `filename` varchar(200) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_weblinks`;
CREATE TABLE `np846_weblinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `catid` int(11) NOT NULL DEFAULT '0',
  `sid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `url` varchar(250) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(11) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `archived` tinyint(1) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '1',
  `access` int(11) NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if link is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_contact_details`;
CREATE TABLE `np846_contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `imagepos` varchar(20) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_xreference` (`xreference`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `np846_contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `imagepos`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`) VALUES ('1', 'Name', 'name', 'Position', 'Street', 'Suburb', 'State', 'Country', 'Zip Code', 'Telephone', 'Fax', '<p>Miscellanous info</p>', 'images/powered_by.png', NULL, 'email@email.com', '', '1', '', '0000-00-00 00:00:00', '1', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_misc\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":\"\",\"linkb_name\":\"\",\"linkb\":\"\",\"linkc_name\":\"\",\"linkc\":\"\",\"linkd_name\":\"\",\"linkd\":\"\",\"linke_name\":\"\",\"linke\":\"\",\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', '42', '26', '1', '', '', '', '', '', '*', '2011-03-29 07:08:12', '42', '', '0000-00-00 00:00:00', '', '', '', '{\"robots\":\"\",\"rights\":\"\"}', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `np846_imageshow_parameters`;
CREATE TABLE `np846_imageshow_parameters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `show_quick_icons` tinyint(1) DEFAULT '1',
  `enable_update_checking` tinyint(1) DEFAULT '1',
  `number_of_images_on_loading` varchar(50) DEFAULT '30',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_messages`;
CREATE TABLE `np846_imageshow_messages` (
  `msg_id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_screen` varchar(150) DEFAULT NULL,
  `published` tinyint(1) DEFAULT '1',
  `ordering` int(11) DEFAULT '0',
  PRIMARY KEY (`msg_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_showcase`;
CREATE TABLE `np846_imageshow_showcase` (
  `showcase_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `showcase_title` varchar(255) DEFAULT NULL,
  `published` tinyint(1) DEFAULT '0',
  `ordering` int(11) DEFAULT '0',
  `general_overall_width` char(30) DEFAULT NULL,
  `general_overall_height` char(30) DEFAULT NULL,
  `date_created` datetime DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`showcase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_showlist`;
CREATE TABLE `np846_imageshow_showlist` (
  `showlist_id` int(11) NOT NULL AUTO_INCREMENT,
  `showlist_title` varchar(255) DEFAULT NULL,
  `published` tinyint(1) DEFAULT '0',
  `override_title` tinyint(1) DEFAULT '0',
  `override_description` tinyint(1) DEFAULT '0',
  `override_link` tinyint(1) DEFAULT '0',
  `ordering` int(11) DEFAULT '0',
  `access` tinyint(3) DEFAULT NULL,
  `hits` int(11) DEFAULT NULL,
  `description` text,
  `showlist_link` text,
  `alter_autid` int(11) DEFAULT '0',
  `date_create` datetime DEFAULT NULL,
  `image_source_type` varchar(45) DEFAULT '',
  `image_source_name` varchar(45) DEFAULT '',
  `image_source_profile_id` int(11) DEFAULT '0',
  `authorization_status` tinyint(1) DEFAULT '0',
  `date_modified` datetime DEFAULT '0000-00-00 00:00:00',
  `image_loading_order` char(30) DEFAULT NULL,
  `show_exif_data` char(100) DEFAULT '',
  PRIMARY KEY (`showlist_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_images`;
CREATE TABLE `np846_imageshow_images` (
  `image_id` int(11) NOT NULL AUTO_INCREMENT,
  `showlist_id` int(11) NOT NULL,
  `image_extid` varchar(255) DEFAULT NULL,
  `album_extid` varchar(255) DEFAULT NULL,
  `image_small` varchar(255) DEFAULT NULL,
  `image_medium` varchar(255) DEFAULT NULL,
  `image_big` text,
  `image_title` varchar(255) DEFAULT NULL,
  `image_description` text,
  `image_link` varchar(255) DEFAULT NULL,
  `ordering` int(11) DEFAULT '0',
  `custom_data` tinyint(1) DEFAULT '0',
  `sync` tinyint(1) DEFAULT '0',
  `image_size` varchar(25) DEFAULT NULL,
  `exif_data` text,
  PRIMARY KEY (`image_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_theme_profile`;
CREATE TABLE `np846_imageshow_theme_profile` (
  `theme_id` int(11) NOT NULL DEFAULT '0',
  `showcase_id` int(11) NOT NULL DEFAULT '0',
  `theme_name` varchar(255) NOT NULL DEFAULT '',
  `theme_style_name` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_source_profile`;
CREATE TABLE `np846_imageshow_source_profile` (
  `external_source_profile_id` int(11) NOT NULL AUTO_INCREMENT,
  `external_source_id` int(11) NOT NULL,
  PRIMARY KEY (`external_source_profile_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_external_source_picasa`;
CREATE TABLE `np846_imageshow_external_source_picasa` (
  `external_source_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `external_source_profile_title` varchar(255) DEFAULT NULL,
  `picasa_username` varchar(255) DEFAULT '',
  `picasa_thumbnail_size` char(30) DEFAULT '144',
  `picasa_image_size` char(30) DEFAULT '1024',
  PRIMARY KEY (`external_source_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_theme_classic_flash`;
CREATE TABLE `np846_imageshow_theme_classic_flash` (
  `theme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `imgpanel_presentation_mode` char(30) DEFAULT '0',
  `imgpanel_img_transition_type_fit` char(30) DEFAULT '',
  `imgpanel_img_click_action_fit` char(30) DEFAULT '',
  `imgpanel_img_open_link_in_fit` char(30) DEFAULT 'new-browser',
  `imgpanel_img_transition_type_expand` char(30) DEFAULT '',
  `imgpanel_img_motion_type_expand` char(30) DEFAULT '',
  `imgpanel_img_zooming_type_expand` char(30) DEFAULT 'center',
  `imgpanel_img_click_action_expand` char(30) DEFAULT '',
  `imgpanel_img_open_link_in_expand` char(30) DEFAULT 'new-browser',
  `imgpanel_img_show_image_shadow_fit` char(30) DEFAULT 'yes',
  `imgpanel_bg_type` char(30) DEFAULT '',
  `imgpanel_bg_value` char(255) DEFAULT NULL,
  `imgpanel_show_watermark` char(30) DEFAULT 'no',
  `imgpanel_watermark_path` char(255) DEFAULT NULL,
  `imgpanel_watermark_position` char(30) DEFAULT '',
  `imgpanel_watermark_offset` char(30) DEFAULT NULL,
  `imgpanel_watermark_opacity` char(30) DEFAULT NULL,
  `imgpanel_show_overlay_effect` char(30) DEFAULT 'no',
  `imgpanel_overlay_effect_type` char(30) DEFAULT NULL,
  `imgpanel_show_inner_shawdow` char(30) DEFAULT 'yes',
  `imgpanel_inner_shawdow_color` char(30) DEFAULT NULL,
  `thumbpanel_show_panel` char(30) DEFAULT NULL,
  `thumbpanel_panel_position` char(30) DEFAULT '',
  `thumbpanel_collapsible_position` char(30) DEFAULT 'yes',
  `thumbpanel_thumb_browsing_mode` char(30) DEFAULT '',
  `thumbpanel_show_thumb_status` char(30) DEFAULT 'yes',
  `thumbpanel_active_state_color` char(30) DEFAULT NULL,
  `thumbpanel_presentation_mode` char(30) DEFAULT '',
  `thumbpanel_border` char(30) DEFAULT NULL,
  `thumbpanel_enable_big_thumb` char(30) DEFAULT 'yes',
  `thumbpanel_big_thumb_size` char(30) DEFAULT NULL,
  `thumbpanel_thumb_row` char(30) DEFAULT NULL,
  `thumbpanel_thumb_width` char(30) DEFAULT NULL,
  `thumbpanel_thumb_height` char(30) DEFAULT NULL,
  `thumbpanel_thumb_opacity` char(30) DEFAULT '50',
  `thumbpanel_big_thumb_color` char(30) DEFAULT NULL,
  `thumbpanel_thumb_border` char(30) DEFAULT NULL,
  `thumbpanel_thumnail_panel_color` char(30) DEFAULT NULL,
  `thumbpanel_thumnail_normal_state` char(30) DEFAULT NULL,
  `infopanel_panel_position` char(30) DEFAULT '',
  `infopanel_presentation` char(30) DEFAULT NULL,
  `infopanel_bg_color_fill` char(30) DEFAULT NULL,
  `infopanel_panel_click_action` char(30) DEFAULT NULL,
  `infopanel_open_link_in` char(30) DEFAULT 'new-browser',
  `infopanel_show_title` char(30) DEFAULT 'yes',
  `infopanel_title_css` char(250) DEFAULT NULL,
  `infopanel_show_des` char(30) DEFAULT 'yes',
  `infopanel_des_lenght_limitation` char(30) DEFAULT '',
  `infopanel_des_css` char(250) DEFAULT NULL,
  `infopanel_show_link` char(30) DEFAULT 'no',
  `infopanel_link_css` char(250) DEFAULT NULL,
  `toolbarpanel_panel_position` char(30) DEFAULT '',
  `toolbarpanel_presentation` char(30) DEFAULT '0',
  `toolbarpanel_show_image_navigation` char(30) DEFAULT 'yes',
  `toolbarpanel_slideshow_player` char(30) DEFAULT 'yes',
  `toolbarpanel_show_fullscreen_switcher` char(30) DEFAULT 'yes',
  `toolbarpanel_show_tooltip` char(30) DEFAULT 'no',
  `slideshow_hide_thumb_panel` char(30) DEFAULT 'yes',
  `slideshow_slide_timing` char(50) DEFAULT NULL,
  `slideshow_hide_image_navigation` char(30) DEFAULT 'yes',
  `slideshow_auto_play` char(30) DEFAULT 'no',
  `slideshow_show_status` char(30) DEFAULT 'yes',
  `slideshow_enable_ken_burn_effect` char(30) DEFAULT 'yes',
  `slideshow_looping` char(30) DEFAULT 'yes',
  `general_round_corner_radius` char(30) DEFAULT '',
  `general_border_color` char(30) DEFAULT '',
  `general_background_color` char(30) DEFAULT '',
  `general_border_stroke` char(30) DEFAULT '',
  PRIMARY KEY (`theme_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_theme_classic_javascript`;
CREATE TABLE `np846_imageshow_theme_classic_javascript` (
  `theme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `imgpanel_presentation_mode` char(30) DEFAULT '0',
  `imgpanel_img_click_action_fit` char(30) DEFAULT '',
  `imgpanel_img_open_link_in_fit` char(30) DEFAULT 'new-browser',
  `imgpanel_img_click_action_expand` char(30) DEFAULT '',
  `imgpanel_img_open_link_in_expand` char(30) DEFAULT 'new-browser',
  `imgpanel_bg_type` char(30) DEFAULT '',
  `imgpanel_bg_value` char(255) DEFAULT NULL,
  `thumbpanel_show_panel` char(30) DEFAULT NULL,
  `thumbpanel_panel_position` char(30) DEFAULT '',
  `thumbpanel_active_state_color` char(30) DEFAULT NULL,
  `thumbpanel_thumnail_normal_state` char(30) DEFAULT NULL,
  `thumbpanel_border` char(30) DEFAULT NULL,
  `thumbpanel_thumb_width` char(30) DEFAULT NULL,
  `thumbpanel_thumb_height` char(30) DEFAULT NULL,
  `thumbpanel_thumnail_panel_color` char(30) DEFAULT NULL,
  `infopanel_panel_position` char(30) DEFAULT '',
  `infopanel_presentation` char(30) DEFAULT NULL,
  `infopanel_bg_color_fill` char(30) DEFAULT NULL,
  `infopanel_panel_click_action` char(30) DEFAULT NULL,
  `infopanel_open_link_in` char(30) DEFAULT 'new-browser',
  `infopanel_show_title` char(30) DEFAULT 'yes',
  `infopanel_title_css` char(250) DEFAULT NULL,
  `infopanel_show_des` char(30) DEFAULT 'yes',
  `infopanel_des_lenght_limitation` char(30) DEFAULT '',
  `infopanel_des_css` char(250) DEFAULT NULL,
  `infopanel_show_link` char(30) DEFAULT 'no',
  `infopanel_link_css` char(250) DEFAULT NULL,
  `toolbarpanel_presentation` char(30) DEFAULT '0',
  `slideshow_slide_timing` char(50) DEFAULT NULL,
  `slideshow_auto_play` char(30) DEFAULT 'no',
  `slideshow_looping` char(30) DEFAULT 'yes',
  `general_round_corner_radius` char(30) DEFAULT '',
  `general_border_color` char(30) DEFAULT '',
  `general_background_color` char(30) DEFAULT '',
  `general_border_stroke` char(30) DEFAULT '',
  PRIMARY KEY (`theme_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_theme_classic_parameters`;
CREATE TABLE `np846_imageshow_theme_classic_parameters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `general_swf_library` tinyint(1) DEFAULT '0',
  `root_url` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_theme_slider`;
CREATE TABLE `np846_imageshow_theme_slider` (
  `theme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `img_transition_effect` char(30) DEFAULT 'random',
  `toolbar_navigation_arrows_presentation` char(30) DEFAULT 'show-on-mouse-over',
  `toolbar_slideshow_player_presentation` char(30) DEFAULT 'hide',
  `caption_show_caption` char(30) DEFAULT 'yes',
  `caption_title_css` text,
  `caption_description_css` text,
  `caption_link_css` text,
  `caption_caption_opacity` char(30) DEFAULT '75',
  `caption_title_show` char(30) DEFAULT 'yes',
  `caption_description_show` char(30) DEFAULT 'yes',
  `caption_link_show` char(30) DEFAULT 'no',
  `slideshow_slide_timming` int(11) DEFAULT '6',
  `slideshow_pause_on_mouseover` char(30) DEFAULT 'yes',
  `slideshow_auto_play` char(30) DEFAULT 'yes',
  `thumnail_panel_position` char(30) DEFAULT 'right',
  `thumbnail_panel_presentation` char(30) DEFAULT 'show',
  `thumbnail_presentation_mode` char(30) DEFAULT 'numbers',
  `thumbnail_active_state_color` char(30) DEFAULT '#CC3333',
  PRIMARY KEY (`theme_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `np846_imageshow_theme_grid`;
CREATE TABLE `np846_imageshow_theme_grid` (
  `theme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `img_layout` char(5) DEFAULT 'fixed',
  `background_color` char(30) DEFAULT '#ffffff',
  `thumbnail_width` int(11) DEFAULT '50',
  `thumbnail_height` int(11) DEFAULT '50',
  `thumbnail_space` int(11) DEFAULT '10',
  `thumbnail_border` int(11) DEFAULT '3',
  `thumbnail_rounded_corner` int(11) DEFAULT '3',
  `thumbnail_border_color` char(30) DEFAULT '#ffffff',
  `thumbnail_shadow` char(1) DEFAULT '1',
  PRIMARY KEY (`theme_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

