/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.policies.UploadPolicy;

class JUploadTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -1241261479500810699L;
    DataFlavor fileListFlavor = DataFlavor.javaFileListFlavor;
    JUploadPanel uploadPanel = null;
    UploadPolicy uploadPolicy = null;

    public JUploadTransferHandler(UploadPolicy uploadPolicy, JUploadPanel uploadPanel) {
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPanel;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                List fileList = (List)t.getTransferData(this.fileListFlavor);
                File[] fileArray = (File[])fileList.toArray();
                this.uploadPanel.getFilePanel().addFiles(fileArray, DefaultFileData.getRoot(fileArray));
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                this.uploadPolicy.displayErr(this.getClass().getName() + ".importData()", ufe);
            }
            catch (IOException ioe) {
                this.uploadPolicy.displayErr(this.getClass().getName() + ".importData()", ioe);
            }
        }
        return false;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!this.fileListFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

